﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Size
{
    [Table("D_SS2007010201_1")]
    class Class
    {
        /// <summary>
        /// Version ID of the enclosing file
        /// </summary>
        [ForeignKey(typeof(Version), OnDelete = "cascade")]
        public int ID { get; set; }

        /// <summary>
        /// Class name, including namespace
        /// </summary>
        [Text]
        public string Module { get; set; }

        /// <summary>
        /// Lines of code
        /// </summary>
        public int LOC { get; set; }

        /// <summary>
        /// Number of methods
        /// </summary>
        public int MTD { get; set; }

        /// <summary>
        /// Number of datafields/properties
        /// </summary>
        public int PROP { get; set; }

        /// <summary>
        /// McCabe complexity
        /// </summary>
        public int MCB { get; set; }

        /// <summary>
        /// Number of invocations, total of all methods
        /// </summary>
        public int INV { get; set; }

        /// <summary>
        /// Lines of comment
        /// </summary>
        public int COM { get; set; }

        /// <summary>
        /// Weighted methods per class (all)
        /// </summary>
        public int WMC1 { get; set; }

        /// <summary>
        /// Weighted methods per class (visible)
        /// </summary>
        public int WMCv { get; set; }

        /// <summary>
        /// Depth of inheritance tree
        /// </summary>
        public int DIT { get; set; }

        /// <summary>
        /// Number of children
        /// </summary>
        public int NOC { get; set; }

        /// <summary>
        /// Coupling between objects
        /// </summary>
        public int CBO { get; set; }

        /// <summary>
        /// Fan-in (visible)
        /// </summary>
        public int FIv { get; set; }

        /// <summary>
        /// Fan-in (concrete)
        /// </summary>
        public int FIc { get; set; }

        /// <summary>
        /// Fan-in
        /// </summary>
        public int FI { get; set; }

        /// <summary>
        /// Fan-out (visible)
        /// </summary>
        public int FOv { get; set; }

        /// <summary>
        /// Fan-out (concrete)
        /// </summary>
        public int FOc { get; set; }

        /// <summary>
        /// Fan-out
        /// </summary>
        public int FO { get; set; }

        /// <summary>
        /// Information flow (visible)
        /// </summary>
        public int IF4v { get; set; }

        /// <summary>
        /// Information flow (concrete)
        /// </summary>
        public int IF4c { get; set; }

        /// <summary>
        /// Information flow
        /// </summary>
        public int IF4 { get; set; }
    }
}
