﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Size
{
    [Table("M_SS2007010201")]
    class File
    {
        /// <summary>
        /// Version ID of the file
        /// </summary>
        [PrimaryKey]
        [ForeignKey(typeof(Version), OnDelete = "cascade")]
        public int ID { get; set; }

        /// <summary>
        /// Number of classes
        /// </summary>
        public int MOD { get; set; }

        /// <summary>
        /// Number of methods, total of all classes
        /// </summary>
        public int MTD { get; set; }

        /// <summary>
        /// Lines of code
        /// </summary>
        public int LOC { get; set; }

        /// <summary>
        /// Total McCabe Complexity
        /// </summary>
        public int MCB { get; set; }

        /// <summary>
        /// Number of invocations, total of all classes
        /// </summary>
        public int INV { get; set; }

        /// <summary>
        /// Lines of comment
        /// </summary>
        public int COM { get; set; }

        /// <summary>
        /// Number of imports
        /// </summary>
        public int IDEP { get; set; }

        /// <summary>
        /// Information flow
        /// </summary>
        public int IF4 { get; set; }

        /// <summary>
        /// Information flow (visible)
        /// </summary>
        public int IF4v { get; set; }

        /// <summary>
        /// Information flow (concrete)
        /// </summary>
        public int IF4c { get; set; }
    }
}
