﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using SolidTA.TFSImporter.Exceptions;
using ManyConsole;

namespace SolidTA.TFSImporter
{
    class Program
    {
        static int Main(string[] args)
        {
            try
            {
                var commands = GetCommands();

                return ConsoleCommandDispatcher.DispatchCommand(commands, args, Console.Out);
            }
            catch (CancelledException)
            {
                return (int)ExitCode.Cancelled;
            }
            catch (AbortException e)
            {
                Console.WriteLine(e.Message);

                return (int)e.ExitCode;
            }
#if !DEBUG
            catch (Exception e)
            {
                Console.WriteLine(e.Message);

                return (int)ExitCode.Exception;
            }
#endif
        }

        static IEnumerable<ConsoleCommand> GetCommands()
        {
            return ConsoleCommandDispatcher.FindCommandsInSameAssemblyAs(typeof(Program));
        }

        #region unmanaged

        // Declare the SetConsoleCtrlHandler function as external and receiving a delegate.
        [DllImport("Kernel32")]
        public static extern bool SetConsoleCtrlHandler(HandlerRoutine Handler, bool Add);

        #endregion
    }

    #region unmanaged

    // A delegate type to be used as the handler routine for SetConsoleCtrlHandler.
    public delegate bool HandlerRoutine(CtrlTypes CtrlType);

    // An enumerated type for the control messages sent to the handler routine.
    public enum CtrlTypes
    {
        CTRL_C_EVENT = 0,
        CTRL_BREAK_EVENT,
        CTRL_CLOSE_EVENT,
        CTRL_LOGOFF_EVENT = 5,
        CTRL_SHUTDOWN_EVENT
    }

    #endregion
}
