﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using Microsoft.TeamFoundation.Client;

namespace SolidTA.TFSImporter
{
    class TFSServer
    {
        private TfsTeamProjectCollection Server;

        public void Connect(string url, string user, string password)
        {
            var provider = new UICredentialsProvider();

            Uri uri = ParseUrl(url);

            if (String.IsNullOrEmpty(user))
            {
                Server = new TfsTeamProjectCollection(uri, provider);
            }
            else
            {
                var credentials = GetCredentials(user, password);

                Server = new TfsTeamProjectCollection(uri, credentials, provider);
            }

            Server.EnsureAuthenticated();
        }

        protected Uri ParseUrl(string url)
        {
            if (!Uri.IsWellFormedUriString(url, UriKind.Absolute))
            {
                var servers = RegisteredTfsConnections.GetConfigurationServers();
                var registered = servers.FirstOrDefault(s => String.Equals(s.Name, url, StringComparison.OrdinalIgnoreCase));
                
                if (registered == null)
                {
                    throw new ArgumentException("The given URL is invalid and could not be found as a TFS instance.");
                }

                return registered.Uri;
            }
            else
            {
                return new Uri(url);
            }
        }

        protected ICredentials GetCredentials(string user, string password)
        {
            int split = user.IndexOf('\\');
            if (split >= 0)
            {
                string domain = user.Substring(0, split);

                return new NetworkCredential(user.Substring(split + 1), password, domain);
            }
            else
            {
                return new NetworkCredential(user, password);
            }
        }

        public T GetService<T>()
        {
            return Server.GetService<T>();
        }

    }
}
