#include <assert.h>
#include "Voxelizer.h"
#include "cc/time/WallTimer.h"
#include "cc/math/common.h"

using namespace std;

static int carve_x = 1;
static int carve_y = 1;
static int carve_z = 1;





Voxelizer::Voxelizer(Voxels& voxels_ref, Mesh& mesh_ref, GLwindow *win_p) : VoxelFilter(voxels_ref), mesh(mesh_ref)
{
  dilated = 0;
  step_by_step = 0;
  this->win_p = win_p;
  mesh_view_p = new MeshView(&mesh);  
}


Voxelizer::~Voxelizer()
{ delete mesh_view_p; } 

void Voxelizer::parity_vote_voxelize(int skip_carve)
{
  WallTimer timer("voxelize", 0);
  timer.start();

  // use _both_ methods, every voxel set in old method gets vote of 3
  if (!skip_carve) 
  {
    carve_voxelize();
    int size = voxels.get_size();
    for(int i=0; i < size; ++i)
      if (voxels[i]) voxels[i] = 3;  // 3 votes for every remaining voxel
  }
  
  cout << "Voxelizer::parity_vote_voxelize" << endl;

  // new method starts here
  blue_buffer = new GLubyte[wxh];
  assert(blue_buffer);

  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE);
  glDisable(GL_LIGHTING);
  glDisable(GL_DITHER);
  glShadeModel(GL_FLAT);
  glColor3ub(255, 128, 1);  // go for a more orangy look
  mesh_view_p->set_colour(255, 128, (byte) 1);
  //  mesh_view_p->set_use_no_colour(1);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);

  glPixelStorei(GL_PACK_ALIGNMENT, 1);
  glReadBuffer(GL_BACK);
  glDrawBuffer(GL_BACK);

  //Execute 2 passes per axis, accumulate results
  passDim(1, 0.5, 0.5, 0.5, 0.5, 0.5, 0, 0, 1, depth,  X,  1, 0);		//X from 1 to 0
  passDim(0, 0.5, 0.5, 1  , 0.5, 0.5, 0, 0, 1, depth,  X, -1, 1);		//X from 0 to 1
  passDim(0.5, 1, 0.5, 0.5, 0  , 0.5, 0, 0, 1, width,  Y, -1, 0);		//Y from 1 to 0
  passDim(0.5, 0, 0.5, 0.5, 1  , 0.5, 0, 0, 1, width,  Y,  1, 1);		//Y from 0 to 1	
  passDim(0.5, 0.5, 1, 0.5, 0.5, 0  , 0, 1, 0, height, Z,  1, 0);		//Z from 1 to 0
  passDim(0.5, 0.5, 0, 0.5, 0.5, 1  , 0, 1, 0, height, Z, -1, 1);		//Z from 0 to 1
  
  //Fill voxel array from votes
  cout<<"Process votes.."<<endl;
  voxels.process_votes();
  voxels.init_types();
  
  delete[] blue_buffer; blue_buffer = 0;
  
  timer.stop();
  cout << "Voxelizer::voxelize took " << timer.elapsed() << " seconds" << endl;
  
}  // Voxelizer::voxelize




void Voxelizer::passDim(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ,
					    int N, int dir, int sw, int flag)
{
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(eyeX,eyeY,eyeZ,centerX,centerY,centerZ,upX,upY,upZ);
  
  for(int i=0; i < N; ++i)
  {
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-0.5, 0.5, -0.5, 0.5, (i + 0.5) / N, 1.0);
  
    win_p->clear();
    mesh_view_p->draw_faces();
    glFlush();
    glFinish();
    read_screen_buffer(blue_buffer);
    voxels.vote(blue_buffer, dir, sw, (flag)? i:N-i-1);
    win_p->swap_buffers();
  } 
}



void Voxelizer::carve_voxelize()
{
  cout << "Voxelizer::carve_voxelize";
  if (dilated) cout << "  (dilated)";
  cout << endl;

  WallTimer timer("voxelize", 0);
  timer.start();

  win_p->make_current();
    
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glDisable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);
  glShadeModel(GL_FLAT);
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-0.5, 0.5, -0.5, 0.5, 0.0, 1.0);
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

  carvePass(1, 0.5, 0.5, 0.5, 0.5, 0.5, 0, 0, 1, z_buffer_x_front);
  carvePass(0, 0.5, 0.5, 1  , 0.5, 0.5, 0, 0, 1, z_buffer_x_back);
  carvePass(0.5, 1, 0.5, 0.5, 0  , 0.5, 0, 0, 1, z_buffer_y_front);
  carvePass(0.5, 0, 0.5, 0.5, 1  , 0.5, 0, 0, 1, z_buffer_y_back);
  carvePass(0.5, 0.5, 1, 0.5, 0.5, 0  , 0, 1, 0, z_buffer_z_front);
  carvePass(0.5, 0.5, 0, 0.5, 0.5, 1  , 0, 1, 0, z_buffer_z_back);
  
  // fill voxel array from z buffers
  fill_voxels();

  timer.stop();
  cout << "Voxelizer::carve_voxelize took " << timer.elapsed() << " seconds" << endl;

}



void Voxelizer::carvePass(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, 
						  GLfloat* buf)
{
  win_p->clear();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(eyeX,eyeY,eyeZ,centerX,centerY,centerZ,upX,upY,upZ);
  mesh_view_p->draw_faces();
  glFlush();
  glFinish();
  read_z_buffer(buf);
  win_p->swap_buffers();
}



void Voxelizer::fill_voxels()									//apparently only used in carve_voxelize
{
  voxels.clear(1);  // fill voxels, then carve away

  // x
  if (carve_x) 
    for(int i=0; i < width; i++) 
      for(int j=0; j < height; j++) 
	  {
		float z_front_float = z_buffer_x_front[j * width + i] * depth;
		int z_front = depth - my_round(z_front_float);
		// z_buffer_x_back looked from the other side!!
		float z_back_float = z_buffer_x_back[j * width + (width - i - 1)] * depth;
		int z_back = my_round(z_back_float);
	  
		if (dilated) { z_back--; z_front++; }
		int index = j * width + i;
		
		for(int k=0; k < z_back; k++, index+= wxh) voxels[index] = 0;
		index = j * width + i + z_front * wxh;
		for(int k = z_front; k < depth; k++, index += wxh) voxels[index] = 0;
      } 
  
  // y
  if (carve_y) 
    for(int i=0; i < depth; i++) 
      for(int j=0; j < height; j++) 
	  {
		float z_front_float = z_buffer_y_front[j * depth + i] * width;
		int z_front = my_round(width - z_front_float);
		float z_back_float = z_buffer_y_back[j * depth + (depth - i - 1)] * width;
		int z_back = my_round(z_back_float);

		if (dilated) { z_back--; z_front++; }
		int index = (depth - i - 1) * wxh + j * depth;
	
		memset(&voxels[index],0,z_back*sizeof(VoxelType));
		
		index = (depth - i - 1) * wxh + j * depth + z_front;

		memset(&voxels[index],0,(width-z_front)*sizeof(VoxelType));
		index += width-z_front;
	}
  
  // z
  if (carve_z) 
    for(int i=0; i < depth; i++)
      for(int j=0; j < width; j++) 
	  {
		float z_front_float = z_buffer_z_front[j * depth + i] * height;
		int z_front = my_round(height - z_front_float);
		float z_back_float = z_buffer_z_back[j * depth + (depth - i - 1)] * height;
		int z_back = my_round(z_back_float);

		if (dilated) { z_back--; z_front++; }
		int index = i * wxh + j;

		for(int k=0; k < z_back; k++, index+=width) voxels[index] = 0;

		index = i * wxh + j + z_front * width;
		for(int k = z_front; k < height; k++, index += width) voxels[index] = 0;
	}

  voxels.init_types();
  
}  // Voxelizer::fill_voxels



void Voxelizer::read_z_buffer(GLfloat *buffer_p)
{
  // note: having VOXEL_WIDTH and VOXEL_HEIGHT only implies same dimensions
  glReadPixels(0, 0, width, height, GL_DEPTH_COMPONENT, GL_FLOAT, buffer_p);

}  // Voxelizer::read_z_buffer




void Voxelizer::read_screen_buffer(GLubyte *buffer_p)
{
  // note: having VOXEL_WIDTH and VOXEL_HEIGHT only, implies same dimensions
  glReadPixels(0, 0, width, height, GL_BLUE, GL_UNSIGNED_BYTE, buffer_p);
  
}  // Voxelizer::read_screen_buffer



