#ifndef __Face_h
#define __Face_h

#include <iostream>
#include <vector>
#include "Vertex.h"
#include "geom_defs.h"

using namespace std;





class Face
{

public:

			Face();
			Face(Face& other);
		   ~Face();
  void		clear();
  void		add_vertex(int v_id) { vertices.push_back(v_id); }
  void		add_triangle(int v0, int v1, int v2);
  int		get_vertex(int index) { return vertices[index]; }
  const int* 
            get_vertices() const { return &vertices[0]; }
  int		operator[](int index) { return vertices[index]; }
  void		set_vertex(int index, int new_value) { vertices[index] = new_value; }
  int		get_nr_vertices() { return vertices.size(); }
  void		replace_vertex(int old_id, int new_id);
  int		has_vertex(int v_id);
  int		get_third_vertex(int v0, int v1);
  void		reverse_vertices();
  void		set_group_id(int new_id) { group_id = new_id; }
  int		get_group_id() { return group_id; }
      
  friend ostream& operator<<(ostream& out_stream, const Face& F);

protected:

  vector<int>	vertices;
  int			group_id;  
};


#endif


