#ifndef __MESH_H
#define __MESH_H

#ifdef IRIX
#include <locale>
#endif
#include <string>
#include <vector>
#include "cc/math/Vector.h"
#include "cc/math/Matrix.h"
#include "Vertex.h"
#include "Face.h"

class MeshView;

using namespace std;





class Mesh
{
public:
				Mesh(string name = "noname");
				Mesh(Mesh& other);
			   ~Mesh();
  void			clear();
  void			init();
  string		get_name() { return my_name; }
  void			set_name(string new_name) { my_name = new_name; }

  // vertices
  inline Vertex* get_vertex(int index) { return vertices[index]; }
  void			 set_vertex(int index, Vertex *v_p) { vertices[index] = v_p; }
  int			 add_vertex(Vertex *v_p);
  int			 get_nr_vertices() { return vertices.size(); }
  vector<Vertex*>& 
				 get_vertices_ref() { return vertices; }
  Vertex**		 get_vertices() { return &vertices[0]; }
  
  // faces
  int			add_face(Face *f_p);
  int			add_triangle(int v0, int v1, int v2);
  Vector		get_face_center(int index);
  inline Face*	operator[](int index) { return faces[index]; }
  int			get_nr_faces() { return faces.size(); }
  int			has_triangle(int v0, int v1, int v2);
  void			clear_faces();
  int			my_triangulate();
  void			flip_normals();
  void			remove_zero_area_faces();
  void			purge_removed_faces();
  int			compute_bounding_box(int remove_largest = 0);
  void			get_bounding_box(Vector *bmin_p, Vector *bmax_p);
  void			set_bounding_box(Vector new_bmin, Vector new_bmax);
  Float			normalize();
  Matrix		get_norm_transform() { return normalization_transform; }
  void			transform(Matrix& M);
  void			translate(Vector trans);
  void			rotate(Matrix& R);
  Vector		get_center() { return center; }
  void			compute_data();
  
  friend class MeshFile;
  friend class ObjMeshFile;
  friend class MeshView;
  

protected:

  string			my_name;
  Matrix			normalization_transform;
  Vector			center;				// of bounding box
  Vector			centroid;
  Vector			bmin, bmax;			// bbox
  vector<Vertex *>	vertices;
  vector<Face *>	faces;
};

#endif

