//
// binvox, a binary 3D mesh voxelizer
// Copyright (c) 2004-2007 by Patrick Min, patrick.n.min "at" gmail "dot" com
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
//
// $Id: MeshView.cc,v 1.2 2007/01/19 13:22:38 min Exp min $
//

#include <stdio.h>
#include <list>
#include "MeshView.h"
#include "cc/geom/geom_defs.h"


using namespace std;



MeshView::MeshView(Mesh *mesh_p): View(), list(0)
{
  this->mesh_p = mesh_p;
    
}  // constructor



MeshView::~MeshView()
{

}  // destructor



void MeshView::draw_faces()
{
  if (list)									//Do we have a display list for this? If so, use it (faster than drawing the whole thing)
  {
    glCallList(list);
  }
  else										//No display list: iterate over the data and build the list
  {
    std::list<Face*>		faces;			//Separate several types of faces; makes us build more efficient GL lists..
	std::list<Face*>		triangles;
	std::list<Face*>		quads;

    list = glGenLists(1);
	glNewList(list,GL_COMPILE);

    int nr_faces = mesh_p->get_nr_faces();
    for(int i=0; i < nr_faces; ++i)			//First, group faces by #vertices
    {
      Face *my_face_p = (*mesh_p)[i];
      int nr_vertices = my_face_p->get_nr_vertices();
	  if (nr_vertices==3) triangles.push_back(my_face_p); 
	  else if (nr_vertices==4) quads.push_back(my_face_p);
	  else faces.push_back(my_face_p);
	}

	Vertex** VV = mesh_p->get_vertices();	

    if (triangles.size())
	{	
      glBegin(GL_TRIANGLES);					//Second, process triangles	
      for(std::list<Face*>::iterator it=triangles.begin();it!=triangles.end();++it)
	  {	  
	    const int* vv = (*it)->get_vertices();
	    glVertex3dv(VV[vv[0]]->get_vector().data());
	    glVertex3dv(VV[vv[1]]->get_vector().data());
	    glVertex3dv(VV[vv[2]]->get_vector().data());
      }
	  glEnd();
	}

    if (quads.size())
	{
      glBegin(GL_QUADS);						//Third, process quads
      for(std::list<Face*>::iterator it=quads.begin();it!=quads.end();++it)
	  {	  
	    const int* vv = (*it)->get_vertices();
	    glVertex3dv(VV[vv[0]]->get_vector().data());
	    glVertex3dv(VV[vv[1]]->get_vector().data());
	    glVertex3dv(VV[vv[2]]->get_vector().data());
	    glVertex3dv(VV[vv[3]]->get_vector().data());
      }
	  glEnd();
	}

    for(std::list<Face*>::iterator it=faces.begin();it!=faces.end();++it)
	{										//Finally, process arbitrary-size polygons
	  Face*       f = *it;
	  const int* vv = f->get_vertices();
	  int         V = f->get_nr_vertices();
      glBegin(GL_POLYGON);
	  for(int j=0; j < V; ++j)
	     glVertex3dv(VV[vv[j]]->get_vector().data());
      glEnd();    
    }
  
    glEndList();							//List done
	glCallList(list);						//Now draw it  
  }
}  // MeshView::draw_faces



void
MeshView::redraw()
{
  glDisable(GL_LINE_SMOOTH);
  glDisable(GL_BLEND);

  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glShadeModel(GL_FLAT);					//ALEX: was GL_SMOOTH, don't know why

  glLineWidth(1.0);

  glDisable(GL_TEXTURE_2D);

  draw_faces();
  
}  // MeshView::redraw



