#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <stdio.h>

#include "opengl.h"						//ALEX: _must_ come before glext.h otherwise glext.h complains
#include <OpenGL/glext.h>				//ALEX: needed for the FBO extensions

#include <math.h>
#include "GLwindow.h"

using namespace std;

static const Float DEFAULT_FOVY = 45.0;

int GLwindow::orthographic = 0;

vector<GLwindow *> GLwindow::windows;

#define DEBUG(x)





GLwindow::GLwindow(char *name, int x, int y, int width, int height, bool use_fbo): fbo(0)
{
  windows.push_back(this);
  init_window(name, x, y, width, height, use_fbo);

  DEBUG(cout << "GLwindow constructor(" << name << ", " << x << ", " << y << ", " << width
	<< ", " << height << "), this = " << this << ", # windows = " << windows.size() << endl);
  
}  // constructor



GLwindow::~GLwindow()
{
  if (fbo)
  {
    //ALEX: todo: Tear down the FBO and related structures
    //glDeleteRenderbuffersEXT(1, &renderbuffer);
	//..something more?
  }

}  // destructor



void
GLwindow::init_window(char *name, int x, int y, int width, int height, bool use_fbo)
{
  my_name = name;
  class_level = 0;
  
  this->width = width;
  this->height = height;
  
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);				//ALEX: creating a window is absolutely necessary even if we use only FBO's
  glutInitWindowPosition(x, y);												//      a FBO won't work (crashes!) if there's no currently active OpenGL context.	
  glutInitWindowSize(width, height);										//		And creating such a context in a platform-indep way is really impossible
  window_id = glutCreateWindow(name);										//		unless we create a GLUT window.. 
  if (use_fbo) glutHideWindow();											//If we use FBO's hide the GLUT window since it's really useless on screen.
																			//The window won't be shown, and _hopefully_, its GL context is still created OK..
  glutReshapeFunc(GLwindow::static_resize);
  glutDisplayFunc(GLwindow::static_redraw);

  if (use_fbo)																//ALEX: if we use FBO's make them here; from now on, 'fbo' will be non-null
  {
    GLuint fboren[2];
    glGenFramebuffersEXT(1, &fbo);
    glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, fbo);
    glGenRenderbuffersEXT(2, fboren);
    glBindRenderbufferEXT(GL_RENDERBUFFER_EXT, fboren[0]);
    glRenderbufferStorageEXT(GL_RENDERBUFFER_EXT, GL_RGBA, width, height);
    glFramebufferRenderbufferEXT(GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_RENDERBUFFER_EXT, fboren[0]);
    glBindRenderbufferEXT(GL_RENDERBUFFER_EXT, fboren[1]);
    glRenderbufferStorageEXT(GL_RENDERBUFFER_EXT, GL_DEPTH_COMPONENT, width, height);
    glFramebufferRenderbufferEXT(GL_FRAMEBUFFER_EXT, GL_DEPTH_ATTACHMENT_EXT, GL_RENDERBUFFER_EXT, fboren[1]);
    GLenum status = glCheckFramebufferStatusEXT(GL_FRAMEBUFFER_EXT);
    if (status != GL_FRAMEBUFFER_COMPLETE_EXT)
    {
      cout<<"FBO creation error: "<<status<<endl;
    }
  
    glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, fbo);							//ALEX: // Make the FBO the rendering target
  }
  
  cam_list.add_camera(new Camera());
  set_projection(DEFAULT_FOVY, (Float) width / (Float) height, 0.1, 50.0);
  set_camera(Vector(1.0, 1.0, 0.25),
	     Vector(0.0, 0.0, 0.0),
	     Vector(0.0, 0.0, 1.0));
  bl_x = bl_y = -0.8;  // default ortho settings
  tr_x = tr_y = 0.8;
  
  glViewport(0, 0, width, height);

  glDrawBuffer(GL_BACK);
  set_background(0, 0, 0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glutSwapBuffers();
  glPolygonMode(GL_FRONT, GL_FILL);
  glDisable(GL_CULL_FACE);
  glShadeModel(GL_FLAT);
  glEnable(GL_DEPTH_TEST);
  glPixelStorei(GL_PACK_ALIGNMENT, 1);
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
}  // GLwindow::init_window



void
GLwindow::make_current()
{
  gui_gl_error("GLwindow make_current enter ");

  if (!fbo) glutSetWindow(window_id);							//ALEX: apparently, I don't need to set the crt window in FBO-mode, since I only have one
																//      single GL context in that case, right?
  
  glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, fbo);
  
  gui_gl_error("GLwindow make_current 0 ");
  
}  // GLwindow::make_current



void
GLwindow::set_title(char *title)
{
  make_current();
  glutSetWindowTitle(title);
  
}  // GLwindow::set_title



void
GLwindow::clear()
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
}  // GLwindow::clear



void
GLwindow::swap_buffers()
{
  if (!fbo) glutSwapBuffers();									//ALEX: do double buffering in FBO mode..
  
}  // GLwindow::refresh



void 
GLwindow::set_camera(Vector new_eye, Vector new_lookat, Vector new_up)
{
  Camera *cur_cam = cam_list.get_cur_camera();
  cur_cam->init(new_eye, new_lookat, new_up);
  cur_cam->load_matrix();
  
}  // GLwindow::set_camera



void
GLwindow::set_projection(Float fovy, Float aspect, Float znear, Float zfar)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fovy, aspect, znear, zfar);

  this->fovy = fovy;
  this->aspect = aspect;
  this->znear = znear;
  this->zfar = zfar;
  
}  // GLwindow::set_projection



void
GLwindow::set_size(int width, int height)
{
  glutReshapeWindow(width, height);

}  // GLwindow::set_size



void
GLwindow::set_position(int x, int y)
{
  glutPositionWindow(x, y);
  
}  // GLwindow::set_position



void
GLwindow::resize(int width, int height)
{
  DEBUG(cout << "Glwindow::resize(" << width << ", " << height << ")" << endl;
	cout << "  this pointer: " << this << endl);

  this->width = width;
  this->height = height;

}  // GLwindow::resize



void
GLwindow::redraw()
{
  DEBUG(cout << "GLwindow::redraw" << endl);
  
  make_current();
  clear();

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  if (orthographic) glOrtho(bl_x, tr_x, bl_y, tr_y, 0, 6);
  else gluPerspective(fovy, aspect, znear, zfar);
  gui_gl_error("GLwindow redraw 0 ");

  cam_list.get_cur_camera()->load_matrix();
  gui_gl_error("GLwindow redraw 1 ");

  if (class_level == 0) {
    swap_buffers();
    glFlush();
  }
  
}  // GLwindow::redraw()



void
GLwindow::set_ortho_bounds(Float bl_x, Float bl_y, Float tr_x, Float tr_y)
{
  this->bl_x = bl_x;
  this->bl_y = bl_y;
  this->tr_x = tr_x;
  this->tr_y = tr_y;
    
}  // GLwindow::set_ortho_bounds



GLwindow *
GLwindow::get_cur_win_p()
{
  int cur_window_id = glutGetWindow();
  DEBUG(cout << "GLwindow::get_cur_win_p for id " << cur_window_id);
  
  int nr_windows = windows.size();
  for(int i=0; i < nr_windows; i++) {
    GLwindow *win_p = windows[i];
    if (win_p->get_window_id() == cur_window_id) {
      DEBUG(cout << ", found win_p " << win_p << endl);
      return win_p;
    }
  }  // for

  DEBUG(cout << ", found no pointer, returning 0" << endl);
  return 0;

}  // GLwindow::get_cur_win_p


  
void
GLwindow::static_resize(int width, int height)
{
  GLwindow *win_p = GLwindow::get_cur_win_p();
  DEBUG(cout << "GLwindow::static_resize(" << width << ", " << height << ") for win_p " << win_p << endl);
  win_p->resize(width, height);
  
//   GLint viewport[4];
//   glGetIntegerv(GL_VIEWPORT, viewport);
//   glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);

  glViewport(0, 0, width, height);

}  // GLwindow::resize



void
GLwindow::static_redraw()
{
  DEBUG(cout << "GLwindow::static_redraw for window [" << GLwindow::get_cur_win_p()->get_name()
	<< "] id " << GLwindow::get_cur_win_p()->get_window_id() << endl);
  GLwindow::get_cur_win_p()->redraw();
  
}  // GLwindow::static_redraw



void
GLwindow::set_idle(void (*idle)(void))
{
  glutIdleFunc(idle);
  
}  // GLwindow::set_idle



void
GLwindow::set_background(float r, float g, float b)
{
  glClearColor(r, g, b, 0);

}  // GLwindow::set_background



void
GLwindow::get_background(float *r_p, float *g_p, float *b_p)
{
  float bg[4];
  glGetFloatv(GL_COLOR_CLEAR_VALUE, bg);
  *r_p = bg[0];
  *g_p = bg[1];
  *b_p = bg[2];
  
}  // GLwindow::get_background


