#ifndef __Voxelizer_h
#define __Voxelizer_h

#include "VoxelFilter.h"
#include "cc/geom/Mesh.h"
#include "cc/geom/MeshView.h"
#include "cc/ui/GLwindow.h"



class Voxelizer : public VoxelFilter
{

public:

  Voxelizer(Voxels& voxels_ref, Mesh& mesh_ref, GLwindow *win_p);
  ~Voxelizer();

  void parity_vote_voxelize(int skip_simple = 0);
  void carve_voxelize();

  void set_dilated(int new_value) { dilated = new_value; }
  
  void invert() { voxels.invert(); }
  
  string get_name() { return "Voxelizer"; }
  

  static const int DEFAULT_WIDTH = 128;
  static const int MAX_WIDTH = 1024;
  static const int MAX_HEIGHT = 1024;

  
private:

  Mesh& mesh;
  GLwindow *win_p;
  MeshView *mesh_view_p;
  GLubyte* blue_buffer;
  
  //
  // z buffer stuff
  //
  void read_z_buffer(GLfloat *buffer_p);

  GLfloat z_buffer_x_front[MAX_WIDTH * MAX_HEIGHT];
  GLfloat z_buffer_y_front[MAX_WIDTH * MAX_HEIGHT];
  GLfloat z_buffer_z_front[MAX_WIDTH * MAX_HEIGHT];
  GLfloat z_buffer_x_back[MAX_WIDTH * MAX_HEIGHT];
  GLfloat z_buffer_y_back[MAX_WIDTH * MAX_HEIGHT];
  GLfloat z_buffer_z_back[MAX_WIDTH * MAX_HEIGHT];

  void read_screen_buffer(GLubyte *buffer_p);

  void fill_voxels();  // for carve_voxelize

  void passDim(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ,int N,
			   int dir, int sw, int flag);

  void carvePass(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, 
				 GLfloat* buf);


  int step_by_step;
  int dilated;

  
};  // Voxelizer class


#endif


