/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class DataReader {
    private int nCats;
    private int nVars;
    private int nRows;
    private double[][] data;
    private String[] columnLabels;
    private String[] classLabels;
    private String[] classNames;
    private String[] rowNames;
    private int[] classValues;
    private TreeMap<String, Integer> classMap;
    private boolean[] isCatCol;
    private TreeMap<String, Integer>[] catValues;
    private String dataFileName;
    private DataSource ds;
    private boolean hasClassData;
    private boolean hasRowNames;

    public DataReader(String dataFileName, boolean hasClassData, boolean hasRowNames) {
        this.dataFileName = dataFileName;
        this.hasClassData = hasClassData;
        this.hasRowNames = hasRowNames;
    }

    public DataSource readFile() {
        System.out.println("Processing dataset: " + this.dataFileName);
        long t = System.currentTimeMillis();
        try {
            this.preprocess();
            this.process();
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(null, "Error reading a record from the dataset.");
            ie.printStackTrace();
        }
        System.out.println("DataReader:: Data rows, cols " + this.nRows + " " + this.nVars);
        ArrayList<Integer> nCatValues = new ArrayList<Integer>();
        int i = 0;
        while (i < this.catValues.length) {
            nCatValues.add(this.catValues[i].size());
            ++i;
        }
        if (this.hasClassData) {
            this.collectClassNames();
        }
        System.out.println("DataReader:: TIME TO READ: " + (double)(System.currentTimeMillis() - t) / 1000.0 + " secs.");
        this.ds = new DataSource(this.data, this.classValues, this.classNames, nCatValues, this.nCats, this.nVars, this.nRows, this.columnLabels, this.rowNames);
        return this.ds;
    }

    private void preprocess() throws IOException {
        BufferedReader fileReader = this.openDataFile();
        this.readColumnLabelRecord(fileReader);
        this.initializeArrays();
        this.nRows = 0;
        String line = fileReader.readLine();
        while (line != null) {
            line = fileReader.readLine();
            ++this.nRows;
        }
        if (this.hasRowNames) {
            this.rowNames = new String[this.nRows];
        }
        fileReader.close();
    }

    private void process() throws IOException {
        String record;
        BufferedReader fileReader = this.openDataFile();
        this.data = new double[this.nRows][this.nVars];
        System.out.println("Created data matrix: " + this.nRows + "," + this.nVars);
        this.classLabels = new String[this.nRows];
        fileReader.readLine();
        int row = 0;
        while ((record = fileReader.readLine()) != null) {
            String[] fields = DataReader.getFields(record);
            this.processRecord(fields, row);
            ++row;
        }
        fileReader.close();
    }

    private void initializeArrays() {
        this.catValues = new TreeMap[this.nCats];
        int i = 0;
        while (i < this.nCats) {
            this.catValues[i] = new TreeMap();
            ++i;
        }
    }

    private BufferedReader openDataFile() {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(this.dataFileName));
        }
        catch (FileNotFoundException fe) {
            JOptionPane.showMessageDialog(null, "Dataset file not found.");
        }
        return fileReader;
    }

    private void readColumnLabelRecord(BufferedReader fileReader) throws IOException {
        String record = fileReader.readLine();
        String[] fields = DataReader.getFields(record);
        this.nVars = fields.length;
        this.columnLabels = new String[this.nVars];
        this.isCatCol = new boolean[this.nVars];
        int j = 0;
        int end = this.nVars--;
        if (this.hasClassData) {
            end = this.nVars;
        }
        if (this.hasRowNames) {
            --this.nVars;
            j = 1;
        }
        this.nCats = 0;
        int i = 0;
        while (j < end) {
            this.columnLabels[i] = fields[j];
            if (this.columnLabels[i].contains("$")) {
                this.isCatCol[i] = true;
                ++this.nCats;
            }
            ++j;
            ++i;
        }
        System.out.println("HEADER: nVars: " + this.nVars + " ncats: " + this.nCats);
    }

    private void processRecord(String[] fields, int row) {
        int cat = 0;
        int con = this.nCats;
        int j = 0;
        if (this.hasRowNames) {
            this.rowNames[row] = fields[0];
            j = 1;
        }
        while (j < this.nVars) {
            if (this.isCatCol[j]) {
                if (fields[j].equals("?")) {
                    this.data[row][cat] = -1.0;
                } else if (!this.catValues[cat].containsKey(fields[j])) {
                    this.data[row][cat] = this.catValues[cat].size() + 1;
                    this.catValues[cat].put(fields[j], new Integer(this.catValues[cat].size() + 1));
                } else {
                    this.data[row][cat] = this.catValues[cat].get(fields[j]).doubleValue();
                }
                ++cat;
            } else {
                try {
                    this.data[row][con] = Double.parseDouble(fields[j]);
                }
                catch (NumberFormatException e) {
                    this.data[row][con] = -1.0;
                }
                ++con;
            }
            ++j;
        }
        if (this.hasClassData) {
            this.classLabels[row] = fields[fields.length - 1];
        }
    }

    private void collectClassNames() {
        this.classMap = new TreeMap();
        int i = 0;
        while (i < this.classLabels.length) {
            this.classMap.put(this.classLabels[i], null);
            ++i;
        }
        Iterator<String> ki = this.classMap.keySet().iterator();
        this.classNames = new String[this.classMap.size()];
        int j = 0;
        while (ki.hasNext()) {
            String name;
            this.classNames[j] = name = ki.next();
            this.classMap.put(name, new Integer(j));
            System.out.println("CLASS NAME : " + name + " value: " + j);
            ++j;
        }
        this.classValues = new int[this.classLabels.length];
        int i2 = 0;
        while (i2 < this.classLabels.length) {
            this.classValues[i2] = this.classMap.get(this.classLabels[i2]);
            ++i2;
        }
    }

    private static String[] getFields(String record) {
        record = record.trim();
        record = record.replaceAll("\t", ",");
        record = record.replaceAll(",,", ",?,");
        record = record.replaceAll(" {2,}", ",");
        return record.split(",");
    }
}

