/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataTransforms;
import java.io.Serializable;
import java.util.List;
import model.Utils;
import scores.kDBinner;

public class DataSource
implements Serializable {
    private static final long serialVersionUID = -2025572128257846091L;
    public double[][] data;
    public String[] columnLabels;
    public String[] classNames;
    public String[] rowNames;
    public double[][] categoryScores;
    public int[] classValues;
    public int nClasses;
    public List<Integer> nCatValues;
    public DataTransforms transforms;
    public int nCats;
    public int nVars;
    public int nPts;
    public static final double FUZZ0 = 1.0E-5;
    public static final double FUZZ1 = 0.99999;

    public DataSource(double[][] data, int[] classValues, String[] classNames, List<Integer> nCatValues, int nCats, int nVars, int nRows, String[] columnLabels, String[] rowNamesP) {
        long t = System.currentTimeMillis();
        if (nRows > 1500) {
            int nBins = (int)Math.max(100.0 * Math.log(nRows) / Math.log(2.0), 100.0);
            System.out.println("DataSource:: nbins: " + nBins + " nPTS originally: " + nRows + " nVars: " + nVars);
            kDBinner kbinner = new kDBinner();
            this.data = kbinner.computeMeansClustering(data, nBins, classValues);
            this.nPts = this.data.length;
            this.classValues = kbinner.getBinClasses();
        } else {
            this.data = data;
            this.nPts = nRows;
            this.classValues = classValues;
        }
        this.nVars = nVars;
        this.nCats = nCats;
        this.rowNames = null;
        if (rowNamesP != null && this.nPts == rowNamesP.length) {
            this.rowNames = rowNamesP;
        }
        System.out.println("DataSource:: After binning: nPts: " + this.nPts + " nVars: " + nVars + " nCats: " + nCats);
        System.out.println("DataSource:: TIME TO BIN: " + (double)(System.currentTimeMillis() - t) / 1000.0 + " secs.");
        this.nCatValues = nCatValues;
        this.nClasses = 0;
        if (classNames != null) {
            this.nClasses = classNames.length;
        }
        this.columnLabels = columnLabels;
        this.classNames = classNames;
    }

    public void normalizeData() {
        Utils.normalize(this.data);
    }
}

