/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import java.io.Serializable;
import model.Sorter;

public class DataTransforms
implements Serializable {
    private static final long serialVersionUID = -7186212029365108052L;
    private DataSource ds;
    private double[] xmin;
    private double[] xmax;
    private int nCats;
    private int nVars;
    private int nPts;
    private boolean[] isTransformed;

    public DataTransforms(DataSource ds) {
        this.ds = ds;
        this.nVars = ds.data.length;
        this.nPts = ds.data[0].length;
        this.nCats = ds.nCats;
    }

    public DataTransforms(DataSource ds, double[] xmin, double[] xmax, boolean[] isTransformed) {
        this.ds = ds;
        this.xmin = xmin;
        this.xmax = xmax;
        this.isTransformed = isTransformed;
        this.nVars = ds.data.length;
        this.nPts = ds.data[0].length;
        this.nCats = ds.nCats;
    }

    public DataTransforms getTransforms(DataSource ds) {
        return new DataTransforms(ds, this.xmin, this.xmax, this.isTransformed);
    }

    public void transformData() {
        this.computeDataLimits();
        this.standardizeData();
        this.pickTransforms();
        this.transformValues();
    }

    public void transformTestingInstance(double[][] values) {
        this.standardizeTestingInstance(values);
        this.transformValuesTestingInstance(values);
    }

    private void transformValues() {
        double[][] tdata = new double[this.nVars][this.nPts];
        int j = 0;
        while (j < this.nVars) {
            int i = 0;
            while (i < this.nPts) {
                tdata[j][i] = this.getTransformedValue(this.ds.data, i, j);
                ++i;
            }
            ++j;
        }
        this.ds.data = tdata;
    }

    private void transformValuesTestingInstance(double[][] values) {
        int numPts = values[0].length;
        int numVars = values.length;
        double[][] tdata = new double[numVars][numPts];
        int j = 0;
        while (j < numVars) {
            int i = 0;
            while (i < numPts) {
                tdata[j][i] = this.getTransformedValue(values, i, j);
                ++i;
            }
            ++j;
        }
        values = tdata;
    }

    private void pickTransforms() {
        if (this.isTransformed == null) {
            this.isTransformed = new boolean[this.nVars];
            double[] x = new double[this.nPts];
            int j = this.nCats;
            while (j < this.nVars) {
                this.isTransformed[j] = false;
                int i = 0;
                while (i < this.nPts) {
                    x[i] = this.getTransformedValue(this.ds.data, i, j);
                    ++i;
                }
                double[] lm = DataTransforms.LMoments(x, null, 4);
                double kurtosis = lm[3];
                if (kurtosis > 0.1) {
                    this.isTransformed[j] = true;
                }
                ++j;
            }
        }
    }

    private double getTransformedValue(double[][] d, int row, int col) {
        if (this.isTransformed[col]) {
            return 1.0 / (1.0 + Math.exp(-6.0 * d[col][row] + 3.0));
        }
        return d[col][row];
    }

    private void standardizeTestingInstance(double[][] values) {
        int numPts = values[0].length;
        int numVars = values.length;
        int j = 0;
        while (j < numVars) {
            int i = 0;
            while (i < numPts) {
                values[j][i] = (values[j][i] - this.xmin[j]) / (this.xmax[j] - this.xmin[j]);
                ++i;
            }
            ++j;
        }
    }

    private void standardizeData() {
        int j = 0;
        while (j < this.nVars) {
            int i = 0;
            while (i < this.nPts) {
                this.ds.data[j][i] = (this.ds.data[j][i] - this.xmin[j]) / (this.xmax[j] - this.xmin[j]);
                ++i;
            }
            ++j;
        }
    }

    public void normalizeData() {
        this.computeDataLimits();
        this.standardizeData();
    }

    private void computeDataLimits() {
        if (this.xmin == null) {
            this.xmin = new double[this.nVars];
            this.xmax = new double[this.nVars];
            int i = 0;
            while (i < this.nCats) {
                this.xmin[i] = 0.0;
                this.xmax[i] = this.ds.nCatValues.get(i).intValue();
                ++i;
            }
            int j = this.nCats;
            while (j < this.nVars) {
                this.xmin[j] = Double.POSITIVE_INFINITY;
                this.xmax[j] = Double.NEGATIVE_INFINITY;
                int i2 = 0;
                while (i2 < this.nPts) {
                    if (!Double.isNaN(this.ds.data[j][i2])) {
                        this.xmin[j] = Math.min(this.ds.data[j][i2], this.xmin[j]);
                        this.xmax[j] = Math.max(this.ds.data[j][i2], this.xmax[j]);
                    }
                    ++i2;
                }
                this.xmin[j] = this.xmin[j] - 1.0E-5 * (this.xmax[j] - this.xmin[j]);
                this.xmax[j] = this.xmax[j] + 1.0E-5 * (this.xmax[j] - this.xmin[j]);
                ++j;
            }
        }
    }

    public static double[] LMoments(double[] x, double[] weights, int nMoments) {
        double s;
        double temp;
        int n = x.length;
        int[] ind = Sorter.ascendingSort(x);
        double[] moments = new double[nMoments];
        double[][] coef = new double[2][nMoments];
        int j = 2;
        while (j < nMoments) {
            temp = 1.0 / (double)(j * (n - j));
            coef[0][j] = (double)(j + j - 1) * temp;
            coef[1][j] = (double)((j - 1) * (n + j - 1)) * temp;
            ++j;
        }
        temp = -n - 1;
        double c = 1.0 / (double)(n - 1);
        int nhalf = n / 2;
        int i = 0;
        while (i < nhalf) {
            temp += 2.0;
            if (weights == null || !(weights[i] < 1.0)) {
                double xi = x[ind[i]];
                double xii = x[ind[n - i - 1]];
                double termp = xi + xii;
                double termn = xi - xii;
                moments[0] = moments[0] + termp;
                double s1 = 1.0;
                s = temp * c;
                moments[1] = moments[1] + s * termn;
                int j2 = 2;
                while (j2 < nMoments) {
                    double s2 = s1;
                    s1 = s;
                    s = coef[0][j2] * temp * s1 - coef[1][j2] * s2;
                    int n2 = j2;
                    moments[n2] = moments[n2] + s * termp;
                    if (j2 < nMoments - 1) {
                        s2 = s1;
                        s1 = s;
                        s = coef[0][j2 + 1] * temp * s1 - coef[1][j2 + 1] * s2;
                        int n3 = j2 + 1;
                        moments[n3] = moments[n3] + s * termn;
                    }
                    j2 += 2;
                }
            }
            ++i;
        }
        if (n != nhalf + nhalf) {
            double term = x[nhalf];
            s = 1.0;
            moments[0] = moments[0] + term;
            int j3 = 2;
            while (j3 < nMoments) {
                s = -coef[1][j3] * s;
                int n4 = j3;
                moments[n4] = moments[n4] + s * term;
                j3 += 2;
            }
        }
        moments[0] = moments[0] / (double)n;
        if (moments[1] != 0.0) {
            int j4 = 2;
            while (j4 < nMoments) {
                int n5 = j4++;
                moments[n5] = moments[n5] / moments[1];
            }
            moments[1] = moments[1] / (double)n;
        }
        return moments;
    }
}

