/*
 * Decompiled with CFR 0.152.
 */
package gui;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import model.Utils;
import processing.core.PApplet;
import processing.core.PFont;
import scores.MSTMeasures;
import scores.ProjectionInfo;

public class Biplot {
    PApplet parent;
    int width;
    int xpos;
    int ypos;
    int PAD = 15;
    int NBINS = 10;
    String title;
    double[][] dataMatrix;
    double[][] dataCoord;
    public double[][] varCoord;
    String[] allVariableNames;
    String[] rowNames;
    int[] vindices;
    int[] classLabels;
    Rectangle[] labels;
    boolean[] used;
    int nClasses;
    int nVars;
    int nRows;
    boolean drawHistogram;
    boolean clearPlot;
    boolean isRPVersion;
    boolean isDrag;
    boolean shiftPressed;
    boolean showLabels;
    Point start;
    Point end;
    MSTMeasures mes;

    public Biplot(int x, int y, int widthP, PApplet p, boolean flag) {
        this.isRPVersion = flag;
        this.width = widthP;
        this.xpos = x;
        this.ypos = y;
        this.drawHistogram = false;
        this.clearPlot = false;
        this.parent = p;
        PFont font = this.parent.createFont("Helvetica", 14.0f);
        this.parent.textFont(font);
        this.showLabels = true;
        this.used = null;
    }

    public void compute(double[][] data, String[] vnames, int[] vindices, int[] classLabels, int nClasses, String[] rowNames, int scoreType, String titleP) {
        try {
            this.dataMatrix = Utils.standardizeData(data);
            this.nRows = data.length;
            this.nVars = data[0].length;
            this.classLabels = classLabels;
            this.nClasses = nClasses;
            this.allVariableNames = vnames;
            this.vindices = vindices;
            this.labels = new Rectangle[this.nVars];
            this.title = titleP;
            this.used = null;
            this.rowNames = rowNames;
            this.drawHistogram = false;
            if (this.nVars == 1) {
                this.drawHistogram = true;
                return;
            }
            int i = 0;
            while (i < this.nRows) {
                int j = 0;
                while (j < this.nVars) {
                    if (Double.isNaN(this.dataMatrix[i][j])) {
                        System.out.println("BIPLOT:: data has NAN " + i + "," + j);
                        System.exit(1);
                    }
                    ++j;
                }
                ++i;
            }
            Matrix A = new Matrix(this.dataMatrix);
            SingularValueDecomposition svd = new SingularValueDecomposition(A);
            double[][] U = svd.getU().getArray();
            double[] L = svd.getSingularValues();
            double[][] V = svd.getV().getArray();
            this.dataCoord = new double[this.nRows][2];
            double[] maxV = new double[2];
            double[] maxD = new double[2];
            int row = 0;
            while (row < U.length) {
                this.dataCoord[row][0] = U[row][0] * L[0];
                this.dataCoord[row][1] = U[row][1] * L[1];
                if (Math.abs(this.dataCoord[row][0]) > maxD[0]) {
                    maxD[0] = Math.abs(this.dataCoord[row][0]);
                }
                if (Math.abs(this.dataCoord[row][1]) > maxD[1]) {
                    maxD[1] = Math.abs(this.dataCoord[row][1]);
                }
                ++row;
            }
            this.varCoord = new double[this.nVars][2];
            row = 0;
            while (row < this.nVars) {
                this.varCoord[row][0] = V[row][0];
                this.varCoord[row][1] = V[row][1];
                if (Math.abs(this.varCoord[row][0]) > maxV[0]) {
                    maxV[0] = Math.abs(this.varCoord[row][0]);
                }
                if (Math.abs(this.varCoord[row][1]) > maxV[1]) {
                    maxV[1] = Math.abs(this.varCoord[row][1]);
                }
                ++row;
            }
            this.dataCoord = this.normalizeVars(this.dataCoord, maxD);
            this.varCoord = this.normalizeVars(this.varCoord, maxV);
            this.clearPlot = false;
            this.parent.colorMode(3, 100.0f);
        }
        catch (Exception e) {
            System.out.println("BIP::Error: " + e);
            e.printStackTrace();
        }
    }

    public void draw() {
        this.parent.colorMode(3, 100.0f);
        this.parent.textSize(12.0f);
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.fill(RPVisualizer.plotBGColor.getRGB());
        this.parent.rect(this.xpos, this.ypos, this.width, this.width);
        int drawSpace = this.width - this.PAD * 2;
        this.parent.fill(Color.LIGHT_GRAY.getRGB());
        if (!this.clearPlot) {
            if (this.drawHistogram) {
                this.parent.text("Histogram", (float)(this.xpos + 10), (float)(this.ypos + this.width + 15));
                this.drawVerticalHistogram(drawSpace);
            } else {
                float SKIP = 25.0f;
                float h = (100.0f - SKIP) / (float)this.dataCoord.length;
                if (this.nClasses > 0) {
                    h = (100.0f - SKIP) / (float)this.nClasses;
                }
                this.parent.text(this.title, (float)this.xpos, (float)(this.ypos + this.width + 15));
                int halfSpace = drawSpace / 2;
                int centerX = this.xpos + this.PAD + halfSpace;
                int centerY = this.ypos + this.PAD + halfSpace;
                if (this.dataCoord != null) {
                    int y;
                    int x;
                    float transparency = 80.0f;
                    int i = 0;
                    while (i < this.varCoord.length) {
                        if (this.showLabels) {
                            this.parent.fill(RPVisualizer.textColor.getRGB());
                            this.parent.stroke(RPVisualizer.textColor.getRGB());
                            x = this.xpos + this.PAD + halfSpace + (int)(this.varCoord[i][0] * (double)halfSpace);
                            y = this.ypos + this.width - this.PAD - halfSpace - (int)(this.varCoord[i][1] * (double)halfSpace);
                            this.parent.line(centerX, centerY, x, y);
                            if (!this.isRPVersion) {
                                if (RPVisualizer.genVariables != null) {
                                    int aa = 0;
                                    while (aa < RPVisualizer.genVariables.size()) {
                                        if (this.allVariableNames[this.vindices[i]].equals(RPVisualizer.genVariables.get(aa))) {
                                            this.parent.fill(RPVisualizer.matchColor.getRGB());
                                        }
                                        ++aa;
                                    }
                                }
                                if (RPVisualizer.radialSelectedVarIndex >= 0 && RPVisualizer.radialSelectedVarIndex == this.vindices[i] || RPVisualizer.hoverVariable == this.vindices[i]) {
                                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                                }
                                if (this.used != null && this.used[i]) {
                                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                                    this.parent.stroke(RPVisualizer.textSelectColor.getRGB());
                                }
                            } else if (RPVisualizer.selectedProjection >= 0 && RPVisualizer.selectedProjection == i || RPVisualizer.hoverProjection >= 0 && RPVisualizer.hoverProjection == i) {
                                this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                            }
                            if (this.isRPVersion) {
                                this.parent.text("RP" + i, (float)x, (float)y);
                                this.labels[i] = new Rectangle(x - 2, y - 14, (int)this.parent.textWidth("RP" + i) + 2, 14);
                            } else {
                                this.parent.text("V" + this.vindices[i], (float)x, (float)y);
                                this.labels[i] = new Rectangle(x, y - 12, (int)this.parent.textWidth("V" + this.vindices[i]), 12);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.dataCoord.length) {
                        x = this.xpos + this.PAD + halfSpace + (int)(this.dataCoord[i][0] * (double)halfSpace);
                        y = this.ypos + this.width - this.PAD - halfSpace - (int)(this.dataCoord[i][1] * (double)halfSpace);
                        boolean ADD = false;
                        if (this.nClasses > 0) {
                            this.parent.fill((float)ADD + h * (float)this.classLabels[i], 80.0f, 100.0f, transparency);
                        } else {
                            this.parent.fill((float)ADD + h * (float)i, 80.0f, 100.0f, transparency);
                        }
                        if (this.isDrag) {
                            if (this.isInBrushRegion(new Point(x, y))) {
                                RPVisualizer.isBrushed.add(new Integer(i));
                            } else if (!this.shiftPressed && RPVisualizer.isBrushed.size() > 0 && RPVisualizer.isBrushed.contains(new Integer(i))) {
                                RPVisualizer.isBrushed.remove(new Integer(i));
                            }
                        }
                        this.parent.noStroke();
                        this.parent.ellipse(x, y, 4.0f, 4.0f);
                        if (Math.abs(this.parent.mouseX - x) <= 4 && Math.abs(this.parent.mouseY - y) <= 4) {
                            String rn = "Row:" + i;
                            if (this.rowNames != null) {
                                rn = this.rowNames[i];
                            }
                            if (this.nClasses > 0) {
                                this.parent.text(String.valueOf(rn) + "-Class:" + this.classLabels[i], (float)x, (float)y);
                            } else {
                                this.parent.text(rn, (float)x, (float)y);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < RPVisualizer.isOutlier.size()) {
                        x = this.xpos + this.PAD + halfSpace + (int)(this.dataCoord[RPVisualizer.isOutlier.get(i)][0] * (double)halfSpace);
                        y = this.ypos + this.width - this.PAD - halfSpace - (int)(this.dataCoord[RPVisualizer.isOutlier.get(i)][1] * (double)halfSpace);
                        this.parent.fill(RPVisualizer.plotBGColor.getRGB());
                        this.parent.ellipse(x, y, 4.0f, 4.0f);
                        this.parent.fill(RPVisualizer.outlierColor.getRGB(), 90.0f);
                        this.parent.ellipse(x, y, 5.0f, 5.0f);
                        ++i;
                    }
                    i = 0;
                    while (i < RPVisualizer.isBrushed.size()) {
                        x = this.xpos + this.PAD + halfSpace + (int)(this.dataCoord[RPVisualizer.isBrushed.get(i)][0] * (double)halfSpace);
                        y = this.ypos + this.width - this.PAD - halfSpace - (int)(this.dataCoord[RPVisualizer.isBrushed.get(i)][1] * (double)halfSpace);
                        this.parent.fill(RPVisualizer.plotBGColor.getRGB());
                        this.parent.ellipse(x, y, 4.0f, 4.0f);
                        this.parent.fill(RPVisualizer.brushColor.getRGB(), 90.0f);
                        this.parent.ellipse(x, y, 5.0f, 5.0f);
                        ++i;
                    }
                    this.parent.fill(Color.LIGHT_GRAY.getRGB());
                    this.parent.stroke(Color.LIGHT_GRAY.getRGB());
                    this.mouseOver();
                }
            }
        }
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.fill(Color.LIGHT_GRAY.getRGB());
    }

    public void mousePressed() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.labels.length) {
                if (this.labels[i] != null && this.labels[i].contains(new Point(mX, mY))) {
                    flag = true;
                    if (this.isRPVersion) {
                        RPVisualizer.selectedProjection = i;
                    } else {
                        RPVisualizer.hoverVariable = i;
                    }
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.selectedProjection = -1;
                RPVisualizer.hoverVariable = -1;
            }
            this.isDrag = true;
            this.start = new Point(mX, mY);
            this.end = null;
            if (this.parent.keyPressed && this.parent.key == '\uffff' && this.parent.keyCode == 16) {
                this.shiftPressed = true;
            } else {
                RPVisualizer.resetBrushed();
                this.shiftPressed = false;
            }
        }
    }

    public void mouseDragged() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY)) && this.isDrag) {
            this.end = new Point(this.parent.mouseX, this.parent.mouseY);
        }
    }

    public void mouseReleased() {
        this.isDrag = false;
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.labels.length) {
                if (this.labels[i] != null && this.labels[i].contains(new Point(mX, mY))) {
                    flag = true;
                    if (this.isRPVersion) {
                        RPVisualizer.hoverProjection = i;
                    } else {
                        RPVisualizer.hoverVariable = this.vindices[i];
                    }
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.hoverProjection = -1;
                RPVisualizer.hoverVariable = -1;
            }
        }
    }

    public void clearPlot() {
        this.clearPlot = true;
    }

    public void showPlot() {
        this.clearPlot = false;
    }

    public void hideLabels() {
        this.showLabels = false;
    }

    public void showLabels() {
        this.showLabels = true;
    }

    public void setUsed(ProjectionInfo p) {
        this.used = new boolean[this.vindices.length];
        int i = 0;
        while (i < this.vindices.length) {
            if (this.isIn(p.getIndices(), this.vindices[i])) {
                this.used[i] = true;
            }
            ++i;
        }
    }

    public void resetUsed() {
        this.used = null;
    }

    private boolean isIn(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void printMatrix(Matrix m) {
        double[][] d = m.getArray();
        int row = 0;
        while (row < d.length) {
            int col = 0;
            while (col < d[row].length) {
                System.out.printf("%6.4f\t", m.get(row, col));
                ++col;
            }
            System.out.println();
            ++row;
        }
        System.out.println();
    }

    private double[][] normalizeVars(double[][] vars, double[] max) {
        int np = vars.length;
        int nv = vars[0].length;
        double[][] norm = new double[np][nv];
        int i = 0;
        while (i < np) {
            int j = 0;
            while (j < nv) {
                norm[i][j] = vars[i][j] / max[j];
                ++j;
            }
            ++i;
        }
        return norm;
    }

    private double[][] normalizeVars(double[][] vars) {
        int j;
        int np = vars.length;
        int nv = vars[0].length;
        double[][] norm = new double[np][nv];
        double[] max = new double[nv];
        double[] min = new double[nv];
        int i = 0;
        while (i < nv) {
            max[i] = Double.MIN_VALUE;
            min[i] = Double.MAX_VALUE;
            ++i;
        }
        i = 0;
        while (i < nv) {
            j = 0;
            while (j < np) {
                max[i] = Math.max(max[i], vars[j][i]);
                min[i] = Math.min(min[i], vars[j][i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < np) {
            j = 0;
            while (j < nv) {
                norm[i][j] = (vars[i][j] - min[j]) / (max[j] - min[j]);
                ++j;
            }
            ++i;
        }
        return norm;
    }

    private void drawVerticalHistogram(int PLOTSIZE) {
        int wt = PLOTSIZE / this.NBINS;
        double[] cnts = new double[this.NBINS];
        double[] classCnts = new double[this.NBINS];
        if (this.dataMatrix != null) {
            this.getHistogramValues(this.getColumn(this.dataMatrix, 0), cnts, classCnts);
            int j = 0;
            while (j < cnts.length) {
                int x = this.xpos + j * wt;
                int ht = (int)(cnts[j] * (double)(PLOTSIZE - this.PAD));
                int y = this.ypos + PLOTSIZE - ht;
                this.parent.fill(Color.DARK_GRAY.getRGB());
                this.parent.rect(x, y, wt, ht);
                this.parent.fill(Color.YELLOW.getRGB());
                int cy = PLOTSIZE - (int)(classCnts[j] * (double)ht);
                this.parent.rect(x, cy, wt, (int)(classCnts[j] * (double)ht));
                ++j;
            }
        }
    }

    private double[] getColumn(double[][] data, int index) {
        double[] res = new double[data.length];
        int i = 0;
        while (i < data.length) {
            res[i] = data[i][0];
            ++i;
        }
        return res;
    }

    public void getHistogramValues(double[] values, double[] cnts, double[] classCnts) {
        int i = 0;
        while (i < values.length) {
            int bin = (int)(values[i] * (double)this.NBINS);
            if (bin == this.NBINS) {
                // empty if block
            }
            int n = --bin;
            cnts[n] = cnts[n] + 1.0;
            ++i;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < cnts.length) {
            max = Math.max(cnts[i2], max);
            min = Math.min(cnts[i2], min);
            ++i2;
        }
        i2 = 0;
        while (i2 < cnts.length) {
            cnts[i2] = (cnts[i2] - min) / (max - min);
            ++i2;
        }
    }

    public boolean isInBrushRegion(Point pt) {
        if (this.start != null && this.end != null) {
            double totXDist = this.start.x - this.end.x;
            double totYDist = this.start.y - this.end.y;
            double xDist = this.start.x - pt.x;
            double yDist = this.start.y - pt.y;
            if ((totXDist < 0.0 && xDist < 0.0 && xDist >= totXDist || totXDist > 0.0 && xDist > 0.0 && xDist <= totXDist) && (totYDist < 0.0 && yDist < 0.0 && yDist >= totYDist || totYDist > 0.0 && yDist > 0.0 && yDist <= totYDist)) {
                return true;
            }
        }
        return false;
    }
}

