/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.DataSource;
import gui.RectBinner;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import processing.core.PApplet;
import scores.Bin;

public class FeaturePlot
extends JPanel {
    PApplet parent;
    int SIZE;
    int PAD = 5;
    int HISTSIZE = 25;
    int PLOTSIZE;
    int xpos;
    int ypos;
    int NBINS = 10;
    DataSource dataSource;
    int[][] rankedVars;
    double[][] rankedScores;
    boolean clearPlot;

    public FeaturePlot(int sizeP, DataSource dataP, PApplet p) {
        this.SIZE = sizeP;
        this.dataSource = dataP;
        this.parent = p;
        this.PLOTSIZE = this.SIZE - this.HISTSIZE - 2 * this.PAD;
        this.clearPlot = false;
    }

    public void setFeatures(int[][] rv, double[][] ss) {
        this.rankedVars = rv;
        this.rankedScores = ss;
    }

    public void setXY(int x, int y) {
        this.xpos = x;
        this.ypos = y;
    }

    public void clearPlots() {
        this.clearPlot = true;
    }

    public void showPlots() {
        this.clearPlot = false;
    }

    public void draw() {
        Color xColor = new Color(75, 255, 112);
        Color yColor = new Color(75, 75, 255);
        if (!this.clearPlot) {
            int[] pind = null;
            int xloc = this.xpos;
            int yloc = this.ypos;
            int[] ind = this.pickNextVars(pind);
            if (ind == null) {
                return;
            }
            pind = ind;
            int varX = this.rankedVars[0][ind[0]];
            int varY = this.rankedVars[1][ind[1]];
            if (varX == -1 || varY == -1) {
                return;
            }
            double maxSimX = this.rankedScores[0][ind[0]];
            double maxSimY = this.rankedScores[1][ind[1]];
            this.drawVerticalHistogram(varY, xloc + 2 * this.PAD, yloc);
            this.drawHorizontalHistogram(varX, xloc, yloc);
            this.parent.fill(Color.BLACK.getRGB());
            this.parent.rect(xloc += 2 * this.PAD, yloc += this.HISTSIZE, this.PLOTSIZE, this.PLOTSIZE);
            this.parent.stroke(xColor.getRGB());
            this.parent.line(xloc, yloc, xloc + this.PLOTSIZE, yloc);
            this.parent.line(xloc, yloc + this.PLOTSIZE, xloc + this.PLOTSIZE, yloc + this.PLOTSIZE);
            this.parent.stroke(yColor.getRGB());
            this.parent.line(xloc, yloc, xloc, yloc + this.PLOTSIZE);
            this.parent.line(xloc + this.PLOTSIZE, yloc, xloc + this.PLOTSIZE, yloc + this.PLOTSIZE);
            this.parent.stroke(Color.GRAY.getRGB());
            if (this.dataSource.data[varX] != null && this.dataSource.data[varY] != null) {
                int nBins = (int)Math.max(2.0 * Math.log(this.dataSource.data[varX].length) / Math.log(2.0), 10.0);
                RectBinner binner = new RectBinner(nBins);
                binner.compute(this.dataSource.data[varX], this.dataSource.data[varY]);
                Bin[][] bins = binner.getBins();
                double averageCount = (double)this.dataSource.data[varX].length * 1.0 / (double)(nBins * nBins);
                int i = 0;
                while (i < nBins) {
                    int j = 0;
                    while (j < nBins) {
                        Bin bin = bins[i][j];
                        if (bin.count != 0) {
                            double size = 0.025 * Math.pow((double)bin.count / averageCount, 0.65);
                            size = Math.min(size, 0.8 / (double)nBins);
                            int osize = (int)(size * (double)this.PLOTSIZE);
                            this.parent.fill(Color.LIGHT_GRAY.getRGB());
                            int xpos = (int)((bin.centroid[0] - size / 2.0) * (double)(this.PLOTSIZE - osize)) + xloc + (int)((double)osize * 1.0 / 2.0);
                            int ypos = this.PLOTSIZE - (int)((bin.centroid[1] + size / 2.0) * (double)(this.PLOTSIZE - osize)) + yloc - (int)((double)osize * 1.0 / 2.0);
                            this.parent.ellipse(xpos, ypos, osize, osize);
                        }
                        ++j;
                    }
                    DecimalFormat df = new DecimalFormat("#.##");
                    this.parent.fill(xColor.getRGB());
                    this.parent.text(" X: " + this.dataSource.columnLabels[varX], (float)xloc, (float)(yloc + this.SIZE - 2 * this.PAD));
                    this.parent.text(df.format(maxSimX), (float)(xloc + this.SIZE - 50), (float)(yloc + this.SIZE - 2 * this.PAD));
                    this.parent.fill(yColor.getRGB());
                    this.parent.translate(xloc + this.PLOTSIZE / 2, yloc + this.PLOTSIZE / 2);
                    this.parent.rotate(-1.57f);
                    this.parent.text(" Y: " + this.dataSource.columnLabels[varY], (float)(0 - 2 * this.PAD - this.PLOTSIZE / 2), (float)(-this.PLOTSIZE / 2 - 2));
                    this.parent.text(df.format(maxSimY), (float)(0 - 2 * this.PAD + (this.PLOTSIZE / 2 - 20)), (float)(-this.PLOTSIZE / 2 - 2));
                    this.parent.rotate(1.57f);
                    this.parent.translate(-xloc - this.PLOTSIZE / 2, -yloc - this.PLOTSIZE / 2);
                    this.parent.fill(Color.white.getRGB());
                    ++i;
                }
            }
        }
    }

    private void drawHorizontalHistogram(int varY, int xloc, int yloc) {
        this.parent.stroke(Color.GRAY.getRGB());
        if (varY >= 0 && this.dataSource.data[varY] != null) {
            int ht = this.PLOTSIZE / this.NBINS;
            double[] cnts = new double[this.NBINS];
            double[] classCnts = new double[this.NBINS];
            this.getHistogramValues(this.dataSource.data[varY], cnts, classCnts);
            int i = 0;
            while (i < cnts.length) {
                int x = xloc + this.PLOTSIZE + this.PAD;
                int wd = (int)(cnts[i] * (double)(this.HISTSIZE - this.PAD));
                int y = yloc + this.HISTSIZE + this.PLOTSIZE - i * ht - ht;
                this.parent.fill(Color.DARK_GRAY.getRGB());
                this.parent.rect(x, y, wd, ht);
                ++i;
            }
        }
    }

    private void drawVerticalHistogram(int varY, int xloc, int yloc) {
        this.parent.stroke(Color.GRAY.getRGB());
        if (varY >= 0 && this.dataSource.data[varY] != null) {
            int wt = this.PLOTSIZE / this.NBINS;
            double[] cnts = new double[this.NBINS];
            double[] classCnts = new double[this.NBINS];
            this.getHistogramValues(this.dataSource.data[varY], cnts, classCnts);
            int j = 0;
            while (j < cnts.length) {
                int x = xloc + j * wt;
                int ht = (int)(cnts[j] * (double)(this.HISTSIZE - this.PAD));
                int y = yloc + this.HISTSIZE - ht;
                this.parent.fill(Color.DARK_GRAY.getRGB());
                this.parent.rect(x, y, wt, ht);
                int cy = yloc + this.HISTSIZE - (int)(classCnts[j] * (double)ht);
                this.parent.rect(x, cy, wt, (int)(classCnts[j] * (double)ht));
                ++j;
            }
        }
    }

    private int[] pickNextVars(int[] prevIndices) {
        if (prevIndices == null) {
            if (this.rankedVars[0].length > 0 && this.rankedVars[1].length > 0 && this.rankedVars[0][0] != this.rankedVars[1][0]) {
                return new int[2];
            }
            return null;
        }
        int xp = prevIndices[0];
        int yp = prevIndices[1];
        int xn = xp;
        int yn = yp;
        if (xp < this.rankedVars[0].length - 1) {
            xn = xp + 1;
        }
        if (yp < this.rankedVars[1].length - 1) {
            yn = yp + 1;
        }
        while (yn < this.rankedVars.length - 1 && yn == xn) {
            ++yn;
        }
        if (yn == yp || xn == xp || this.rankedVars[0][xn] == this.rankedVars[1][yn]) {
            return null;
        }
        return new int[]{xn, yn};
    }

    public void getHistogramValues(double[] values, double[] cnts, double[] classCnts) {
        int i = 0;
        while (i < values.length) {
            int bin = (int)(values[i] * (double)this.NBINS);
            if (bin == this.NBINS) {
                // empty if block
            }
            int n = --bin;
            cnts[n] = cnts[n] + 1.0;
            ++i;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < cnts.length) {
            max = Math.max(cnts[i2], max);
            min = Math.min(cnts[i2], min);
            ++i2;
        }
        i2 = 0;
        while (i2 < cnts.length) {
            cnts[i2] = (cnts[i2] - min) / (max - min);
            ++i2;
        }
    }
}

