/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Edge;
import gui.Node;
import gui.Vector3D;
import java.util.ArrayList;
import java.util.HashMap;
import processing.core.PApplet;

public class Graph {
    ArrayList<Node> nodes = new ArrayList();
    ArrayList<Edge> edges = new ArrayList();
    HashMap<Node, ArrayList<Edge>> edgesFrom = new HashMap();
    HashMap<Node, ArrayList<Edge>> edgesTo = new HashMap();
    Node selectedNode = null;
    Node dragNode = null;
    Node hoverNode = null;

    public void setSelectedNode(Node n) {
        this.selectedNode = n;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setHoverNode(Node n) {
        this.hoverNode = n;
    }

    public Node getHoverNode() {
        return this.hoverNode;
    }

    public void setDragNode(Node n) {
        this.dragNode = n;
    }

    public Node getDragNode() {
        return this.dragNode;
    }

    public Vector3D getCentroid() {
        float x = 0.0f;
        float y = 0.0f;
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = this.nodes.get(i);
            x += n.getX();
            y += n.getY();
            ++i;
        }
        return new Vector3D(x / (float)this.nodes.size(), y / (float)this.nodes.size(), 0.0f);
    }

    public void addEdge(Edge e) {
        this.edges.add(e);
        ArrayList<Edge> f = this.getEdgesFrom(e.getFrom());
        f.add(e);
        ArrayList<Edge> t = this.getEdgesTo(e.getTo());
        t.add(e);
        e.setGraph(this);
    }

    public ArrayList<Edge> getEdgesFrom(Node n) {
        ArrayList<Edge> f = this.edgesFrom.get(n);
        if (f == null) {
            f = new ArrayList();
            this.edgesFrom.put(n, f);
        }
        return f;
    }

    public ArrayList<Edge> getEdgesTo(Node n) {
        ArrayList<Edge> t = this.edgesTo.get(n);
        if (t == null) {
            t = new ArrayList();
            this.edgesTo.put(n, t);
        }
        return t;
    }

    boolean isConnected(Node a, Node b) {
        for (Edge e : this.edges) {
            if ((e.getFrom() != a || e.getTo() != b) && (e.getFrom() != b || e.getTo() != a)) continue;
            return true;
        }
        return false;
    }

    public void addNode(Node n) {
        this.nodes.add(n);
        n.setGraph(this);
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public void draw(PApplet p) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge e = this.edges.get(i);
            e.draw(p);
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            Node n = this.nodes.get(i);
            n.draw(p);
            ++i;
        }
    }
}

