/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Edge;
import gui.ForcedNode;
import gui.Graph;
import gui.Node;
import gui.SpringEdge;
import gui.Vector3D;
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;

public class GraphPanel {
    PApplet parent;
    int xpos;
    int ypos;
    int H;
    int W;
    Graph g;
    float scaleFactor;
    float[][] graph;
    int[] counts;
    String[] labels;

    public GraphPanel(int widthP, int heightP, int padP, int x, int y, PApplet p) {
        this.xpos = x;
        this.ypos = y;
        this.parent = p;
        this.H = heightP;
        this.W = widthP;
        this.scaleFactor = 1.0f;
        this.graph = null;
        this.counts = null;
    }

    public void setGraph(int cindex, float[][] graph, int[] counts, String[] varnames) {
        if (graph != null) {
            this.graph = graph;
            this.counts = counts;
            this.labels = varnames;
            this.buildGraph();
        }
    }

    void draw() {
        this.parent.fill(0);
        this.parent.rect(this.xpos, this.ypos, this.W, this.H);
        if (this.g != null) {
            this.doLayout();
            this.g.draw(this.parent);
        }
    }

    void doLayout() {
        ForcedNode n;
        int i = 0;
        while (i < this.g.getNodes().size()) {
            Vector3D f;
            SpringEdge e;
            n = (ForcedNode)this.g.getNodes().get(i);
            ArrayList<Edge> edges = this.g.getEdgesFrom(n);
            n.setForce(new Vector3D(0, 0, 0));
            int j = 0;
            while (edges != null && j < edges.size()) {
                e = (SpringEdge)edges.get(j);
                f = e.getForceFrom();
                n.applyForce(f);
                ++j;
            }
            edges = this.g.getEdgesTo(n);
            j = 0;
            while (edges != null && j < edges.size()) {
                e = (SpringEdge)edges.get(j);
                f = e.getForceTo();
                n.applyForce(f);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.g.getNodes().size()) {
            ForcedNode a = (ForcedNode)this.g.getNodes().get(i);
            int j = 0;
            while (j < this.g.getNodes().size()) {
                float dy;
                float dx;
                float r;
                ForcedNode b = (ForcedNode)this.g.getNodes().get(j);
                if (b != a && (r = (float)Math.sqrt((dx = b.getX() - a.getX()) * dx + (dy = b.getY() - a.getY()) * dy)) != 0.0f) {
                    float f = 100.0f * (a.getMass() * b.getMass() / (r * r));
                    Vector3D vf = new Vector3D(-dx * f, -dy * f, 0.0f);
                    a.applyForce(vf);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.g.getNodes().size()) {
            n = (ForcedNode)this.g.getNodes().get(i);
            if (n != this.g.getDragNode()) {
                n.setPosition(n.getPosition().add(n.getForce()));
            }
            ++i;
        }
    }

    void mousePressed() {
        System.out.println("GRAPHLAYOUT:: mousepressed");
        this.g.setSelectedNode(null);
        this.g.setDragNode(null);
        int i = 0;
        while (i < this.g.getNodes().size()) {
            Node n = this.g.getNodes().get(i);
            if (n.containsPoint((float)this.parent.mouseX / this.scaleFactor, (float)this.parent.mouseY / this.scaleFactor)) {
                this.g.setSelectedNode(n);
                this.g.setDragNode(n);
            }
            ++i;
        }
    }

    void mouseMoved() {
        if (this.g.getDragNode() == null) {
            this.g.setHoverNode(null);
            int i = 0;
            while (i < this.g.getNodes().size()) {
                Node n = this.g.getNodes().get(i);
                if (n.containsPoint((float)this.parent.mouseX / this.scaleFactor, (float)this.parent.mouseY / this.scaleFactor)) {
                    this.g.setHoverNode(n);
                }
                ++i;
            }
        }
    }

    void mouseReleased() {
        System.out.println("GRAPHLAYOUT:: mouseReleased");
        this.g.setDragNode(null);
    }

    void mouseDragged() {
        System.out.println("GRAPHLAYOUT:: mouseDragged");
        if (this.g.getDragNode() != null) {
            this.g.getDragNode().setPosition(new Vector3D((float)this.parent.mouseX / this.scaleFactor, (float)this.parent.mouseY / this.scaleFactor, 0.0f));
        }
    }

    private void buildGraph() {
        this.g = new Graph();
        Random rand = new Random();
        int nNodes = this.graph.length;
        ForcedNode[] nodes = new ForcedNode[nNodes];
        System.out.println("building graphs");
        int maxCount = 0;
        int i = 0;
        while (i < nNodes) {
            maxCount = Math.max(maxCount, this.counts[i]);
            ++i;
        }
        int DSIZE = 20;
        int i2 = 0;
        while (i2 < nNodes) {
            System.out.println("Graph fill: i: " + i2 + " x,y: " + (this.xpos + rand.nextInt(this.W) - DSIZE) + "," + (this.ypos + this.H - rand.nextInt(this.H) - DSIZE));
            nodes[i2] = new ForcedNode(new Vector3D(this.xpos + rand.nextInt(this.W), this.ypos + this.H - rand.nextInt(this.H), 0));
            nodes[i2].setLabel(this.labels[i2]);
            nodes[i2].setMass(this.counts[i2] / maxCount);
            this.g.addNode(nodes[i2]);
            ++i2;
        }
        System.out.println("adding edges graphs");
        i2 = 0;
        while (i2 < nNodes) {
            int j = i2 + 1;
            while (j < nNodes) {
                if (this.graph[i2][j] > 0.0f) {
                    SpringEdge e = new SpringEdge(nodes[i2], nodes[j]);
                    e.setNaturalLength(10 + i2 * 5);
                    this.g.addEdge(e);
                }
                ++j;
            }
            ++i2;
        }
    }
}

