/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import model.Utils;
import processing.core.PApplet;

public class HistogramPlot {
    PApplet parent;
    int width;
    int height;
    int xpos;
    int ypos;
    String label;
    int xPAD;
    int yPAD;
    int selectedBar;
    int pressedBar;
    double[] scores;
    Rectangle[] bars;

    public HistogramPlot(int x, int y, int w, int h, PApplet p) {
        this.xpos = x;
        this.ypos = y;
        this.width = w;
        this.height = h;
        this.parent = p;
        this.yPAD = 5;
        this.xPAD = 5;
        this.selectedBar = -1;
        this.pressedBar = 0;
    }

    public void setData(String l, double[] s, int chosen) {
        this.label = l;
        this.scores = Utils.normalize(s);
        int nVars = this.scores.length;
        this.bars = new Rectangle[nVars];
        double wscale = (this.width - this.xPAD) / nVars;
        int i = 0;
        while (i < nVars) {
            int x1 = this.xpos + this.xPAD + 1 + (int)(wscale * (double)i);
            int y1 = this.ypos + this.height - this.yPAD - (int)(this.scores[i] * (double)(this.height - 2 * this.yPAD));
            this.bars[i] = new Rectangle(x1, y1, (int)(wscale - 2.0), (int)(this.scores[i] * (double)(this.height - 2 * this.yPAD)));
            ++i;
        }
    }

    public void draw() {
        if (this.label != null) {
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.fill(RPVisualizer.plotBGColor.getRGB());
            this.parent.rect(this.xpos, this.ypos, this.width, this.height);
            this.mouseOver();
            int i = 0;
            while (i < this.bars.length) {
                this.parent.stroke(Color.LIGHT_GRAY.getRGB());
                this.parent.fill(Color.LIGHT_GRAY.getRGB());
                if (this.selectedBar == i) {
                    this.parent.fill(98.0f, 80.0f, 80.0f, 100.0f);
                    this.parent.stroke(98.0f, 80.0f, 80.0f, 100.0f);
                }
                if (this.pressedBar == i) {
                    this.parent.fill(Color.RED.getRGB());
                    this.parent.stroke(Color.RED.getRGB());
                }
                this.parent.rect(this.bars[i].x, this.bars[i].y, this.bars[i].width, this.bars[i].height);
                ++i;
            }
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.textSize(11.0f);
            this.parent.text(this.label, (float)this.xpos, (float)(this.ypos + this.height + 15));
        }
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY)) && this.bars != null) {
            boolean flag = false;
            int i = 0;
            while (i < this.bars.length) {
                if (this.bars[i] != null && this.bars[i].contains(new Point(mX, mY))) {
                    flag = true;
                    this.selectedBar = i;
                }
                ++i;
            }
            if (!flag) {
                this.selectedBar = -1;
            }
        }
    }

    public void mousePressed() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY)) && this.bars != null) {
            boolean flag = false;
            int i = 0;
            while (i < this.bars.length) {
                if (this.bars[i] != null && this.bars[i].contains(new Point(mX, mY))) {
                    flag = true;
                    RPVisualizer.listIndex = i;
                    this.pressedBar = i;
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.listIndex = 0;
                this.pressedBar = 0;
            }
        }
    }
}

