/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import gui.StatUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import model.Utils;
import processing.core.PApplet;

public class LetterValueBoxPlot {
    double[] data;
    double n;
    double[] Q;
    double k;
    List<Double> outliers;
    List<Double> inliers;
    boolean isHorizontal;
    double[] nd;
    double[] depths;

    public LetterValueBoxPlot(double[] d, boolean isHorizontal) {
        this.data = new double[d.length];
        System.arraycopy(d, 0, this.data, 0, d.length);
        this.isHorizontal = isHorizontal;
        this.n = this.data.length;
        this.k = this.getProportionK(0.05);
        int intk = (int)Math.floor(this.k);
        this.depths = new double[2 * intk];
        this.depths[0] = (1.0 + this.n) / 2.0;
        int i = 1;
        while (i < intk) {
            this.depths[i] = (1.0 + Math.floor(this.depths[i - 1])) / 2.0;
            ++i;
        }
        i = 0;
        while (i < intk) {
            this.depths[intk + i] = this.n - this.depths[i];
            ++i;
        }
        i = 0;
        while (i < intk / 2) {
            double tmp = this.depths[i];
            this.depths[i] = this.depths[intk - i - 1];
            this.depths[intk - i - 1] = tmp;
            ++i;
        }
        Arrays.sort(this.data);
        this.Q = new double[2 * intk];
        i = 0;
        while (i < 2 * intk) {
            this.Q[i] = (this.data[(int)Math.floor(this.depths[i])] + this.data[(int)Math.ceil(this.depths[i])]) / 2.0;
            ++i;
        }
        this.computeOutliers();
    }

    public double getLowerThreshold() {
        return this.Q[0];
    }

    public double geUpperThreshold() {
        return this.Q[this.Q.length - 1];
    }

    public void computeOutliers() {
        this.nd = Utils.normalize(this.data);
        this.outliers = new ArrayList<Double>();
        this.inliers = new ArrayList<Double>();
        int i = 0;
        while (this.data[i] < this.Q[0] && i < this.data.length) {
            this.inliers.add(this.nd[i]);
            ++i;
        }
        i = (int)this.n - 1;
        while (this.data[i] > this.Q[this.Q.length - 1] && i >= 0) {
            this.outliers.add(this.nd[i]);
            --i;
        }
    }

    public double getProportionK(double p) {
        double k = -1.0;
        k = Math.ceil(this.logBase2(this.n)) - Math.ceil(this.logBase2(this.n * p)) + 1.0;
        return k;
    }

    public double getTrustworthyK(double alpha) {
        double k = -1.0;
        double z = StatUtil.getInvCDF((1.0 - alpha) / 2.0, true);
        k = Math.ceil(this.logBase2(this.n) - this.logBase2(4.0 * (z * z))) + 1.0;
        return k;
    }

    private double logBase2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public void draw(int xpos, int ypos, int width, int height, PApplet parent) {
        parent.stroke(Color.LIGHT_GRAY.getRGB());
        parent.fill(Color.black.getRGB());
        parent.rect(xpos, ypos, width, height);
        parent.text("LVB of MST Lengths", (float)xpos, (float)(ypos + height + 15));
        parent.fill(Color.gray.getRGB());
        int y = ypos + (height -= 10) / 2;
        int x = xpos + (width -= 10) / 2;
        int intk = (int)Math.floor(this.k);
        parent.rectMode(1);
        int i = 0;
        while (i < intk) {
            float pad;
            double vi = (this.nd[(int)Math.floor(this.depths[i])] + this.nd[(int)Math.ceil(this.depths[i])]) / 2.0;
            double v2 = (this.nd[(int)Math.floor(this.depths[2 * intk - i - 1])] + this.nd[(int)Math.ceil(this.depths[2 * intk - i - 1])]) / 2.0;
            if (this.isHorizontal) {
                x = xpos + (int)(vi * (double)width);
                int x2 = xpos + (int)(v2 * (double)width);
                pad = (float)i * 1.0f / (float)(2 * intk) * (float)height;
                parent.rect(x, (float)y - pad, x2, (float)y + pad);
            } else {
                y = ypos + (int)(vi * (double)height);
                int y2 = ypos + (int)(v2 * (double)height);
                pad = (float)i * 1.0f / (float)(2 * intk) * (float)width;
                parent.rect((float)x - pad, y, (float)x + pad, y2);
            }
            ++i;
        }
        parent.text("LVB of MST Lengths", (float)xpos, (float)(ypos + height + 25));
        parent.rectMode(0);
        parent.fill(RPVisualizer.outlierColor.getRGB());
        parent.noStroke();
        x = xpos + width / 2;
        y = ypos + height / 2;
        if (this.outliers != null) {
            i = 0;
            while (i < this.outliers.size()) {
                if (this.isHorizontal) {
                    x = xpos + (int)(this.outliers.get(i) * (double)width);
                } else {
                    y = ypos + (int)(this.outliers.get(i) * (double)height);
                }
                parent.rect(x, y, 3.0f, 3.0f);
                ++i;
            }
        }
    }
}

