/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Graph;
import gui.Vector3D;
import java.awt.Color;
import processing.core.PApplet;

public class Node {
    Vector3D position;
    float h = 10.0f;
    float w = 10.0f;
    String label = "";
    Graph g;

    public Node() {
        this.position = new Vector3D();
    }

    public void setGraph(Graph h) {
        this.g = h;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public boolean containsPoint(float x, float y) {
        float dx = this.position.getX() - x;
        float dy = this.position.getY() - y;
        return Math.abs(dx) < this.w / 2.0f && Math.abs(dy) < this.h / 2.0f;
    }

    public Node(Vector3D v) {
        this.position = v;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public void setPosition(Vector3D v) {
        this.position = v;
    }

    public float getX() {
        return this.position.getX();
    }

    public float getY() {
        return this.position.getY();
    }

    public void draw(PApplet p) {
        p.fill(Color.gray.getRGB());
        System.out.println("NODE: Drawing node: " + this.getX() + " ," + this.getY());
        p.ellipse(this.getX(), this.getY(), this.h, this.w);
    }
}

