/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import model.Utils;
import processing.core.PApplet;
import scores.ProjectionInfo;

public class ParallelCoordPlot {
    PApplet parent;
    int PAD = 15;
    int TEXTWIDTH = 15;
    int width;
    int height;
    double[][] data;
    String[] labels;
    Rectangle[] texts;
    int[] vindices;
    int[] ordering;
    int[] flipOrder;
    int[] classLabels;
    boolean[] used;
    float[][] graph;
    int nClasses;
    int xpos;
    int ypos;
    boolean isDrag;
    boolean shiftPressed;
    Point start;
    Point end;

    public ParallelCoordPlot(int width, int height, int x, int y, double[][] d, String[] labels, int[] vindices, int[] classLabels, int nClasses, float[][] graph, int[] sortOrder, PApplet parent) {
        this.width = width;
        this.height = height;
        this.xpos = x;
        this.ypos = y;
        this.data = Utils.normalize(d);
        this.labels = labels;
        this.vindices = vindices;
        this.parent = parent;
        this.nClasses = nClasses;
        this.graph = graph;
        this.classLabels = classLabels;
        this.ordering = sortOrder;
        this.flipOrder = new int[this.ordering.length];
        int oi = 0;
        while (oi < this.ordering.length) {
            this.flipOrder[this.ordering[oi]] = oi;
            ++oi;
        }
        this.texts = new Rectangle[this.ordering.length];
    }

    public void updateData(double[][] data, int[] vindices, int[] classLabels, float[][] g, int nClasses, int[] sortOrder) {
        this.data = Utils.normalize(data);
        this.vindices = vindices;
        this.nClasses = nClasses;
        this.graph = g;
        this.classLabels = classLabels;
        this.ordering = sortOrder;
        this.flipOrder = new int[this.ordering.length];
        int oi = 0;
        while (oi < this.ordering.length) {
            this.flipOrder[this.ordering[oi]] = oi;
            ++oi;
        }
        this.texts = new Rectangle[this.ordering.length];
        this.used = null;
    }

    public void draw() {
        int y2;
        int y1;
        int x2;
        int x1;
        int index1;
        int index;
        int j;
        this.parent.textSize(11.0f);
        this.parent.colorMode(3, 100.0f);
        float saturation = 80.0f;
        float brightness = 80.0f;
        float transparency = 80.0f;
        this.parent.fill(RPVisualizer.plotBGColor.getRGB());
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.rect(this.xpos, this.ypos, this.width, this.height);
        int N = this.data.length;
        if (this.nClasses > 0) {
            N = this.nClasses;
        }
        boolean ADD = false;
        float SKIP = 25.0f;
        float h = (100.0f - SKIP) / (float)N;
        if (N < this.height) {
            int i = 0;
            while (i < N) {
                int j2 = 0;
                while (j2 < this.height / N) {
                    this.parent.fill((float)ADD + h * (float)i, saturation, brightness, 100.0f);
                    this.parent.stroke((float)ADD + h * (float)i, saturation, brightness, 100.0f);
                    this.parent.rect(this.xpos + this.width + 2, this.ypos + i * (this.height / N) + j2, 3.0f, 1.0f);
                    ++j2;
                }
                ++i;
            }
        } else {
            float hh = (100.0f - SKIP) / (float)this.height;
            int i = 0;
            while (i < this.height) {
                this.parent.fill((float)ADD + hh * (float)i, saturation, brightness, 100.0f);
                this.parent.stroke((float)ADD + hh * (float)i, saturation, brightness, 100.0f);
                this.parent.rect(this.xpos + this.width + 2, this.ypos + i, 3.0f, 1.0f);
                ++i;
            }
        }
        int yloc = this.ypos + 5;
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.fill(Color.LIGHT_GRAY.getRGB());
        int drawWidth = this.width - 2 * this.PAD;
        int drawHeight = this.height - 2 * this.PAD - this.TEXTWIDTH;
        int nVars = this.data[0].length;
        int j3 = 0;
        while (j3 < nVars) {
            int index2 = j3;
            this.parent.fill(RPVisualizer.textColor.getRGB());
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            if (RPVisualizer.genVariables != null) {
                int aa = 0;
                while (aa < RPVisualizer.genVariables.size()) {
                    if (this.labels[this.vindices[index2]].equals(RPVisualizer.genVariables.get(aa))) {
                        this.parent.fill(RPVisualizer.matchColor.getRGB());
                    }
                    ++aa;
                }
            }
            if (this.used != null && this.used[index2]) {
                this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                this.parent.stroke(RPVisualizer.textSelectColor.getRGB());
            }
            if (RPVisualizer.splomSelected != null) {
                if (RPVisualizer.splomSelected[0] == this.vindices[index2]) {
                    this.parent.fill(RPVisualizer.xSelectColor.getRGB());
                }
                if (RPVisualizer.splomSelected[1] == this.vindices[index2]) {
                    this.parent.fill(RPVisualizer.ySelectColor.getRGB());
                }
            }
            if (this.graph != null && RPVisualizer.radialSelectedVarIndex >= 0) {
                int ti = -1;
                int tmp = 0;
                while (tmp < this.vindices.length) {
                    if (this.vindices[tmp] == RPVisualizer.radialSelectedVarIndex) {
                        ti = tmp;
                    }
                    ++tmp;
                }
                if (ti >= 0 && this.graph[ti][index2] != 0.0f) {
                    this.parent.fill(Color.CYAN.getRGB());
                }
            }
            if (RPVisualizer.radialSelectedVarIndex >= 0 && RPVisualizer.radialSelectedVarIndex == this.vindices[index2] || RPVisualizer.hoverVariable == this.vindices[index2]) {
                this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                this.parent.stroke(RPVisualizer.textSelectColor.getRGB());
            }
            int x12 = this.xpos + this.PAD + drawWidth / nVars * this.ordering[j3];
            this.parent.line(x12, yloc, x12, yloc + drawHeight);
            if (this.vindices != null) {
                this.parent.pushMatrix();
                this.parent.translate(x12, yloc + this.PAD + drawHeight);
                this.parent.rotate(-1.5707964f);
                this.parent.text("V" + this.vindices[index2], (float)(-this.TEXTWIDTH), 0.0f);
                this.parent.popMatrix();
                this.texts[j3] = new Rectangle(x12 - this.TEXTWIDTH + 2, yloc + this.PAD + drawHeight - 2, 12, this.TEXTWIDTH + 2);
            } else {
                System.out.println("PCP::Labels is null");
            }
            ++j3;
        }
        this.mouseOver();
        this.parent.stroke(Color.LIGHT_GRAY.getRGB(), transparency);
        int i = 0;
        while (i < this.data.length) {
            float hue = (float)ADD + h * (float)i;
            if (this.nClasses > 0) {
                hue = (float)ADD + h * (float)this.classLabels[i];
            }
            this.parent.stroke(hue, saturation, brightness, transparency);
            this.parent.fill(hue, saturation, brightness, transparency);
            int j4 = 0;
            while (j4 < nVars - 1) {
                int index3 = this.flipOrder[j4];
                int index12 = this.flipOrder[j4 + 1];
                int x13 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * j4;
                int x22 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * (j4 + 1);
                int y12 = yloc + drawHeight - (int)((double)drawHeight * this.data[i][index3]);
                int y22 = yloc + drawHeight - (int)((double)drawHeight * this.data[i][index12]);
                this.parent.line(x13, y12, x22, y22);
                ++j4;
            }
            ++i;
        }
        this.parent.strokeWeight(2.0f);
        i = 0;
        while (i < RPVisualizer.isOutlier.size()) {
            j = 0;
            while (j < nVars - 1) {
                index = this.flipOrder[j];
                index1 = this.flipOrder[j + 1];
                x1 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * j;
                x2 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * (j + 1);
                y1 = yloc + drawHeight - (int)((double)drawHeight * this.data[RPVisualizer.isOutlier.get(i)][index]);
                y2 = yloc + drawHeight - (int)((double)drawHeight * this.data[RPVisualizer.isOutlier.get(i)][index1]);
                this.parent.stroke(RPVisualizer.plotBGColor.getRGB());
                this.parent.line(x1, y1, x2, y2);
                this.parent.stroke(RPVisualizer.outlierColor.getRGB(), 100.0f);
                this.parent.line(x1, y1, x2, y2);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < RPVisualizer.isBrushed.size()) {
            j = 0;
            while (j < nVars - 1) {
                index = this.flipOrder[j];
                index1 = this.flipOrder[j + 1];
                x1 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * j;
                x2 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * (j + 1);
                y1 = yloc + drawHeight - (int)((double)drawHeight * this.data[RPVisualizer.isBrushed.get(i)][index]);
                y2 = yloc + drawHeight - (int)((double)drawHeight * this.data[RPVisualizer.isBrushed.get(i)][index1]);
                this.parent.stroke(RPVisualizer.plotBGColor.getRGB());
                this.parent.line(x1, y1, x2, y2);
                this.parent.stroke(RPVisualizer.brushColor.getRGB(), 100.0f);
                this.parent.line(x1, y1, x2, y2);
                ++j;
            }
            ++i;
        }
        this.parent.textSize(14.0f);
        this.parent.strokeWeight(1.0f);
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.fill(Color.LIGHT_GRAY.getRGB());
    }

    public void mousePressed() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.height);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            if (this.vindices != null) {
                boolean flag = false;
                int i = 0;
                while (i < this.texts.length) {
                    if (this.texts[i] != null && this.texts[i].contains(new Point(mX, mY))) {
                        flag = true;
                        RPVisualizer.hoverVariable = this.vindices[i];
                    }
                    ++i;
                }
                if (!flag) {
                    RPVisualizer.hoverVariable = -1;
                }
            }
            this.isDrag = true;
            this.start = new Point(mX, mY);
            this.end = null;
            if (this.parent.keyPressed && this.parent.key == '\uffff' && this.parent.keyCode == 16) {
                this.shiftPressed = true;
            } else {
                RPVisualizer.resetBrushed();
                this.shiftPressed = false;
            }
        }
    }

    public void mouseDragged() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.height);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY)) && this.isDrag) {
            this.end = new Point(this.parent.mouseX, this.parent.mouseY);
        }
    }

    public void mouseReleased() {
        this.isDrag = false;
    }

    public boolean isInBrushRegion(int i, int nVars, int drawHeight, int drawWidth) {
        if (this.start != null && this.end != null) {
            double totXDist = this.start.x - this.end.x;
            double totYDist = this.start.y - this.end.y;
            int j = 0;
            while (j < nVars) {
                int index = this.ordering[j];
                int x1 = this.xpos + this.PAD + (int)((double)drawWidth * 1.0 / (double)nVars) * j;
                int y1 = this.ypos + 5 + drawHeight - (int)((double)drawHeight * this.data[i][index]);
                double xDist = this.start.x - x1;
                double yDist = this.start.y - y1;
                if ((totXDist < 0.0 && xDist < 0.0 && xDist >= totXDist || totXDist > 0.0 && xDist > 0.0 && xDist <= totXDist) && (totYDist < 0.0 && yDist < 0.0 && yDist >= totYDist || totYDist > 0.0 && yDist > 0.0 && yDist <= totYDist)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.texts.length) {
                if (this.texts[i] != null && this.texts[i].contains(new Point(mX, mY))) {
                    flag = true;
                    RPVisualizer.hoverVariable = this.vindices[i];
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.hoverVariable = -1;
            }
        }
    }

    public void setUsed(ProjectionInfo p) {
        this.used = new boolean[this.vindices.length];
        int i = 0;
        while (i < this.vindices.length) {
            if (this.isIn(p.getIndices(), this.vindices[i])) {
                this.used[i] = true;
            }
            ++i;
        }
    }

    public void resetUsed() {
        this.used = null;
    }

    private boolean isIn(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

