/*
 * Decompiled with CFR 0.152.
 */
package gui;

import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.DropdownList;
import controlP5.RadioButton;
import controlP5.Textfield;
import data.DataSource;
import gui.Biplot;
import gui.HistogramPlot;
import gui.ParallelCoordPanel;
import gui.RadarPlot;
import gui.RadialPlot;
import gui.SPLOM;
import gui.VarList;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import model.RPLister;
import model.Sorter;
import processing.core.PApplet;
import scores.MSTMeasures;
import scores.ProjectionInfo;

public class RPVisualizer
extends PApplet {
    private int PAD = 10;
    private int HEIGHT;
    private int WIDTH;
    private int PLOTSIZE;
    int MAX_NUM = 40;
    public static final String[] scoreNames = new String[]{"OUTLYING", "CLUMPY", "STRIATED", "SPARSE", "STRINGY"};
    public static final int OUTLYING = 0;
    public static final int CLUMPY = 1;
    public static final int STRIATED = 2;
    public static final int SPARSE = 3;
    public static final int STRINGY = 4;
    private RPLister rplister;
    private String dataFileName;
    private String prevFileName;
    private int randomSeed = 3333;
    private int scoreType = 0;
    private int numProjs = 20;
    private int hasClass = -1;
    private int hasRowNames = -1;
    private int prevHasClass;
    RadialPlot radialPlot = null;
    RadarPlot radarPlot = null;
    HistogramPlot histPlot = null;
    ParallelCoordPanel pcp = null;
    Biplot combinedBiplot = null;
    Biplot rpBiplot = null;
    Biplot randVarBiplot = null;
    VarList varlist = null;
    SPLOM splom = null;
    DropdownList p1;
    Textfield rseed;
    Textfield rproj;
    ControlP5 controlP5;
    RadioButton radioButton;
    RadioButton radioButton1;
    public static DataSource dataSource;
    public static int radialSelectedVarIndex;
    public static int selectedProjection;
    public static int hoverProjection;
    public static int hoverVariable;
    public static int listIndex;
    public static ArrayList<Integer> isOutlier;
    public static ArrayList<Integer> isBrushed;
    public static ArrayList<Integer> allOutliers;
    public static Color brushColor;
    public static Color plotBGColor;
    public static Color textColor;
    public static Color outlierColor;
    public static Color textSelectColor;
    public static Color matchColor;
    public static Color xSelectColor;
    public static Color ySelectColor;
    public static int[] splomSelected;
    private float[][] graph;
    private double[][] dominantVariableData;
    private double[][] projectionData;
    private int[] counts;
    private int[] dominantVariables;
    private boolean showRadplot;
    private boolean showBiplot;
    private boolean showRVs;
    private boolean showLinkedVars;
    private boolean showSPLOM;
    private boolean initialized;
    private boolean hidePressed;
    private int[][] RVlist;
    private ProjectionInfo[][] RPlist;
    public static ArrayList<String> genVariables;

    public RPVisualizer() {
        isOutlier = new ArrayList();
        isBrushed = new ArrayList();
        allOutliers = new ArrayList();
        brushColor = Color.RED;
        outlierColor = Color.WHITE;
        plotBGColor = Color.BLACK;
        textColor = Color.WHITE;
        textSelectColor = Color.MAGENTA;
        matchColor = Color.ORANGE;
        xSelectColor = Color.CYAN;
        ySelectColor = Color.MAGENTA;
        selectedProjection = -1;
        hoverProjection = -1;
        hoverVariable = -1;
        radialSelectedVarIndex = -1;
        splomSelected = null;
        this.RPlist = null;
        this.RVlist = null;
        this.showRadplot = false;
        this.showSPLOM = false;
        this.showBiplot = false;
        this.hidePressed = false;
        this.initialized = false;
        this.showLinkedVars = false;
        this.showRVs = false;
    }

    @Override
    public void setup() {
        this.WIDTH = 1200;
        this.HEIGHT = 750;
        this.PLOTSIZE = this.HEIGHT / 2;
        this.size(1200, 750);
        this.background(0);
        this.smooth();
        this.stroke(255);
        this.frameRate(25.0f);
        this.controlP5 = new ControlP5(this);
        String t1 = "Choose_Data";
        int x = this.PAD;
        int w = (int)this.textWidth(t1);
        this.controlP5.addButton(t1, 255.0f, x, this.PAD, w, 25);
        x += w + 4 * this.PAD;
        String t1_5 = "Has Class";
        w = (int)this.textWidth(t1_5);
        this.radioButton = this.controlP5.addRadioButton("radioButton", x, this.PAD + 20);
        this.radioButton.setColorForeground(this.color(120));
        this.radioButton.setColorActive(this.color(255));
        this.radioButton.setColorLabel(this.color(255));
        this.radioButton.addItem(t1_5, 1.0f);
        t1_5 = "Has RowNames";
        w = (int)this.textWidth(t1_5);
        this.radioButton1 = this.controlP5.addRadioButton("radioButton1", x, this.PAD);
        this.radioButton1.setColorForeground(this.color(120));
        this.radioButton1.setColorActive(this.color(255));
        this.radioButton1.setColorLabel(this.color(255));
        this.radioButton1.addItem(t1_5, 1.0f);
        String t2 = "Score:";
        this.controlP5.addTextlabel("score", t2, x += w + 4 * this.PAD, this.PAD + 4);
        x = (int)((float)x + (this.textWidth(t2) + (float)this.PAD));
        this.p1 = this.controlP5.addDropdownList("scoreList", x, this.PAD + 20, 100, 120);
        this.customizeDropDownList(this.p1);
        String t3 = "Random Seed:";
        this.controlP5.addTextlabel("randomSeed", t3, x += 100 + 4 * this.PAD, this.PAD + 4);
        x = (int)((float)x + (this.textWidth(t3) + (float)(this.PAD / 2)));
        this.rseed = this.controlP5.addTextfield("seed", x, this.PAD + 2, 50, 18);
        this.rseed.setText(String.valueOf(this.randomSeed));
        this.rseed.setFocus(true);
        String t4 = "# Random Projections:";
        this.controlP5.addTextlabel("randomProj", t4, x += 50 + 4 * this.PAD, this.PAD + 4);
        x = (int)((float)x + (this.textWidth(t4) + (float)(this.PAD / 2)));
        this.rproj = this.controlP5.addTextfield("number", x, this.PAD + 2, 30, 18);
        this.rproj.setText(String.valueOf(this.numProjs));
        String t5 = "Update";
        this.controlP5.addButton(t5, 255.0f, x += 30 + 4 * this.PAD, this.PAD, (int)this.textWidth(t5), 25);
        String t9 = "Show_Random_Variables";
        x += 150 + 4 * this.PAD;
        String t7 = "Radial";
        this.controlP5.addButton(t7, 255.0f, this.PAD + 20, 80, (int)this.textWidth(t7), 25);
        this.controlP5.controller("Radial").setVisible(false);
        String t75 = "Return_All";
        this.controlP5.addButton(t75, 255.0f, this.PAD + 20, 80, (int)this.textWidth(t75), 25);
        this.controlP5.controller("Return_All").setVisible(false);
        String t8 = "SPLOM";
        this.controlP5.addButton(t8, 255.0f, this.PAD + 150, 80, (int)this.textWidth(t8), 25);
        this.controlP5.controller("SPLOM").setVisible(false);
        String t10 = "Biplot";
        this.controlP5.addButton(t10, 255.0f, this.PAD + 300, 80, (int)this.textWidth(t10), 25);
        this.controlP5.controller("Biplot").setVisible(false);
    }

    @Override
    public void draw() {
        try {
            this.background(Color.DARK_GRAY.getRGB());
            if (this.dataFileName != null) {
                this.textSize(10.0f);
                this.fill(Color.LIGHT_GRAY.getRGB());
                this.text(this.dataFileName, (float)this.PAD, 55.0f);
                this.textSize(14.0f);
            }
            if (this.radarPlot != null) {
                this.radarPlot.draw();
            }
            if (this.histPlot != null) {
                this.histPlot.draw();
            }
            if (this.pcp != null) {
                this.pcp.draw();
            }
            if (this.varlist != null) {
                this.varlist.draw();
            }
            if (this.showSPLOM) {
                if (this.splom != null) {
                    this.splom.draw();
                }
            } else {
                splomSelected = null;
            }
            if (this.showRVs) {
                if (this.showBiplot && this.randVarBiplot != null) {
                    this.randVarBiplot.draw();
                }
            } else {
                if (this.showRadplot && this.radialPlot != null) {
                    this.radialPlot.draw();
                }
                if (this.showBiplot && this.combinedBiplot != null) {
                    this.combinedBiplot.draw();
                }
                if (!this.showLinkedVars && this.rpBiplot != null) {
                    this.rpBiplot.draw();
                }
                if (hoverProjection >= 0) {
                    if (this.radialPlot != null) {
                        this.radialPlot.setUsed(this.RPlist[listIndex][hoverProjection]);
                    }
                    if (this.varlist != null) {
                        this.varlist.setUsed(this.RPlist[listIndex][hoverProjection]);
                    }
                    if (this.pcp != null) {
                        this.pcp.setUsed(this.RPlist[listIndex][hoverProjection]);
                    }
                    if (this.combinedBiplot != null) {
                        this.combinedBiplot.setUsed(this.RPlist[listIndex][hoverProjection]);
                    }
                } else {
                    if (this.radialPlot != null) {
                        this.radialPlot.resetUsed();
                    }
                    if (this.varlist != null) {
                        this.varlist.resetUsed();
                    }
                    if (this.pcp != null) {
                        this.pcp.resetUsed();
                    }
                    if (this.combinedBiplot != null) {
                        this.combinedBiplot.resetUsed();
                    }
                }
            }
            this.textSize(14.0f);
            this.fill(Color.LIGHT_GRAY.getRGB());
            if (this.rplister != null && this.rplister.getListScagnosticScores(listIndex) != null) {
                if (this.scoreType == 1) {
                    this.text("Subspace Clumpyness: " + this.rplister.getListScagnosticScores(listIndex)[1], (float)(this.PLOTSIZE + 200), 70.0f);
                }
                if (this.scoreType == 0) {
                    this.text("Subspace Outlyingness: " + this.rplister.getListScagnosticScores(listIndex)[0], (float)(this.PLOTSIZE + 200), 70.0f);
                }
                if (this.scoreType == 2) {
                    this.text("Subspace Striation: " + this.rplister.getListScagnosticScores(listIndex)[2], (float)(this.PLOTSIZE + 200), 70.0f);
                }
                if (this.scoreType == 3) {
                    this.text("Subspace Sparseness: " + this.rplister.getListScagnosticScores(listIndex)[3], (float)(this.PLOTSIZE + 200), 70.0f);
                }
                if (this.scoreType == 4) {
                    this.text("Subspace Stringyness: " + this.rplister.getListScagnosticScores(listIndex)[4], (float)(this.PLOTSIZE + 200), 70.0f);
                }
            }
        }
        catch (Exception e) {
            System.out.println("RPVIS draw ERROR: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void keyPressed() {
        if (this.key == 'H' || this.key == 'h') {
            boolean bl = this.hidePressed = !this.hidePressed;
            if (this.hidePressed) {
                if (this.combinedBiplot != null) {
                    this.combinedBiplot.hideLabels();
                }
                if (this.rpBiplot != null) {
                    this.rpBiplot.hideLabels();
                }
            } else {
                if (this.combinedBiplot != null) {
                    this.combinedBiplot.showLabels();
                }
                if (this.rpBiplot != null) {
                    this.rpBiplot.showLabels();
                }
            }
        }
    }

    @Override
    public void mousePressed() {
        try {
            if (this.initialized) {
                if (this.showBiplot && this.combinedBiplot != null) {
                    this.combinedBiplot.mousePressed();
                }
                if (this.showRadplot && this.radialPlot != null) {
                    this.radialPlot.mousePressed();
                    if (radialSelectedVarIndex >= 0) {
                        int[] di = this.getLinkedVariables();
                        double[][] ldata = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, di);
                        this.combinedBiplot.compute(ldata, RPVisualizer.dataSource.columnLabels, di, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Biplot of Linked Variables");
                        this.graph = this.fillGraph(di);
                        int[] sortOrder = this.sortVariablesRadially(di, this.graph);
                        this.varlist.setData(di, null, sortOrder);
                        this.splom.setData(di, RPVisualizer.dataSource.columnLabels, ldata, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
                        this.pcp.updateData(ldata, di, RPVisualizer.dataSource.classValues, null, RPVisualizer.dataSource.nClasses, sortOrder);
                        System.out.println("-----RAD SEL: " + radialSelectedVarIndex);
                        this.showLinkedVars = true;
                        this.showBiplot = true;
                        this.showRadplot = false;
                        this.controlP5.controller("Radial").setVisible(false);
                        this.controlP5.controller("Return_All").setVisible(true);
                    }
                }
                if (this.pcp != null) {
                    this.pcp.mousePressed();
                }
                if (this.histPlot != null) {
                    int prev = listIndex;
                    this.histPlot.mousePressed();
                    if (listIndex != prev) {
                        this.updatePlots();
                    }
                }
                if (!this.showLinkedVars) {
                    if (this.showRVs) {
                        if (this.randVarBiplot != null) {
                            this.randVarBiplot.mousePressed();
                        }
                    } else {
                        if (this.showBiplot && this.combinedBiplot != null) {
                            this.combinedBiplot.mousePressed();
                        }
                        if (this.rpBiplot != null) {
                            this.rpBiplot.mousePressed();
                        }
                        if (selectedProjection >= 0) {
                            this.RPlist[listIndex][selectedProjection].print();
                            int tnum = Math.min(this.MAX_NUM, this.RPlist[listIndex][selectedProjection].getIndices().length);
                            int[] tinds = new int[tnum];
                            System.arraycopy(this.RPlist[listIndex][selectedProjection].getIndices(), 0, tinds, 0, tnum);
                            double[][] pData = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, tinds);
                            this.combinedBiplot.compute(pData, RPVisualizer.dataSource.columnLabels, tinds, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Biplot of RP:" + selectedProjection);
                            int[] sortOrder = this.sortVariablesPCA(this.combinedBiplot.varCoord);
                            this.varlist.setData(tinds, null, sortOrder);
                            this.splom.setData(tinds, RPVisualizer.dataSource.columnLabels, pData, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
                            this.pcp.updateData(pData, tinds, RPVisualizer.dataSource.classValues, null, RPVisualizer.dataSource.nClasses, sortOrder);
                            this.showBiplot = true;
                            this.showRadplot = false;
                            this.controlP5.controller("Radial").setVisible(false);
                            this.controlP5.controller("Return_All").setVisible(true);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("mousePressed ERROR: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void mouseDragged() {
        try {
            if (this.showRVs) {
                if (this.randVarBiplot != null) {
                    this.randVarBiplot.mouseDragged();
                }
            } else {
                if (this.combinedBiplot != null) {
                    this.combinedBiplot.mouseDragged();
                }
                if (this.rpBiplot != null) {
                    this.rpBiplot.mouseDragged();
                }
            }
            if (this.pcp != null) {
                this.pcp.mouseDragged();
            }
        }
        catch (Exception e) {
            System.out.println("mouseDragged ERROR: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void mouseReleased() {
        try {
            if (this.showRVs) {
                if (this.randVarBiplot != null) {
                    this.randVarBiplot.mouseReleased();
                }
            } else {
                if (this.combinedBiplot != null) {
                    this.combinedBiplot.mouseReleased();
                }
                if (this.rpBiplot != null) {
                    this.rpBiplot.mouseReleased();
                }
            }
            if (this.pcp != null) {
                this.pcp.mouseReleased();
            }
        }
        catch (Exception e) {
            System.out.println("mouseReleased ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void resetBrushed() {
        isBrushed = new ArrayList();
    }

    private static String loadFile() {
        FileDialog fd = new FileDialog(new Frame(), "Open", 0);
        fd.setLocation(50, 50);
        fd.setVisible(true);
        return String.valueOf(fd.getDirectory()) + fd.getFile();
    }

    public void Choose_Data(int theValue) {
        this.dataFileName = RPVisualizer.loadFile();
        System.out.println("a button event from Choose Data: " + this.dataFileName);
    }

    public void Biplot(int theValue) {
        this.showBiplot = true;
        this.showSPLOM = false;
        this.showRadplot = false;
    }

    public void SPLOM(int theValue) {
        this.showSPLOM = true;
        this.showBiplot = false;
        this.showRadplot = false;
    }

    public void Radial(int theValue) {
        this.showRadplot = true;
        this.showBiplot = false;
        this.showSPLOM = false;
    }

    public void Return_All(int theValue) {
        radialSelectedVarIndex = -1;
        this.updatePlots();
        this.showLinkedVars = false;
        this.showBiplot = true;
        this.showRadplot = false;
        this.controlP5.controller("Return_All").setVisible(false);
        this.controlP5.controller("Radial").setVisible(true);
    }

    public void Show_Random_Variables(int theValue) {
        boolean bl = this.showRVs = !this.showRVs;
        if (this.showRVs) {
            this.createRandomVariablesPlot();
            this.controlP5.controller("Radial").setVisible(false);
            this.showBiplot = true;
            this.showRadplot = false;
            this.showSPLOM = false;
        }
    }

    public void Update(int theValue) {
        try {
            this.showRVs = false;
            this.showBiplot = true;
            this.randomSeed = Integer.parseInt(this.rseed.getText());
            this.numProjs = Integer.parseInt(this.rproj.getText());
            System.out.println("a button event from Updater: " + this.randomSeed + " " + this.numProjs);
            if (this.dataFileName != null) {
                this.initializePlots();
            } else {
                this.dataFileName = "boston.txt";
                this.initializePlots();
            }
            isOutlier = new ArrayList();
            this.controlP5.controller("Radial").setVisible(true);
            this.controlP5.controller("Biplot").setVisible(true);
            this.controlP5.controller("SPLOM").setVisible(true);
            if (this.scoreType == 0) {
                this.FindAnomalies();
            }
        }
        catch (Exception e) {
            System.out.println("UPDATE ERROR: " + e);
            e.printStackTrace();
        }
    }

    public void FindAnomalies() {
        isOutlier = this.rplister.getOutlierList(listIndex);
        this.checkOutliers();
        System.out.println("---- Comparing SubSpace to Rare classes ----");
        MSTMeasures.evaluateAnomalies(RPVisualizer.dataSource.classValues, this.dataFileName, isOutlier);
        if (allOutliers.size() <= 0) {
            this.computeOutliersOnAllVariables(this.dataFileName);
        }
        this.evaluateOutliersAgainstAll(this.dataFileName, isOutlier);
    }

    private void customizeDropDownList(DropdownList ddl) {
        ddl.setBackgroundColor(this.color(190));
        ddl.setItemHeight(20);
        ddl.setBarHeight(15);
        ddl.captionLabel().set(scoreNames[0]);
        ddl.captionLabel().style().marginTop = 3;
        ddl.captionLabel().style().marginLeft = 3;
        ddl.valueLabel().style().marginTop = 3;
        int i = 0;
        while (i < scoreNames.length) {
            ddl.addItem(scoreNames[i], i);
            ++i;
        }
        ddl.setColorBackground(this.color(60));
        ddl.setColorActive(this.color(255, 128));
    }

    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isGroup()) {
            System.out.println("Event value: " + theEvent.group().value());
            if (theEvent.group().name().equals("scoreList")) {
                this.scoreType = (int)theEvent.group().value();
            }
            if (theEvent.group().name().equals("radioButton")) {
                this.hasClass = (int)theEvent.group().value();
            }
            if (theEvent.group().name().equals("radioButton1")) {
                this.hasRowNames = (int)theEvent.group().value();
            }
        }
    }

    private void setData() {
        if (this.prevFileName == null) {
            this.rplister = new RPLister(this.dataFileName, this.hasClass, this.hasRowNames);
            this.prevFileName = this.dataFileName;
            this.prevHasClass = this.hasClass;
        } else if (!this.prevFileName.equals(this.dataFileName) || this.hasClass != this.prevHasClass) {
            this.rplister = new RPLister(this.dataFileName, this.hasClass, this.hasRowNames);
            this.prevFileName = this.dataFileName;
            this.prevHasClass = this.hasClass;
        }
    }

    private void initializePlots() {
        System.out.println("initializing plots...");
        try {
            this.setData();
            this.rplister.process(new Random(this.randomSeed + (int)(Math.random() * 10.0)), this.scoreType, this.numProjs);
            dataSource = this.rplister.inputData;
            this.RPlist = this.rplister.getRPlist();
            listIndex = 0;
            int x = this.PAD;
            int y = 100;
            int xloc = x + 2 * this.PLOTSIZE + 3 * this.PAD;
            this.histPlot = new HistogramPlot(xloc, y, 210, 140, this);
            this.histPlot.setData(scoreNames[this.scoreType], this.rplister.getRPListScores(), this.scoreType);
            this.radarPlot = new RadarPlot(xloc, y + 160, 210, this);
            this.radarPlot.setData(scoreNames, this.rplister.getListScagnosticScores(listIndex), this.scoreType);
            this.dominantVariables = this.getTopVariables(this.RPlist[listIndex]);
            this.graph = this.fillGraph(this.dominantVariables);
            this.dominantVariableData = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, this.dominantVariables);
            this.combinedBiplot = new Biplot(x, y, this.PLOTSIZE, this, false);
            this.combinedBiplot.compute(this.dominantVariableData, RPVisualizer.dataSource.columnLabels, this.dominantVariables, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Biplot of Dominant Variables");
            int[] sortOrder = this.sortVariablesRadially(this.dominantVariables, this.graph);
            this.radialPlot = new RadialPlot(x, y, this.PLOTSIZE, this.PLOTSIZE, this.PAD, this);
            this.radialPlot.setData(this.dominantVariables, RPVisualizer.dataSource.columnLabels, this.graph, sortOrder);
            this.splom = new SPLOM(x, y, this.PLOTSIZE, 5, this);
            this.splom.setData(this.dominantVariables, RPVisualizer.dataSource.columnLabels, this.dominantVariableData, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
            xloc = this.WIDTH - 180;
            this.varlist = new VarList(xloc, y, 200, this.HEIGHT - 125, this, RPVisualizer.dataSource.columnLabels);
            this.varlist.setData(this.dominantVariables, this.graph, sortOrder);
            x = this.PLOTSIZE + 2 * this.PAD;
            int[] plbls = new int[this.RPlist[listIndex].length];
            int i = 0;
            while (i < this.RPlist[listIndex].length) {
                plbls[i] = i;
                ++i;
            }
            this.projectionData = this.getDataForProjections();
            this.rpBiplot = new Biplot(x, y, this.PLOTSIZE, this, true);
            this.rpBiplot.compute(this.projectionData, RPVisualizer.dataSource.columnLabels, plbls, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Biplot of Random Projections");
            this.pcp = new ParallelCoordPanel(this.dominantVariableData, RPVisualizer.dataSource.columnLabels, this.dominantVariables, this.WIDTH - 200, this.HEIGHT - this.PLOTSIZE - 150, this.PAD, this.PLOTSIZE + 120, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, this.graph, sortOrder, this);
            this.evaluateSubspace();
            this.initialized = true;
        }
        catch (Exception e) {
            System.out.println("initializePlots ERROR: " + e);
            e.printStackTrace();
        }
    }

    private void createRandomVariablesPlot() {
        int x = this.PAD;
        int y = 100;
        this.rplister.getGoodRandomVariables();
        this.RVlist = this.rplister.getRVlist();
        listIndex = 0;
        double[][] rdata = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, this.RVlist[listIndex]);
        this.randVarBiplot = new Biplot(x, y, this.PLOTSIZE, this, false);
        this.randVarBiplot.compute(rdata, RPVisualizer.dataSource.columnLabels, this.RVlist[listIndex], RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Random Variables Score: " + this.rplister.getRVListScores()[listIndex]);
        this.evaluateSubspace(this.RVlist[listIndex]);
        if (this.scoreType == 0) {
            System.out.println("---- Comparing Random to Rare classes ----");
            MSTMeasures tmp = new MSTMeasures();
            double randOutlierMeasure = tmp.computeOutlierMeasure(RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, this.RVlist[listIndex]));
            System.out.println("RPVIS:: outlier score using random variables: " + randOutlierMeasure);
            ArrayList<Integer> routliers = tmp.getOutliers();
            MSTMeasures.evaluateAnomalies(RPVisualizer.dataSource.classValues, this.dataFileName, routliers);
            if (allOutliers.size() <= 0) {
                this.computeOutliersOnAllVariables(this.dataFileName);
            }
            this.evaluateOutliersAgainstAll(this.dataFileName, routliers);
        }
        int[] sortOrder = this.sortVariablesPCA(this.randVarBiplot.varCoord);
        this.varlist.setData(this.RVlist[listIndex], null, sortOrder);
        this.splom.setData(this.RVlist[listIndex], RPVisualizer.dataSource.columnLabels, rdata, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
        this.pcp.updateData(rdata, this.RVlist[listIndex], RPVisualizer.dataSource.classValues, null, RPVisualizer.dataSource.nClasses, sortOrder);
        this.histPlot.setData(scoreNames[this.scoreType], this.rplister.getRVListScores(), this.scoreType);
        this.radarPlot.setData(scoreNames, this.rplister.getListScagnosticScores(listIndex), this.scoreType);
    }

    public void updatePlots() {
        if (this.showRVs) {
            double[][] rdata = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, this.RVlist[listIndex]);
            this.randVarBiplot.compute(rdata, RPVisualizer.dataSource.columnLabels, this.RVlist[listIndex], RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Random Variables Score: " + this.rplister.getRVListScores()[listIndex]);
            int[] sortOrder = this.sortVariablesPCA(this.randVarBiplot.varCoord);
            this.varlist.setData(this.RVlist[listIndex], null, sortOrder);
            this.pcp.updateData(rdata, this.RVlist[listIndex], RPVisualizer.dataSource.classValues, null, RPVisualizer.dataSource.nClasses, sortOrder);
            this.radarPlot.setData(scoreNames, this.rplister.getListScagnosticScores(listIndex), this.scoreType);
            this.splom.setData(this.RVlist[listIndex], RPVisualizer.dataSource.columnLabels, rdata, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
        } else {
            this.radarPlot.setData(scoreNames, this.rplister.getListScagnosticScores(listIndex), this.scoreType);
            this.dominantVariables = this.getTopVariables(this.RPlist[listIndex]);
            this.dominantVariableData = RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, this.dominantVariables);
            this.graph = this.fillGraph(this.dominantVariables);
            int[] sortOrder = this.sortVariablesRadially(this.dominantVariables, this.graph);
            this.varlist.setData(this.dominantVariables, this.graph, sortOrder);
            this.radialPlot.setData(this.dominantVariables, RPVisualizer.dataSource.columnLabels, this.graph, sortOrder);
            this.combinedBiplot.compute(this.dominantVariableData, RPVisualizer.dataSource.columnLabels, this.dominantVariables, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Random Projection Score: " + this.rplister.getRPListScores()[listIndex]);
            this.splom.setData(this.dominantVariables, RPVisualizer.dataSource.columnLabels, this.dominantVariableData, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.classValues, sortOrder);
            this.projectionData = this.getDataForProjections();
            int[] plbls = new int[this.RPlist[listIndex].length];
            int i = 0;
            while (i < this.RPlist[listIndex].length) {
                plbls[i] = i;
                ++i;
            }
            this.rpBiplot.compute(this.projectionData, RPVisualizer.dataSource.columnLabels, plbls, RPVisualizer.dataSource.classValues, RPVisualizer.dataSource.nClasses, RPVisualizer.dataSource.rowNames, this.scoreType, "Biplot of Random Projections");
            this.pcp.updateData(this.dominantVariableData, this.dominantVariables, RPVisualizer.dataSource.classValues, this.graph, RPVisualizer.dataSource.nClasses, sortOrder);
        }
        if (this.scoreType == 0) {
            isOutlier = this.rplister.getOutlierList(listIndex);
            this.checkOutliers();
        }
    }

    private int[] sortVariablesPCA(double[][] varCoords) {
        double[] vals = new double[varCoords.length];
        int i = 0;
        while (i < varCoords.length) {
            vals[i] = Math.abs(varCoords[i][0]);
            ++i;
        }
        return Sorter.indexedDoubleArraySort(vals, 0, vals.length);
    }

    private int[] sortVariablesRadially(int[] domVars, float[][] vgraph) {
        int nVars = domVars.length;
        ArrayList<Integer> order = new ArrayList<Integer>(nVars);
        int[] res = new int[nVars];
        if (vgraph != null) {
            boolean[] visited = new boolean[nVars];
            int i = 0;
            while (i < nVars) {
                this.depthFirstVisit(i, visited, order, vgraph);
                ++i;
            }
            i = 0;
            while (i < order.size()) {
                res[i] = (Integer)order.get(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < nVars) {
                res[i] = i;
                ++i;
            }
        }
        return res;
    }

    private void depthFirstVisit(int index, boolean[] visited, List<Integer> order, float[][] vgraph) {
        if (!visited[index]) {
            visited[index] = true;
            order.add(index);
            int maxCount = Integer.MIN_VALUE;
            int maxInd = -1;
            int j = 0;
            while (j < vgraph[index].length) {
                if (vgraph[index][j] > 0.0f && !visited[j] && this.counts[j] > maxCount) {
                    maxCount = this.counts[j];
                    maxInd = j;
                }
                ++j;
            }
            if (maxInd > 0) {
                this.depthFirstVisit(maxInd, visited, order, vgraph);
            }
        }
    }

    private double[][] getDataForProjections() {
        double[][] selData = new double[RPVisualizer.dataSource.nPts][this.numProjs];
        try {
            int d = 0;
            while (d < RPVisualizer.dataSource.nPts) {
                int i = 0;
                while (i < this.RPlist[listIndex].length) {
                    int[] xinds = this.RPlist[listIndex][i].getIndices();
                    double[] wts = this.RPlist[listIndex][i].getWeights();
                    int j = 0;
                    while (j < xinds.length) {
                        double[] dArray = selData[d];
                        int n = i;
                        dArray[n] = dArray[n] + RPVisualizer.dataSource.data[d][xinds[j]] * wts[j];
                        ++j;
                    }
                    ++i;
                }
                ++d;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e);
            e.printStackTrace();
        }
        return selData;
    }

    private int[] getLinkedVariables() {
        int selIndex = -1;
        selIndex = this.radialPlot.getIndex(this.dominantVariables, radialSelectedVarIndex);
        int topVars = 0;
        int i = 0;
        while (i < this.graph[selIndex].length) {
            if (this.graph[selIndex][i] > 0.0f) {
                ++topVars;
            }
            ++i;
        }
        topVars = Math.min(topVars, this.MAX_NUM);
        int[] indices = new int[topVars];
        int i2 = 0;
        int c = 0;
        while (i2 < this.graph[selIndex].length) {
            if (this.graph[selIndex][i2] > 0.0f) {
                indices[c] = this.dominantVariables[i2];
                ++c;
            }
            ++i2;
        }
        return indices;
    }

    private int[] getTopVariables(ProjectionInfo[] projs) {
        HashMap<Integer, Integer> indexCounts = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < projs.length) {
            int[] inds = projs[i].getIndices();
            int j = 0;
            while (j < inds.length) {
                try {
                    indexCounts.put(inds[j], (Integer)indexCounts.get(inds[j]) + 1);
                }
                catch (Exception e) {
                    indexCounts.put(inds[j], 1);
                }
                ++j;
            }
            ++i;
        }
        HashMap<Integer, ArrayList> countIndices = new HashMap<Integer, ArrayList>();
        Iterator ki = indexCounts.keySet().iterator();
        int[] vc = new int[indexCounts.size()];
        int index = 0;
        while (ki.hasNext()) {
            int key = (Integer)ki.next();
            vc[index] = (Integer)indexCounts.get(key);
            ArrayList l = new ArrayList();
            if (countIndices.containsKey(vc[index])) {
                l = (ArrayList)countIndices.get(vc[index]);
            }
            l.add(key);
            countIndices.put(vc[index], l);
            ++index;
        }
        double median = this.getMedian(vc);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        index = 0;
        int[] sortedCounts = new int[countIndices.size()];
        int si = 0;
        for (Integer k : countIndices.keySet()) {
            sortedCounts[si] = k;
            ++si;
        }
        Arrays.sort(sortedCounts);
        int i2 = sortedCounts.length - 1;
        while (i2 >= 0) {
            int key = sortedCounts[i2];
            if ((double)key >= median) {
                ArrayList l = (ArrayList)countIndices.get(key);
                while (index < l.size() && index <= this.MAX_NUM) {
                    indices.add((Integer)l.get(index));
                    ++index;
                }
                if (index > this.MAX_NUM) break;
            }
            --i2;
        }
        int[] ints = new int[indices.size()];
        index = 0;
        for (Integer n : indices) {
            ints[index++] = n;
        }
        System.out.println("# Top Vars: " + indices.size() + " Threshold: " + median);
        return ints;
    }

    private double getMedian(int[] vals) {
        int[] c = new int[vals.length];
        System.arraycopy(vals, 0, c, 0, vals.length);
        Arrays.sort(c);
        return c.length % 2 == 0 ? ((double)c[vals.length / 2] + (double)c[vals.length / 2 - 1] * 1.0) / 2.0 : (double)c[vals.length / 2];
    }

    public static double[][] getDataForVariables(double[][] data, int[] indices) {
        int n = indices.length;
        int npts = data.length;
        double[][] selData = new double[npts][n];
        int j = 0;
        while (j < npts) {
            int i = 0;
            while (i < n) {
                selData[j][i] = data[j][indices[i]];
                ++i;
            }
            ++j;
        }
        return selData;
    }

    private float[][] fillGraph(int[] indices) {
        int gn = indices.length;
        float[][] graph = new float[gn][gn];
        float max = Float.MIN_VALUE;
        try {
            int i = 0;
            while (i < this.RPlist[listIndex].length) {
                int[] xinds = this.RPlist[listIndex][i].getIndices();
                int j = 0;
                while (j < xinds.length) {
                    int k = j;
                    while (k < xinds.length) {
                        int a = this.isIn(indices, xinds[j]);
                        int b = this.isIn(indices, xinds[k]);
                        if (a >= 0 && b >= 0) {
                            float[] fArray = graph[a];
                            int n = b;
                            fArray[n] = fArray[n] + 1.0f;
                            if (k != j) {
                                float[] fArray2 = graph[b];
                                int n2 = a;
                                fArray2[n2] = fArray2[n2] + 1.0f;
                                if (graph[a][b] > max) {
                                    max = graph[a][b];
                                }
                                if (graph[b][a] > max) {
                                    max = graph[b][a];
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.counts = new int[gn];
            i = 0;
            while (i < gn) {
                this.counts[i] = 0;
                int j = 0;
                while (j < gn) {
                    if (i != j && graph[i][j] > 0.0f) {
                        int n = i;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    float[] fArray = graph[i];
                    int n = j++;
                    fArray[n] = fArray[n] / max;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR filling graph " + e);
            e.printStackTrace();
        }
        return graph;
    }

    private int isIn(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void checkOutliers() {
        try {
            String[] pieces = this.dataFileName.split("/");
            String fname = pieces[0];
            int i = 1;
            while (i < pieces.length - 1) {
                fname = String.valueOf(fname) + "/" + pieces[i];
                ++i;
            }
            File f = new File(fname = String.valueOf(fname) + "/Outliers-" + pieces[pieces.length - 1]);
            if (f.exists()) {
                BufferedReader bwx = new BufferedReader(new FileReader(f));
                String line = bwx.readLine();
                ArrayList<Integer> actualOutliers = new ArrayList<Integer>();
                while (line != null) {
                    actualOutliers.add(Integer.parseInt(line.trim()));
                    line = bwx.readLine();
                }
                bwx.close();
                int tp = 0;
                int i2 = 0;
                while (i2 < actualOutliers.size()) {
                    if (isOutlier.contains(actualOutliers.get(i2))) {
                        ++tp;
                    }
                    ++i2;
                }
                System.out.println("@@@@@@@@@@@@@@@@ Correctly detected outliers = " + tp + " total Actual  = " + actualOutliers.size() + " total Detected = " + isOutlier.size());
            }
        }
        catch (IOException ie) {
            System.out.println("RPVisualizer:: Error writing outliers: " + ie);
            ie.printStackTrace();
        }
    }

    public void computeOutliersOnAllVariables(String fname) {
        if (RPVisualizer.dataSource.nVars < 1000) {
            int[] indices = new int[RPVisualizer.dataSource.nVars];
            int i = 0;
            while (i < RPVisualizer.dataSource.nVars) {
                indices[i] = i;
                ++i;
            }
            MSTMeasures tmp = new MSTMeasures();
            double allOutlierMeasure = tmp.computeOutlierMeasure(RPVisualizer.getDataForVariables(RPVisualizer.dataSource.data, indices));
            System.out.println("RPVIS:: outlier score using all data: " + allOutlierMeasure);
            allOutliers = tmp.getOutliers();
            System.out.println("---- Comparing AllSpace to Rare classes ----");
            MSTMeasures.evaluateAnomalies(RPVisualizer.dataSource.classValues, fname, allOutliers);
        }
    }

    public void evaluateOutliersAgainstAll(String fname, ArrayList<Integer> outlierIndices) {
        if (allOutliers.size() > 0) {
            int numActualDetected = 0;
            int numDetected = 0;
            int numActual = 0;
            int i = 0;
            while (i < outlierIndices.size()) {
                ++numDetected;
                if (allOutliers.contains(outlierIndices.get(i))) {
                    ++numActualDetected;
                }
                ++i;
            }
            numActual = allOutliers.size();
            System.out.println("---- Comparing Subspace to Allspace ----");
            MSTMeasures.printPrecisionRecall(numActual, numActualDetected, numDetected);
            MSTMeasures.writeOutlierStats(fname, RPVisualizer.dataSource.nPts, RPVisualizer.dataSource.nVars, this.numProjs, this.randomSeed, numActual, numActualDetected, numDetected);
        }
    }

    public void evaluateSubspace() {
        try {
            String[] pieces = this.dataFileName.split("/");
            String fname = pieces[0];
            int i = 1;
            while (i < pieces.length - 1) {
                fname = String.valueOf(fname) + "/" + pieces[i];
                ++i;
            }
            fname = String.valueOf(fname) + "/V-" + pieces[pieces.length - 1];
            File f = new File(fname);
            int generatedTotal = 0;
            if (f.exists()) {
                BufferedReader bwx = new BufferedReader(new FileReader(f));
                String line = bwx.readLine();
                int i2 = 0;
                genVariables = new ArrayList();
                while (line != null) {
                    genVariables.add(line.trim());
                    line = bwx.readLine();
                    ++i2;
                }
                bwx.close();
                generatedTotal = i2 - 1;
                int domMatch = 0;
                int rpMatch = 0;
                i2 = 0;
                while (i2 < this.dominantVariables.length) {
                    String s = RPVisualizer.dataSource.columnLabels[this.dominantVariables[i2]];
                    if (genVariables.contains(s)) {
                        System.out.println("matched: " + s);
                        ++domMatch;
                    }
                    ++i2;
                }
                System.out.println("RP DOM: tp=" + domMatch + " total: " + this.dominantVariables.length);
                System.out.println("% Generated Variables that match Dominant = " + (double)domMatch * 1.0 / (double)generatedTotal * 100.0);
                ArrayList<Integer> seen = new ArrayList<Integer>();
                i2 = 0;
                while (i2 < this.RPlist[listIndex].length) {
                    int[] inds = this.RPlist[listIndex][i2].getIndices();
                    int j = 0;
                    while (j < inds.length) {
                        if (!seen.contains(inds[j])) {
                            String s = RPVisualizer.dataSource.columnLabels[inds[j]];
                            if (genVariables.contains(s)) {
                                System.out.println("matched: " + s);
                                ++rpMatch;
                            }
                            seen.add(inds[j]);
                        }
                        ++j;
                    }
                    ++i2;
                }
                System.out.println("RP ALL: tp=" + rpMatch + " total: " + seen.size());
                System.out.println("% Generated Variables that match RP = " + (double)rpMatch * 1.0 / (double)generatedTotal * 100.0);
            }
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }

    public void evaluateSubspace(int[] indices) {
        if (genVariables != null) {
            int generatedTotal = genVariables.size();
            int randMatch = 0;
            int i = 0;
            while (i < indices.length) {
                String s = RPVisualizer.dataSource.columnLabels[indices[i]];
                if (genVariables.contains(s)) {
                    System.out.println("matched: " + s);
                    ++randMatch;
                }
                ++i;
            }
            System.out.println("RANDOM VARIABLES: tp=" + randMatch + " total: " + indices.length);
            System.out.println("% Generated Variables that match Random = " + (double)randMatch * 1.0 / (double)generatedTotal * 100.0);
        }
    }
}

