/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import processing.core.PApplet;

public class RadarPlot {
    PApplet parent;
    int size;
    int xpos;
    int ypos;
    String[] labels;
    double[] scores;
    int chosenScore;
    int xPAD;
    int yPAD;

    public RadarPlot(int x, int y, int size, PApplet p) {
        System.out.println("RADARPLOT: " + x + "," + y + " size: " + size);
        this.xpos = x;
        this.ypos = y;
        this.size = size;
        this.parent = p;
        this.yPAD = 5;
        this.xPAD = 5;
    }

    public void setData(String[] l, double[] s, int chosen) {
        block6: {
            int i;
            double maxScore;
            block5: {
                this.labels = l;
                this.scores = new double[s.length];
                System.arraycopy(s, 0, this.scores, 0, s.length);
                this.chosenScore = chosen;
                this.xPAD = (int)this.parent.textWidth(this.labels[0]);
                System.out.println(" score: " + this.labels[0] + " val: " + this.scores[0]);
                int i2 = 1;
                while (i2 < this.labels.length) {
                    int adv = (int)this.parent.textWidth(this.labels[i2]);
                    if (adv > this.xPAD) {
                        this.xPAD = adv;
                    }
                    System.out.println("i: " + i2 + " score: " + this.labels[i2] + " val: " + this.scores[i2]);
                    ++i2;
                }
                maxScore = -1.0;
                i = 0;
                while (i < this.scores.length) {
                    maxScore = Math.max(maxScore, this.scores[i]);
                    ++i;
                }
                if (!(maxScore <= 0.1)) break block5;
                i = 0;
                while (i < this.scores.length) {
                    int n = i++;
                    this.scores[n] = this.scores[n] * 10.0;
                }
                break block6;
            }
            if (!(maxScore <= -0.5)) break block6;
            i = 0;
            while (i < this.scores.length) {
                int n = i++;
                this.scores[n] = this.scores[n] + 0.1;
            }
        }
    }

    public void draw() {
        if (this.labels != null) {
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.fill(RPVisualizer.plotBGColor.getRGB());
            this.parent.rect(this.xpos, this.ypos, this.size, this.size);
            int radiusX = this.size / 2 - this.xPAD;
            int centerX = this.xpos + this.size / 2;
            int centerY = this.ypos + this.size / 2;
            int nVars = this.labels.length;
            double theta = (float)Math.PI * 2 / (float)nVars;
            this.parent.textSize(9.0f);
            int i = 0;
            while (i < nVars) {
                this.parent.stroke(Color.LIGHT_GRAY.getRGB());
                double angle = theta * (double)i;
                int endX = (int)((double)centerX + (double)radiusX * Math.cos(angle));
                int endY = (int)((double)centerY + (double)radiusX * Math.sin(angle));
                this.parent.line(centerX, centerY, endX, endY);
                if (angle > 1.5707963267948966 && angle < 4.71238898038469) {
                    endX = (int)((float)endX - this.parent.textWidth(this.labels[i]));
                }
                if (angle == 1.5707963267948966 || angle == 4.71238898038469) {
                    endX = (int)((float)endX - this.parent.textWidth(this.labels[i]) / 2.0f);
                }
                if (i == this.chosenScore) {
                    this.parent.fill(RPVisualizer.textColor.getRGB());
                } else {
                    this.parent.fill(55.0f, 85.0f, 100.0f, 100.0f);
                }
                this.parent.text(this.labels[i], (float)endX, (float)endY);
                ++i;
            }
            this.parent.textSize(14.0f);
            this.parent.stroke(Color.ORANGE.getRGB());
            i = 0;
            while (i < nVars - 1) {
                double angle1 = theta * (double)i;
                int x1 = (int)((double)centerX + this.scores[i] * ((double)radiusX * Math.cos(angle1)));
                int y1 = (int)((double)centerY + this.scores[i] * ((double)radiusX * Math.sin(angle1)));
                double angle2 = theta * (double)(i + 1);
                int x2 = (int)((double)centerX + this.scores[i + 1] * ((double)radiusX * Math.cos(angle2)));
                int y2 = (int)((double)centerY + this.scores[i + 1] * ((double)radiusX * Math.sin(angle2)));
                this.parent.line(x1, y1, x2, y2);
                ++i;
            }
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.text("Subspace Scores", (float)this.xpos, (float)(this.ypos + this.size + 15));
        }
    }
}

