/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import processing.core.PApplet;
import processing.core.PFont;
import scores.ProjectionInfo;

public class RadialPlot {
    PApplet parent;
    int width;
    int height;
    int xpos;
    int ypos;
    int nVars;
    int PAD;
    double radius;
    float[][] graph;
    double[] varImgPos;
    int[] topVars;
    int[] counts;
    int[] sortOrder;
    boolean[] used;
    String[] topVarLabels;
    Point[] pts;

    public RadialPlot(int x, int y, int widthP, int heightP, int padP, PApplet p) {
        this.width = widthP;
        this.height = heightP;
        this.xpos = x;
        this.ypos = y;
        this.parent = p;
        this.graph = null;
        this.varImgPos = null;
        this.used = null;
    }

    public void setData(int[] domVars, String[] columnLabels, float[][] g, int[] variablesOrder) {
        System.out.println("RADPLT: " + domVars.length + " " + g.length);
        this.graph = g;
        this.used = null;
        this.topVars = domVars;
        this.nVars = domVars.length;
        this.pts = new Point[this.nVars];
        this.counts = new int[this.nVars];
        this.topVarLabels = new String[this.nVars];
        int i = 0;
        while (i < this.nVars) {
            this.topVarLabels[i] = columnLabels[domVars[i]];
            ++i;
        }
        this.sortOrder = variablesOrder;
    }

    public void draw() {
        if (this.topVarLabels != null) {
            int i;
            this.parent.colorMode(3, 100.0f);
            this.parent.fill(RPVisualizer.plotBGColor.getRGB());
            this.parent.rect(this.xpos, this.ypos, this.width, this.height);
            PFont font = this.parent.createFont("Helvetica", 14.0f);
            this.parent.textFont(font);
            this.PAD = -1;
            int i2 = 0;
            while (i2 < this.nVars) {
                int adv = (int)this.parent.textWidth("V" + this.topVars[i2]);
                if (adv > this.PAD) {
                    this.PAD = adv;
                }
                ++i2;
            }
            this.radius = (double)(Math.min(this.height, this.width) - 2 * this.PAD) / 2.0;
            if (this.varImgPos == null) {
                this.setVariablesOnCircumference();
            }
            this.mouseOver();
            this.parent.stroke(Color.GRAY.getRGB());
            this.parent.ellipseMode(0);
            this.parent.ellipse(this.xpos + this.PAD, this.ypos + this.PAD, (int)this.radius * 2, (int)this.radius * 2);
            int selectedIndex = this.getIndex(this.topVars, RPVisualizer.radialSelectedVarIndex);
            if (this.graph != null) {
                i = 0;
                while (i < this.graph.length) {
                    int x1 = this.xpos + (int)(Math.cos(this.varImgPos[i]) * this.radius + (double)this.PAD + this.radius);
                    int y1 = this.ypos + (int)(Math.sin(this.varImgPos[i]) * this.radius + (double)this.PAD + this.radius);
                    this.parent.fill(Color.GRAY.getRGB());
                    this.parent.stroke(Color.GRAY.getRGB());
                    int j = i + 1;
                    while (j < this.graph[i].length) {
                        if (this.graph[i][j] != 0.0f) {
                            float thickness = 0.5f;
                            int x2 = this.xpos + (int)(Math.cos(this.varImgPos[j]) * this.radius + (double)this.PAD + this.radius);
                            int y2 = this.ypos + (int)(Math.sin(this.varImgPos[j]) * this.radius + (double)this.PAD + this.radius);
                            this.parent.strokeWeight(thickness + this.graph[i][j] * 3.0f);
                            this.parent.line(x1, y1, x2, y2);
                            this.parent.strokeWeight(1.0f);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (selectedIndex >= 0) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                    this.parent.stroke(RPVisualizer.textSelectColor.getRGB());
                    int x1 = this.xpos + (int)(Math.cos(this.varImgPos[selectedIndex]) * this.radius + (double)this.PAD + this.radius);
                    int y1 = this.ypos + (int)(Math.sin(this.varImgPos[selectedIndex]) * this.radius + (double)this.PAD + this.radius);
                    int j = 0;
                    while (j < this.graph[selectedIndex].length) {
                        if (this.graph[selectedIndex][j] != 0.0f) {
                            float thickness = 0.5f;
                            int x2 = this.xpos + (int)(Math.cos(this.varImgPos[j]) * this.radius + (double)this.PAD + this.radius);
                            int y2 = this.ypos + (int)(Math.sin(this.varImgPos[j]) * this.radius + (double)this.PAD + this.radius);
                            this.parent.strokeWeight(thickness + this.graph[selectedIndex][j] * 3.0f);
                            this.parent.line(x1, y1, x2, y2);
                            this.parent.strokeWeight(1.0f);
                        }
                        ++j;
                    }
                }
            }
            this.parent.stroke(Color.GRAY.getRGB());
            i = 0;
            while (i < this.nVars) {
                this.parent.fill(RPVisualizer.textColor.getRGB());
                if (RPVisualizer.genVariables != null) {
                    int aa = 0;
                    while (aa < RPVisualizer.genVariables.size()) {
                        if (this.topVarLabels[i].equals(RPVisualizer.genVariables.get(aa))) {
                            this.parent.fill(RPVisualizer.matchColor.getRGB());
                        }
                        ++aa;
                    }
                }
                if (this.graph != null && selectedIndex >= 0 && this.graph[selectedIndex][i] != 0.0f) {
                    this.parent.fill(Color.CYAN.getRGB());
                }
                if (this.used != null && this.used[i]) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                }
                if (RPVisualizer.radialSelectedVarIndex == this.topVars[i] || RPVisualizer.hoverVariable == this.topVars[i]) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                }
                float xPos = (float)(this.xpos + this.PAD) + (float)this.radius + (float)this.radius * (float)Math.cos(this.varImgPos[i]);
                float yPos = (float)(this.ypos + this.PAD) + (float)this.radius + (float)this.radius * (float)Math.sin(this.varImgPos[i]);
                float textwidth = this.parent.textWidth("V" + this.topVars[i]);
                this.parent.pushMatrix();
                float angle = (float)this.varImgPos[i];
                int x = 3;
                int y = 3;
                int xx = 0;
                boolean yy = false;
                this.pts[i] = new Point(x + (int)xPos, y + (int)yPos);
                this.parent.translate(xPos, yPos);
                if (angle <= 1.5707964f) {
                    angle += 0.1f;
                    xx -= 4;
                } else if (angle >= 4.712389f) {
                    angle = -((float)Math.PI * 2 - angle) - 0.1f;
                    xx -= 4;
                } else {
                    angle = angle - (float)Math.PI - 0.1f;
                    x = (int)((float)x - (textwidth + 6.0f));
                }
                float csize = this.counts[i] * 3;
                this.parent.ellipse(xx, (float)yy, csize, csize);
                this.parent.rotate(angle);
                this.parent.text("V" + this.topVars[i], (float)x, (float)y);
                this.parent.popMatrix();
                ++i;
            }
            this.parent.fill(Color.GRAY.getRGB());
            this.parent.stroke(Color.GRAY.getRGB());
        }
    }

    public void setUsed(ProjectionInfo p) {
        this.used = new boolean[this.topVars.length];
        int i = 0;
        while (i < this.topVars.length) {
            if (this.isIn(p.getIndices(), this.topVars[i])) {
                this.used[i] = true;
            }
            ++i;
        }
    }

    public void resetUsed() {
        this.used = null;
    }

    private boolean isIn(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int getIndex(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void setVariablesOnCircumference() {
        double alpha = Math.PI * 2 / (double)this.nVars;
        this.varImgPos = new double[this.nVars];
        int i = 0;
        while (i < this.nVars) {
            this.varImgPos[i] = alpha * (double)this.sortOrder[i];
            ++i;
        }
    }

    public void mousePressed() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.height);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.pts.length) {
                if (this.pts[i] != null && this.contains(this.pts[i], i, new Point(mX, mY))) {
                    flag = true;
                    RPVisualizer.radialSelectedVarIndex = this.topVars[i];
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.radialSelectedVarIndex = -1;
            }
        }
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.height);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.pts.length) {
                if (this.pts[i] != null && this.contains(this.pts[i], i, new Point(mX, mY))) {
                    flag = true;
                    RPVisualizer.radialSelectedVarIndex = this.topVars[i];
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.radialSelectedVarIndex = -1;
            }
        }
    }

    private boolean contains(Point pt, int i, Point p) {
        int pad = 10;
        return p.x >= pt.x - pad && p.x <= pt.x + pad && p.y >= pt.y - pad && p.y <= pt.y + pad;
    }
}

