/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import model.Utils;
import processing.core.PApplet;

public class SPLOM {
    PApplet parent;
    int size;
    int xpos;
    int ypos;
    int CSIZE;
    int BORDER;
    int NUM;
    int nClasses;
    double[][] data;
    int[] vindices;
    String[] labels;
    int nplots;
    int[] selected;
    int[] classLabels;
    int[] ordering;

    public SPLOM(int x, int y, int size, int num, PApplet p) {
        System.out.println("SPLOM: " + x + "," + y + " size: " + size);
        this.xpos = x;
        this.ypos = y;
        this.size = size;
        this.parent = p;
        this.NUM = num + 1;
        this.BORDER = 2;
        this.nplots = this.NUM;
        this.CSIZE = size / this.nplots;
        this.data = null;
        this.vindices = null;
        this.selected = null;
        this.nClasses = 0;
        this.classLabels = null;
        this.ordering = null;
    }

    public void setData(int[] inds, String[] l, double[][] d, int nc, int[] clabels, int[] sortOrder) {
        this.data = Utils.normalize(d);
        this.vindices = inds;
        this.labels = l;
        this.classLabels = clabels;
        this.nClasses = nc;
        this.nplots = Math.min(this.NUM, this.vindices.length);
        this.CSIZE = this.size / (this.nplots - 1);
        this.ordering = sortOrder;
    }

    public void draw() {
        if (this.vindices != null) {
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.fill(RPVisualizer.plotBGColor.getRGB());
            this.parent.rect(this.xpos, this.ypos, this.size, this.size);
            this.parent.textSize(12.0f);
            this.mouseOver();
            int[] flipOrder = new int[this.ordering.length];
            int oi = 0;
            while (oi < this.ordering.length) {
                flipOrder[this.ordering[oi]] = oi;
                ++oi;
            }
            int i = 1;
            while (i < this.nplots) {
                int yloc = this.ypos + (i - 1) * this.CSIZE + this.BORDER;
                int j = 0;
                while (j < i) {
                    int iy;
                    int ix;
                    int xloc = this.xpos + j * this.CSIZE + this.BORDER;
                    this.parent.fill(RPVisualizer.plotBGColor.getRGB());
                    this.parent.stroke(Color.LIGHT_GRAY.getRGB());
                    this.parent.strokeWeight(1.0f);
                    this.parent.rect(xloc, yloc, this.CSIZE - 2 * this.BORDER, this.CSIZE - 2 * this.BORDER);
                    if (this.selected != null) {
                        this.parent.strokeWeight(2.0f);
                        if (this.selected[0] == i && this.selected[1] == j) {
                            this.parent.stroke(RPVisualizer.ySelectColor.getRGB());
                            this.parent.line(xloc, yloc, xloc + this.CSIZE - 2 * this.BORDER, yloc);
                            this.parent.line(xloc, yloc + this.CSIZE - 2 * this.BORDER, xloc + this.CSIZE - 2 * this.BORDER, yloc + this.CSIZE - 2 * this.BORDER);
                            this.parent.stroke(RPVisualizer.xSelectColor.getRGB());
                            this.parent.line(xloc, yloc, xloc, yloc + this.CSIZE - 2 * this.BORDER);
                            this.parent.line(xloc + this.CSIZE - 2 * this.BORDER, yloc, xloc + this.CSIZE - 2 * this.BORDER, yloc + this.CSIZE - 2 * this.BORDER);
                        }
                    }
                    this.parent.strokeWeight(1.0f);
                    this.parent.fill(Color.LIGHT_GRAY.getRGB(), 60.0f);
                    this.parent.stroke(Color.LIGHT_GRAY.getRGB(), 60.0f);
                    float SKIP = 25.0f;
                    boolean ADD = false;
                    float h = (100.0f - SKIP) / (float)this.data.length;
                    float transparency = 80.0f;
                    if (this.nClasses > 0) {
                        h = (100.0f - SKIP) / (float)this.nClasses;
                    }
                    int row = 0;
                    while (row < this.data.length) {
                        if (this.nClasses > 0) {
                            this.parent.fill((float)ADD + h * (float)this.classLabels[row], 80.0f, 80.0f, transparency);
                            this.parent.stroke((float)ADD + h * (float)this.classLabels[row], 80.0f, 80.0f, transparency);
                        } else {
                            this.parent.fill((float)ADD + h * (float)row, 80.0f, 80.0f, transparency);
                            this.parent.stroke((float)ADD + h * (float)row, 80.0f, 80.0f, transparency);
                        }
                        ix = xloc + 2 * this.BORDER + (int)(this.data[row][flipOrder[i]] * (double)(this.CSIZE - 5 * this.BORDER));
                        iy = yloc + this.CSIZE - 2 * this.BORDER - (int)(this.data[row][flipOrder[j]] * (double)(this.CSIZE - 5 * this.BORDER));
                        this.parent.ellipse(ix, iy, 2.0f, 2.0f);
                        ++row;
                    }
                    row = 0;
                    while (row < RPVisualizer.isOutlier.size()) {
                        this.parent.fill(RPVisualizer.outlierColor.getRGB());
                        this.parent.stroke(RPVisualizer.outlierColor.getRGB());
                        ix = xloc + 2 * this.BORDER + (int)(this.data[RPVisualizer.isOutlier.get(row)][flipOrder[i]] * (double)(this.CSIZE - 5 * this.BORDER));
                        iy = yloc + this.CSIZE - 2 * this.BORDER - (int)(this.data[RPVisualizer.isOutlier.get(row)][flipOrder[j]] * (double)(this.CSIZE - 5 * this.BORDER));
                        this.parent.ellipse(ix, iy, 2.0f, 2.0f);
                        ++row;
                    }
                    row = 0;
                    while (row < RPVisualizer.isBrushed.size()) {
                        this.parent.fill(RPVisualizer.brushColor.getRGB());
                        this.parent.stroke(RPVisualizer.brushColor.getRGB());
                        ix = xloc + 2 * this.BORDER + (int)(this.data[RPVisualizer.isBrushed.get(row)][flipOrder[i]] * (double)(this.CSIZE - 5 * this.BORDER));
                        iy = yloc + this.CSIZE - 2 * this.BORDER - (int)(this.data[RPVisualizer.isBrushed.get(row)][flipOrder[j]] * (double)(this.CSIZE - 5 * this.BORDER));
                        this.parent.ellipse(ix, iy, 2.0f, 2.0f);
                        ++row;
                    }
                    ++j;
                }
                ++i;
            }
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.fill(Color.LIGHT_GRAY.getRGB());
            this.parent.text("Top " + this.nplots + " Variables", (float)this.xpos, (float)(this.ypos + this.size + 15));
        }
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.size, this.size);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 1;
            while (i <= this.NUM) {
                int yloc = this.ypos + (i - 1) * this.CSIZE + this.BORDER;
                int j = 0;
                while (j < i) {
                    int xloc = this.xpos + j * this.CSIZE + this.BORDER;
                    Rectangle rect = new Rectangle(xloc, yloc, this.CSIZE - 2 * this.BORDER, this.CSIZE - 2 * this.BORDER);
                    if (rect.contains(new Point(mX, mY))) {
                        flag = true;
                        this.selected = new int[]{i, j};
                        RPVisualizer.splomSelected = new int[]{this.vindices[i], this.vindices[j]};
                        System.out.println("Selected! ij: " + i + "," + j + " inds: " + this.vindices[i] + " " + this.vindices[j]);
                    }
                    ++j;
                }
                ++i;
            }
            if (!flag) {
                this.selected = null;
                RPVisualizer.splomSelected = null;
            }
        }
    }
}

