/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import gui.RadialPlot;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import model.Utils;
import processing.core.PApplet;

public class Scatterplot {
    private PApplet parent;
    private int SIZE;
    private int xloc;
    private int yloc;
    private double[][] data;
    private double[][] proj;
    private double[][] origProj;
    Rectangle[] labels;
    RadialPlot rp;
    int[] classLabels;
    int nClasses;
    boolean isDrag;
    boolean shiftPressed;
    Point start;
    Point end;

    public Scatterplot(int x, int y, int size, RadialPlot rp, PApplet p, int[] classLabels, int nClasses) {
        this.xloc = x;
        this.yloc = y;
        this.SIZE = size;
        this.parent = p;
        this.rp = rp;
        this.nClasses = nClasses;
        this.classLabels = classLabels;
    }

    public void draw(double[][] dataP, double[][] projP) {
        if (dataP != null && projP != null) {
            String lbl;
            int ypos;
            int xpos;
            int ypos2;
            int xpos2;
            this.origProj = projP;
            double[][] res = Utils.multiply(dataP, this.origProj);
            this.data = Utils.normalize(res);
            this.proj = Utils.normalize(projP);
            this.labels = new Rectangle[this.proj.length];
            this.parent.fill(Color.BLACK.getRGB());
            this.parent.rect(this.xloc, this.yloc, this.SIZE, this.SIZE);
            int transparency = 40;
            this.parent.noStroke();
            int i = 0;
            while (i < this.data.length) {
                float h;
                xpos2 = (int)(this.data[i][0] * (double)(this.SIZE - 8)) + this.xloc;
                ypos2 = this.SIZE - (int)(this.data[i][1] * (double)(this.SIZE - 8)) + this.yloc;
                if (this.nClasses > 0) {
                    h = 70.0f / (float)this.nClasses;
                    this.parent.fill(10.0f + h * (float)this.classLabels[i], 80.0f, 80.0f, transparency);
                } else {
                    h = 70.0f / (float)this.data.length;
                    this.parent.fill(10.0f + h * (float)i, 80.0f, 80.0f, transparency);
                }
                if (this.isDrag) {
                    if (this.isInBrushRegion(new Point(xpos2, ypos2))) {
                        RPVisualizer.isBrushed.add(new Integer(i));
                    } else if (!this.shiftPressed && RPVisualizer.isBrushed.size() > 0 && RPVisualizer.isBrushed.contains(new Integer(i))) {
                        RPVisualizer.isBrushed.remove(new Integer(i));
                    }
                }
                this.parent.ellipse(xpos2, ypos2, 3.0f, 3.0f);
                ++i;
            }
            i = 0;
            while (i < RPVisualizer.isOutlier.size()) {
                xpos2 = (int)(this.data[RPVisualizer.isOutlier.get(i)][0] * (double)(this.SIZE - 8)) + this.xloc;
                ypos2 = this.SIZE - (int)(this.data[RPVisualizer.isOutlier.get(i)][1] * (double)(this.SIZE - 8)) + this.yloc;
                this.parent.fill(Color.black.getRGB());
                this.parent.ellipse(xpos2, ypos2, 3.0f, 3.0f);
                this.parent.fill(RPVisualizer.outlierColor.getRGB(), (float)transparency);
                this.parent.ellipse(xpos2, ypos2, 4.0f, 4.0f);
                ++i;
            }
            i = 0;
            while (i < RPVisualizer.isBrushed.size()) {
                xpos2 = (int)(this.data[RPVisualizer.isBrushed.get(i)][0] * (double)(this.SIZE - 8)) + this.xloc;
                ypos2 = this.SIZE - (int)(this.data[RPVisualizer.isBrushed.get(i)][1] * (double)(this.SIZE - 8)) + this.yloc;
                this.parent.fill(Color.black.getRGB());
                this.parent.ellipse(xpos2, ypos2, 3.0f, 3.0f);
                this.parent.fill(RPVisualizer.brushColor.getRGB(), (float)transparency);
                this.parent.ellipse(xpos2, ypos2, 4.0f, 4.0f);
                ++i;
            }
            this.parent.fill(Color.LIGHT_GRAY.getRGB());
            Font font = new Font("Helvetica", 0, 8);
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
            this.parent.setFont(font);
            int xs = this.xloc + this.SIZE / 2;
            int ys = this.yloc + this.SIZE / 2;
            int PAD = -1;
            int i2 = 0;
            while (i2 < this.proj.length) {
                xpos = (int)(this.proj[i2][0] * (double)(this.SIZE - PAD)) + this.xloc;
                ypos = this.SIZE - (int)(this.proj[i2][1] * (double)(this.SIZE - PAD)) + this.yloc;
                lbl = "RP-" + i2;
                this.labels[i2] = new Rectangle(xpos, ypos - 12, (int)this.parent.textWidth(lbl), 12);
                int adv = (int)this.parent.textWidth(lbl);
                if (adv > PAD) {
                    PAD = adv;
                }
                ++i2;
            }
            this.mouseOver();
            i2 = 0;
            while (i2 < this.proj.length) {
                xpos = (int)(this.proj[i2][0] * (double)(this.SIZE - PAD)) + this.xloc;
                ypos = this.SIZE - (int)(this.proj[i2][1] * (double)(this.SIZE - PAD)) + this.yloc;
                this.parent.line(xs, ys, xpos, ypos);
                lbl = "RP-" + i2;
                if (RPVisualizer.selectedProjection >= 0 && RPVisualizer.selectedProjection == i2 || RPVisualizer.hoverProjection >= 0 && RPVisualizer.hoverProjection == i2) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                } else {
                    this.parent.fill(55.0f, 55.0f, 100.0f, 100.0f);
                }
                this.parent.text(lbl, (float)xpos, (float)ypos);
                ++i2;
            }
            this.parent.fill(Color.LIGHT_GRAY.getRGB());
            this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        }
    }

    public void mousePressed() {
        Rectangle r = new Rectangle(this.xloc, this.yloc, this.SIZE, this.SIZE);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            if (this.labels != null) {
                int i = 0;
                while (i < this.labels.length) {
                    if (this.labels[i] != null && this.labels[i].contains(new Point(mX, mY))) {
                        flag = true;
                        RPVisualizer.selectedProjection = i;
                    }
                    ++i;
                }
            }
            if (!flag) {
                RPVisualizer.selectedProjection = -1;
            }
            this.isDrag = true;
            this.start = new Point(mX, mY);
            this.end = null;
            if (this.parent.keyPressed && this.parent.key == '\uffff' && this.parent.keyCode == 16) {
                this.shiftPressed = true;
            } else {
                RPVisualizer.resetBrushed();
                this.shiftPressed = false;
            }
        }
    }

    public void mouseDragged() {
        if (this.isDrag) {
            this.end = new Point(this.parent.mouseX, this.parent.mouseY);
        }
    }

    public void mouseReleased() {
        this.isDrag = false;
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xloc, this.yloc, this.SIZE, this.SIZE);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            if (this.labels != null) {
                int i = 0;
                while (i < this.labels.length) {
                    if (this.labels[i] != null && this.labels[i].contains(new Point(mX, mY))) {
                        flag = true;
                        RPVisualizer.hoverProjection = i;
                    }
                    ++i;
                }
            }
            if (!flag) {
                RPVisualizer.hoverProjection = -1;
            }
        }
    }

    public boolean isInBrushRegion(Point pt) {
        if (this.start != null && this.end != null) {
            double totXDist = this.start.x - this.end.x;
            double totYDist = this.start.y - this.end.y;
            double xDist = this.start.x - pt.x;
            double yDist = this.start.y - pt.y;
            if ((totXDist < 0.0 && xDist < 0.0 && xDist >= totXDist || totXDist > 0.0 && xDist > 0.0 && xDist <= totXDist) && (totYDist < 0.0 && yDist < 0.0 && yDist >= totYDist || totYDist > 0.0 && yDist > 0.0 && yDist <= totYDist)) {
                return true;
            }
        }
        return false;
    }
}

