/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Edge;
import gui.Node;
import gui.Vector3D;
import processing.core.PApplet;

public class SpringEdge
extends Edge {
    float k = 0.1f;
    float a = 100.0f;

    public SpringEdge(Node a, Node b) {
        super(a, b);
    }

    public void setNaturalLength(float l) {
        this.a = l;
    }

    public float getNaturalLength() {
        return this.a;
    }

    public Vector3D getForceTo() {
        float dx = this.dX();
        float dy = this.dY();
        float l = (float)Math.sqrt(dx * dx + dy * dy);
        float f = this.k * (l - this.a);
        return new Vector3D(-f * dx / l, -f * dy / l, 0.0f);
    }

    public Vector3D getForceFrom() {
        float dx = this.dX();
        float dy = this.dY();
        float l = (float)Math.sqrt(dx * dx + dy * dy);
        float f = this.k * (l - this.a);
        return new Vector3D(f * dx / l, f * dy / l, 0.0f);
    }

    @Override
    public void draw(PApplet p) {
        float dx = this.dX();
        float dy = this.dY();
        Vector3D f = this.getForceFrom();
        p.stroke(255.0f, 255.0f, 255.0f, 64.0f);
        p.strokeWeight(100.0f / this.a);
        p.line(this.from.getX(), this.from.getY(), this.to.getX(), this.to.getY());
    }
}

