/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RPVisualizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import processing.core.PApplet;
import scores.ProjectionInfo;

public class VarList {
    PApplet parent;
    int width;
    int height;
    int xpos;
    int ypos;
    String[] allVars;
    Rectangle[] labels;
    int[] vindices;
    boolean[] used;
    float[][] graph;
    int[] ordering;

    public VarList(int x, int y, int width, int height, PApplet p, String[] variables) {
        this.xpos = x;
        this.ypos = y;
        this.width = width;
        this.height = height;
        this.parent = p;
        this.allVars = variables;
        this.graph = null;
        this.used = null;
        this.ordering = null;
    }

    public void setData(int[] ind, float[][] g, int[] sortOrder) {
        this.vindices = ind;
        this.graph = g;
        this.labels = new Rectangle[this.vindices.length];
        this.used = null;
        this.ordering = sortOrder;
    }

    public void draw() {
        this.parent.fill(RPVisualizer.plotBGColor.getRGB());
        this.parent.stroke(Color.LIGHT_GRAY.getRGB());
        this.parent.rect(this.xpos, this.ypos, this.width, this.height);
        this.parent.fill(Color.LIGHT_GRAY.getRGB());
        this.parent.text("Variable List", (float)this.xpos, (float)(this.ypos - 5));
        if (this.vindices != null) {
            this.parent.textSize(11.0f);
            int selectedIndex = this.getIndex(this.vindices, RPVisualizer.radialSelectedVarIndex);
            int i = 0;
            while (i < this.vindices.length) {
                this.parent.fill(RPVisualizer.textColor.getRGB());
                if (RPVisualizer.genVariables != null) {
                    int aa = 0;
                    while (aa < RPVisualizer.genVariables.size()) {
                        if (this.allVars[this.vindices[i]].equals(RPVisualizer.genVariables.get(aa))) {
                            this.parent.fill(RPVisualizer.matchColor.getRGB());
                        }
                        ++aa;
                    }
                }
                if (this.used != null && this.used[i]) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                }
                if (RPVisualizer.splomSelected != null) {
                    if (RPVisualizer.splomSelected[0] == this.vindices[i]) {
                        this.parent.fill(RPVisualizer.xSelectColor.getRGB());
                    }
                    if (RPVisualizer.splomSelected[1] == this.vindices[i]) {
                        this.parent.fill(RPVisualizer.ySelectColor.getRGB());
                    }
                }
                if (this.graph != null && RPVisualizer.radialSelectedVarIndex >= 0) {
                    int ti = -1;
                    int tmp = 0;
                    while (tmp < this.vindices.length) {
                        if (this.vindices[tmp] == RPVisualizer.radialSelectedVarIndex) {
                            ti = tmp;
                        }
                        ++tmp;
                    }
                    if (ti >= 0 && this.graph[ti][i] != 0.0f) {
                        this.parent.fill(RPVisualizer.textColor.getRGB());
                    }
                }
                if (this.graph != null && selectedIndex >= 0 && this.graph[selectedIndex][i] != 0.0f) {
                    this.parent.fill(Color.CYAN.getRGB());
                }
                if (RPVisualizer.radialSelectedVarIndex >= 0 && RPVisualizer.radialSelectedVarIndex == this.vindices[i] || RPVisualizer.hoverVariable == this.vindices[i]) {
                    this.parent.fill(RPVisualizer.textSelectColor.getRGB());
                }
                String text = "V" + this.vindices[i] + ": " + this.allVars[this.vindices[i]];
                int yloc = this.ypos + i * 12;
                if (this.ordering != null) {
                    yloc = this.ypos + this.ordering[i] * 12;
                }
                this.parent.text(text, (float)(this.xpos + 4), (float)(yloc + 12));
                this.labels[i] = new Rectangle(this.xpos + 2, yloc, (int)this.parent.textWidth(text) + 2, 14);
                ++i;
            }
        }
        this.mouseOver();
    }

    public int getIndex(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void setUsed(ProjectionInfo p) {
        this.used = new boolean[this.vindices.length];
        int i = 0;
        while (i < this.vindices.length) {
            if (this.isIn(p.getIndices(), this.vindices[i])) {
                this.used[i] = true;
            }
            ++i;
        }
    }

    public void resetUsed() {
        this.used = null;
    }

    private boolean isIn(int[] array, int elem) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (elem == array[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void mouseOver() {
        Rectangle r = new Rectangle(this.xpos, this.ypos, this.width, this.width);
        int mX = this.parent.mouseX;
        int mY = this.parent.mouseY;
        if (r.contains(new Point(mX, mY))) {
            boolean flag = false;
            int i = 0;
            while (i < this.labels.length) {
                if (this.labels[i] != null && this.labels[i].contains(new Point(mX, mY))) {
                    flag = true;
                    RPVisualizer.hoverVariable = this.vindices[i];
                }
                ++i;
            }
            if (!flag) {
                RPVisualizer.hoverVariable = -1;
            }
        }
    }
}

