/*
 * Decompiled with CFR 0.152.
 */
package gui;

public class Vector3D {
    private float x;
    private float y;
    private float z;

    public Vector3D(float x_, float y_, float z_) {
        this.x = x_;
        this.y = y_;
        this.z = z_;
    }

    public Vector3D(int x_, int y_, int z_) {
        this.x = x_;
        this.y = y_;
        this.z = z_;
    }

    public Vector3D() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x_) {
        this.x = x_;
    }

    public void setY(float y_) {
        this.y = y_;
    }

    public void setZ(float z_) {
        this.z = z_;
    }

    public void setXY(float x_, float y_) {
        this.x = x_;
        this.y = y_;
    }

    public void setXYZ(float x_, float y_, float z_) {
        this.x = x_;
        this.y = y_;
        this.z = z_;
    }

    public void setVector(Vector3D v) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
    }

    public Vector3D copy() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3D add(Vector3D v) {
        return new Vector3D(this.x + v.getX(), this.y + v.getY(), this.z + v.getZ());
    }

    public Vector3D subtract(Vector3D v) {
        return new Vector3D(this.x - v.getX(), this.y - v.getY(), this.z - v.getZ());
    }

    public Vector3D multiply(float n) {
        return new Vector3D(this.x * n, this.y * n, this.z * n);
    }

    public Vector3D divide(float n) {
        return new Vector3D(this.x / n, this.y / n, this.z / n);
    }

    public void normalize() {
        float m = this.magnitude();
        this.x /= m;
        this.y /= m;
        this.z /= m;
    }

    public void limit(float max) {
        if (this.magnitude() > max) {
            this.normalize();
            this.x *= max;
            this.y *= max;
            this.z *= max;
        }
    }

    public float heading2D() {
        float angle = (float)Math.atan2(this.y * -1.0f, this.x);
        return -1.0f * angle;
    }

    public static Vector3D add(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.getX() + v2.getX(), v1.getY() + v2.getY(), v1.getZ() + v2.getZ());
    }

    public static Vector3D subtract(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.getX() - v2.getX(), v1.getY() - v2.getY(), v1.getZ() - v2.getZ());
    }

    public static Vector3D divide(Vector3D v1, float n) {
        return new Vector3D(v1.getX() / n, v1.getY() / n, v1.getZ() / n);
    }

    public static Vector3D multiply(Vector3D v1, float n) {
        return new Vector3D(v1.getX() * n, v1.getY() * n, v1.getZ() * n);
    }

    public static float distance(Vector3D v1, Vector3D v2) {
        float dx = v1.getX() - v2.getX();
        float dy = v1.getY() - v2.getY();
        float dz = v1.getZ() - v2.getZ();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

