/*
 * Decompiled with CFR 0.152.
 */
package model;

public class Cluster {
    private int[] members;
    private int numClusters = 0;
    private int numIterations = 3;
    private int nVar;
    private int nRow;
    private double daviesBouldinIndex = -1.0;
    private double[][] ssq;
    public int selectedCluster = -1;

    public Cluster(int numClusters, int numIterations) {
        if (numIterations != 0) {
            this.numIterations = numIterations;
        }
        if (numClusters != 0) {
            this.numClusters = numClusters;
        }
    }

    public int[] compute(double[][] data) {
        this.nRow = data.length;
        this.nVar = data[0].length;
        boolean useStoppingRule = false;
        double[][] ssr = null;
        if (this.numClusters == 0) {
            useStoppingRule = true;
            this.numClusters = 25;
            ssr = new double[this.numClusters][this.nVar];
        }
        double[][] center = new double[this.numClusters][this.nVar];
        double[][] count = new double[this.numClusters][this.nVar];
        double[][] mean = new double[this.numClusters][this.nVar];
        double[][] min = new double[this.numClusters][this.nVar];
        double[][] max = new double[this.numClusters][this.nVar];
        this.ssq = new double[this.numClusters][this.nVar];
        int[] closestPoints = new int[this.numClusters];
        double[] closestDistances = new double[this.numClusters];
        this.members = new int[this.nRow];
        int[] mem = new int[this.nRow];
        int k = 0;
        while (k < this.numClusters) {
            int iter = 0;
            while (iter < this.numIterations) {
                boolean reassigned = false;
                int l = 0;
                while (l <= k) {
                    int j = 0;
                    while (j < this.nVar) {
                        if (iter == 0 || center[l][j] != mean[l][j]) {
                            this.reassign(k, data, center, count, mean, min, max, this.ssq, closestPoints, closestDistances);
                            reassigned = true;
                            break;
                        }
                        ++j;
                    }
                    if (reassigned) break;
                    ++l;
                }
                if (!reassigned || k == 0) break;
                ++iter;
            }
            if (useStoppingRule) {
                double ssq1 = 0.0;
                double ssq2 = 0.0;
                int j = 0;
                while (j < this.nVar) {
                    int l = 0;
                    while (l <= k) {
                        ssq1 += ssr[l][j];
                        ssq2 += this.ssq[l][j];
                        ssr[l][j] = this.ssq[l][j];
                        ++l;
                    }
                    ++j;
                }
                double pre = (ssq1 - ssq2) / ssq1;
                if (pre > 0.0 && pre < 0.1) {
                    this.numClusters = k;
                    this.reassign(k, data, center, count, mean, min, max, this.ssq, closestPoints, closestDistances);
                    System.arraycopy(mem, 0, this.members, 0, this.nRow);
                    break;
                }
                System.arraycopy(this.members, 0, mem, 0, this.nRow);
            }
            if (k < this.numClusters - 1) {
                int j;
                int kn = k + 1;
                double dmax = 0.0;
                int jm = 0;
                int km = 0;
                double cutpoint = 0.0;
                int l = 0;
                while (l <= k) {
                    j = 0;
                    while (j < this.nVar) {
                        double dm = max[l][j] - min[l][j];
                        if (dm > dmax) {
                            cutpoint = mean[l][j];
                            dmax = dm;
                            jm = j;
                            km = l;
                        }
                        ++j;
                    }
                    ++l;
                }
                int i = 0;
                while (i < this.nRow) {
                    if (this.members[i] == km && data[i][jm] > cutpoint) {
                        j = 0;
                        while (j < this.nVar) {
                            double[] dArray = count[km];
                            int n = j;
                            dArray[n] = dArray[n] - 1.0;
                            double[] dArray2 = count[kn];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + 1.0;
                            double[] dArray3 = mean[km];
                            int n3 = j;
                            dArray3[n3] = dArray3[n3] - (data[i][j] - mean[km][j]) / count[km][j];
                            double[] dArray4 = mean[kn];
                            int n4 = j;
                            dArray4[n4] = dArray4[n4] + (data[i][j] - mean[kn][j]) / count[kn][j];
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
        int[] exemplars = new int[this.numClusters];
        int k2 = 0;
        while (k2 < this.numClusters) {
            exemplars[k2] = closestPoints[k2];
            ++k2;
        }
        this.computeClusterQuality(mean, data, this.ssq);
        return exemplars;
    }

    private void reassign(int nCluster, double[][] data, double[][] center, double[][] count, double[][] mean, double[][] min, double[][] max, double[][] ssq, int[] closestPoints, double[] closestDistances) {
        int k = 0;
        while (k <= nCluster) {
            closestPoints[k] = -1;
            closestDistances[k] = Double.POSITIVE_INFINITY;
            int j = 0;
            while (j < this.nVar) {
                center[k][j] = mean[k][j];
                mean[k][j] = 0.0;
                count[k][j] = 0.0;
                ssq[k][j] = 0.0;
                min[k][j] = Double.POSITIVE_INFINITY;
                max[k][j] = Double.NEGATIVE_INFINITY;
                ++j;
            }
            ++k;
        }
        int i = 0;
        while (i < this.nRow) {
            double dmin = Double.POSITIVE_INFINITY;
            int kmin = -1;
            int k2 = 0;
            while (k2 <= nCluster) {
                double dd = this.distance(data[i], center[k2]);
                if (dd < dmin) {
                    dmin = dd;
                    kmin = k2;
                    if (dmin < closestDistances[k2]) {
                        closestDistances[k2] = dmin;
                        closestPoints[k2] = i;
                    }
                }
                ++k2;
            }
            this.members[i] = kmin < 0 ? -1 : kmin;
            int j = 0;
            while (j < this.nVar) {
                if (!Double.isNaN(data[i][j])) {
                    double[] dArray = count[kmin];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    double xn = count[kmin][j];
                    double xa = data[i][j];
                    double[] dArray2 = mean[kmin];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + (xa - mean[kmin][j]) / xn;
                    if (xn > 1.0) {
                        double[] dArray3 = ssq[kmin];
                        int n3 = j;
                        dArray3[n3] = dArray3[n3] + xn * (xa - mean[kmin][j]) * (xa - mean[kmin][j]) / (xn - 1.0);
                    }
                    if (min[kmin][j] > xa) {
                        min[kmin][j] = xa;
                    }
                    if (max[kmin][j] < xa) {
                        max[kmin][j] = xa;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private double distance(double[] a, double[] b) {
        double dist = 0.0;
        int i = 0;
        while (i < a.length) {
            dist += (a[i] - b[i]) * (a[i] - b[i]);
            ++i;
        }
        return dist;
    }

    private double addVectors(double[] a, double[] b) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i] + b[i];
            ++i;
        }
        return sum;
    }

    private void computeClusterQuality(double[][] mean, double[][] data, double[][] ssq) {
        double[] max = new double[this.numClusters];
        int i = 0;
        while (i < this.numClusters) {
            max[i] = Double.MIN_VALUE;
            int j = 0;
            while (j < this.numClusters) {
                double dij;
                if (i != j && (dij = this.addVectors(ssq[i], ssq[j]) / this.distance(mean[i], mean[j])) > max[i]) {
                    max[i] = dij;
                }
                ++j;
            }
            ++i;
        }
        this.daviesBouldinIndex = 0.0;
        i = 0;
        while (i < this.numClusters) {
            this.daviesBouldinIndex += max[i];
            ++i;
        }
        this.daviesBouldinIndex /= (double)this.numClusters;
    }

    public int[] getMembers() {
        return this.members;
    }

    public double getDaviesBouldinIndex() {
        return this.daviesBouldinIndex;
    }

    public int getNumberOfClusters() {
        return this.numClusters;
    }

    public double getSS(int cluster) {
        double res = 0.0;
        int i = 0;
        while (i < this.nVar) {
            res += this.ssq[cluster][i];
            ++i;
        }
        return res;
    }
}

