/*
 * Decompiled with CFR 0.152.
 */
package model;

public class Eigen {
    static double EPSILON = 1.0E-15;

    public static final void eigenSymmetric(double[][] a, double[][] eigenvectors, double[] eigenvalues) {
        double[] e = new double[eigenvalues.length];
        Eigen.tred2(a, eigenvectors, eigenvalues, e);
        Eigen.imtql2(eigenvectors, eigenvalues, e);
        Eigen.sort(eigenvalues, eigenvectors);
    }

    private static final void tred2(double[][] a, double[][] z, double[] d, double[] e) {
        double g;
        int k;
        int l;
        int j;
        int n = d.length;
        int i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                z[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
        if (n > 1) {
            i = n - 1;
            while (i > 0) {
                l = i - 1;
                double h = 0.0;
                double scale = 0.0;
                if (l > 0) {
                    k = 0;
                    while (k <= l) {
                        scale += Math.abs(z[i][k]);
                        ++k;
                    }
                }
                if (scale == 0.0) {
                    e[i] = z[i][l];
                } else {
                    k = 0;
                    while (k <= l) {
                        double[] dArray = z[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += z[i][k] * z[i][k];
                        ++k;
                    }
                    double f = z[i][l];
                    g = f < 0.0 ? Math.sqrt(h) : -Math.sqrt(h);
                    e[i] = scale * g;
                    h -= f * g;
                    z[i][l] = f - g;
                    f = 0.0;
                    j = 0;
                    while (j <= l) {
                        z[j][i] = z[i][j] / (scale * h);
                        g = 0.0;
                        k = 0;
                        while (k <= j) {
                            g += z[j][k] * z[i][k];
                            ++k;
                        }
                        int jp1 = j + 1;
                        if (l >= jp1) {
                            k = jp1;
                            while (k <= l) {
                                g += z[k][j] * z[i][k];
                                ++k;
                            }
                        }
                        e[j] = g / h;
                        f += e[j] * z[i][j];
                        ++j;
                    }
                    double hh = f / (h + h);
                    j = 0;
                    while (j <= l) {
                        f = z[i][j];
                        e[j] = g = e[j] - hh * f;
                        k = 0;
                        while (k <= j) {
                            z[j][k] = z[j][k] - f * e[k] - g * z[i][k];
                            ++k;
                        }
                        ++j;
                    }
                    k = 0;
                    while (k <= l) {
                        double[] dArray = z[i];
                        int n3 = k++;
                        dArray[n3] = dArray[n3] * scale;
                    }
                }
                d[i] = h;
                --i;
            }
        }
        d[0] = 0.0;
        e[0] = 0.0;
        i = 0;
        while (i < n) {
            l = i - 1;
            if (d[i] != 0.0) {
                j = 0;
                while (j <= l) {
                    g = 0.0;
                    k = 0;
                    while (k <= l) {
                        g += z[i][k] * z[k][j];
                        ++k;
                    }
                    k = 0;
                    while (k <= l) {
                        double[] dArray = z[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * z[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            d[i] = z[i][i];
            z[i][i] = 1.0;
            if (l >= 0) {
                j = 0;
                while (j <= l) {
                    z[i][j] = 0.0;
                    z[j][i] = 0.0;
                    ++j;
                }
            }
            ++i;
        }
    }

    private static final int imtql2(double[][] z, double[] d, double[] e) {
        int n = d.length;
        if (n == 1) {
            return 0;
        }
        int i = 1;
        while (i < n) {
            e[i - 1] = e[i];
            ++i;
        }
        e[n - 1] = 0.0;
        int mm = 0;
        int l = 0;
        while (l < n) {
            int lp1 = l + 1;
            int j = 0;
            while (true) {
                int m = l;
                while (m < n) {
                    mm = m;
                    if (m == n - 1 || Math.abs(e[m]) <= EPSILON * (Math.abs(d[m]) + Math.abs(d[m + 1]))) break;
                    ++m;
                }
                m = mm;
                double p = d[l];
                if (m == l) break;
                if (j == 30) {
                    return l;
                }
                ++j;
                double g = (d[lp1] - p) / (2.0 * e[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = d[m] - p + e[l] / (g + (g < 0.0 ? -r : r));
                double s = 1.0;
                double c = 1.0;
                p = 0.0;
                int mml = m - l;
                int ii = 1;
                while (ii <= mml) {
                    i = m - ii;
                    int ip1 = i + 1;
                    double f = s * e[i];
                    double b = c * e[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        e[ip1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        e[ip1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = d[ip1] - p;
                    r = (d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    d[ip1] = g + p;
                    g = c * r - b;
                    int k = 0;
                    while (k < n) {
                        f = z[k][ip1];
                        z[k][ip1] = s * z[k][i] + c * f;
                        z[k][i] = c * z[k][i] - s * f;
                        ++k;
                    }
                    ++ii;
                }
                int n2 = l;
                d[n2] = d[n2] - p;
                e[l] = g;
                e[m] = 0.0;
            }
            ++l;
        }
        return 0;
    }

    private static void sort(double[] d, double[][] z) {
        int n = d.length;
        int l = 1;
        while (l <= n) {
            l = 3 * l + 1;
        }
        while (l > 2) {
            int k = n - (l /= 3);
            int j = 0;
            while (j < k) {
                int i = j;
                while (i >= 0) {
                    int ip1 = i + l;
                    if (!(d[i] < d[ip1]) && !Double.isNaN(d[i])) break;
                    double p = d[i];
                    d[i] = d[ip1];
                    d[ip1] = p;
                    int ii = 0;
                    while (ii < n) {
                        p = z[ii][i];
                        z[ii][i] = z[ii][ip1];
                        z[ii][ip1] = p;
                        ++ii;
                    }
                    i -= l;
                }
                ++j;
            }
        }
    }
}

