/*
 * Decompiled with CFR 0.152.
 */
package model;

import gui.LetterValueBoxPlot;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import model.Utils;

public class Generator {
    int numRows;
    int numVars;
    double[][] data;
    double[] dataMin;
    double[] dataMax;
    String[] variableLabels;

    public void saveDataFiles() {
        int npts = 5000;
        int ndims = 500;
        int p = 50;
        String fname = null;
        this.data = null;
        fname = "striated" + npts + "-" + ndims + "-" + p + ".txt";
        this.generateStriated(npts, ndims, p, fname);
        this.writeToFile(fname);
    }

    public void writeToFile(String fname) {
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/" + fname));
            int j = 0;
            while (j < this.numVars - 1) {
                bwx.write(String.valueOf(this.variableLabels[j]) + ",");
                ++j;
            }
            bwx.write(String.valueOf(this.variableLabels[this.numVars - 1]) + "\n");
            int i = 0;
            while (i < this.numRows) {
                int j2 = 0;
                while (j2 < this.numVars - 1) {
                    bwx.write(String.valueOf(this.data[i][j2]) + ",");
                    ++j2;
                }
                bwx.write(String.valueOf(this.data[i][this.numVars - 1]) + "\n");
                ++i;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing Gen::data: " + ie);
            ie.printStackTrace();
        }
    }

    public void generateGaussian(int npts, int ndims) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("V" + j, j);
            ++j;
        }
        int i = 0;
        while (i < this.numRows) {
            int j2 = 0;
            while (j2 < this.numVars) {
                this.data[i][j2] = rand.nextGaussian();
                ++j2;
            }
            ++i;
        }
    }

    public void generateGaussianClusters(int npts, int ndims, int nclusters, String fname) {
        this.numRows = npts;
        this.numVars = ndims + 1;
        int DIV = 10;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < ndims) {
            this.setLabels("V" + j, j);
            ++j;
        }
        this.setLabels("CLASS", ndims);
        ArrayList<Integer> cvars = new ArrayList<Integer>();
        int c = 0;
        while (c < nclusters) {
            int v = rand.nextInt(ndims);
            if (cvars.contains(v)) continue;
            cvars.add(v);
            ++c;
        }
        double[][] centroids = new double[nclusters][this.numVars];
        int i = 0;
        while (i < nclusters) {
            centroids[i][((Integer)cvars.get((int)i)).intValue()] = 1.0;
            int j2 = 0;
            while (j2 < ndims) {
                if (j2 != (Integer)cvars.get(i)) {
                    centroids[i][j2] = cvars.contains(j2) ? 0.0 : rand.nextGaussian() / (double)(2 * DIV);
                }
                ++j2;
            }
            centroids[i][ndims] = i;
            this.data[i] = centroids[i];
            ++i;
        }
        i = nclusters;
        while (i < this.numRows) {
            c = rand.nextInt(nclusters);
            this.data[i] = this.createMemberOfCluster(centroids[c], rand, cvars, DIV);
            this.data[i][ndims] = c;
            ++i;
        }
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/V-" + fname));
            int i2 = 0;
            while (i2 < cvars.size()) {
                bwx.write("V" + cvars.get(i2) + "\n");
                ++i2;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }

    private double[] createMemberOfCluster(double[] centroid, Random rand, List<Integer> cvars, int DIV) {
        double[] res = new double[centroid.length];
        int i = 0;
        while (i < centroid.length - 1) {
            res[i] = cvars.contains(i) ? centroid[i] + rand.nextGaussian() / (double)DIV : rand.nextGaussian() / (double)(2 * DIV);
            ++i;
        }
        return res;
    }

    public void generateUniform(int npts, int ndims) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("V" + j, j);
            ++j;
        }
        int i = 0;
        while (i < this.numRows) {
            int j2 = 0;
            while (j2 < this.numVars) {
                this.data[i][j2] = rand.nextDouble();
                ++j2;
            }
            ++i;
        }
    }

    public void addNoiseToRandu(String fname, int npts, int ndims, int p) {
        try {
            int i;
            int numNoise = ndims - p;
            this.numVars = ndims;
            this.numRows = npts;
            int DIV = 20;
            this.data = new double[this.numRows][this.numVars];
            this.variableLabels = new String[this.numVars];
            Random rand = new Random();
            BufferedReader br = new BufferedReader(new FileReader("../Linf/generatedData/" + fname));
            String line = br.readLine();
            String[] vals = line.split("\n");
            String[] str = vals[0].trim().split(",");
            int c = 0;
            try {
                BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/V-randu-noise" + npts + "-" + ndims + "-" + p + ".txt"));
                i = 0;
                while (i < str.length) {
                    this.setLabels(str[i], c);
                    bwx.write(String.valueOf(str[i]) + "\n");
                    ++i;
                    ++c;
                }
                bwx.close();
            }
            catch (IOException ie) {
                System.out.println("Generator:: Error writing variables: " + ie);
                ie.printStackTrace();
            }
            int i2 = 0;
            while (i2 < numNoise) {
                this.setLabels(" NOISE" + i2, c);
                ++i2;
                ++c;
            }
            line = br.readLine();
            int row = 0;
            while (line != null) {
                vals = line.split("\n");
                str = vals[0].trim().split(",");
                c = 0;
                i = 0;
                while (i < str.length) {
                    this.data[row][c] = Double.parseDouble(str[i]);
                    ++i;
                    ++c;
                }
                i = 0;
                while (i < numNoise) {
                    this.data[row][c] = rand.nextGaussian() / (double)DIV;
                    ++i;
                    ++c;
                }
                line = br.readLine();
                ++row;
            }
            br.close();
        }
        catch (IOException ie) {
            System.out.println("Error reading from randu data: " + ie);
            ie.printStackTrace();
        }
    }

    private void initializeMinMax() {
        this.dataMin = new double[this.numVars];
        this.dataMax = new double[this.numVars];
        int i = 0;
        while (i < this.numVars) {
            this.dataMin[i] = Double.MAX_VALUE;
            this.dataMax[i] = -this.dataMin[i];
            ++i;
        }
    }

    private void updateMinMax(double d, int i) {
        if (d < this.dataMin[i]) {
            this.dataMin[i] = d;
        }
        if (d > this.dataMax[i]) {
            this.dataMax[i] = d;
        }
    }

    private void normalizeData() {
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numVars) {
                this.data[i][j] = (this.data[i][j] - this.dataMin[j]) / (this.dataMax[j] - this.dataMin[j]);
                ++j;
            }
            ++i;
        }
    }

    private void setLabels(String s, int loc) {
        this.variableLabels[loc] = s;
    }

    public static double cauchy(double mu, double sigma) {
        double x = sigma * Math.tan(Math.PI * (Math.random() - 0.5)) + mu;
        return x;
    }

    private void generateOutlying(int npts, int ndims, String fname) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("O" + j, j);
            ++j;
        }
        double[] distances = new double[this.numRows];
        int i = 0;
        while (i < this.numRows) {
            int j2 = 0;
            while (j2 < this.numVars) {
                this.data[i][j2] = Generator.cauchy(0.0, 1.0);
                ++j2;
            }
            distances[i] = Utils.vectorLength(this.data[i]);
            ++i;
        }
        LetterValueBoxPlot lvb = new LetterValueBoxPlot(distances, true);
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/Outliers-" + fname));
            int i2 = 0;
            while (i2 < this.numRows) {
                if (distances[i2] >= lvb.geUpperThreshold()) {
                    bwx.write(String.valueOf(i2) + "\n");
                }
                ++i2;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }

    private void generateSparse(int npts, int ndims, int p, String fname) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("P" + j, j);
            ++j;
        }
        int lpts = 10;
        ArrayList<Integer> cvars = new ArrayList<Integer>();
        int c = 0;
        while (c < p) {
            int v = rand.nextInt(ndims);
            if (cvars.contains(v)) continue;
            cvars.add(v);
            ++c;
        }
        int DIV = 10;
        int i = 0;
        while (i < this.numRows) {
            int j2 = 0;
            while (j2 < this.numVars) {
                this.data[i][j2] = cvars.contains(j2) ? Math.floor((double)lpts * rand.nextDouble()) : rand.nextGaussian() / (double)DIV;
                ++j2;
            }
            ++i;
        }
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/V-" + fname));
            int i2 = 0;
            while (i2 < cvars.size()) {
                bwx.write("P" + cvars.get(i2) + "\n");
                ++i2;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }

    private void generateStriated(int npts, int ndims, int p, String fname) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("S" + j, j);
            ++j;
        }
        int lpts = 5;
        int nz = p / 2;
        if (p % 2 != 0) {
            ++nz;
        }
        ArrayList allvars = new ArrayList();
        ArrayList<Integer> zvars = new ArrayList<Integer>();
        ArrayList<Integer> uvars = new ArrayList<Integer>();
        int c = 0;
        while (c < p) {
            int v = rand.nextInt(ndims);
            if (!allvars.contains(v)) {
                if (c < nz) {
                    zvars.add(v);
                } else {
                    uvars.add(v);
                }
            }
            ++c;
        }
        int DIV = 15;
        int i = 0;
        while (i < this.numRows) {
            int j2 = 0;
            while (j2 < this.numVars) {
                this.data[i][j2] = zvars.contains(j2) ? Math.floor((double)lpts * rand.nextDouble()) : (uvars.contains(j2) ? rand.nextDouble() : rand.nextGaussian() / (double)DIV);
                ++j2;
            }
            ++i;
        }
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/V-" + fname));
            int i2 = 0;
            while (i2 < zvars.size()) {
                bwx.write("S" + zvars.get(i2) + "\n");
                ++i2;
            }
            i2 = 0;
            while (i2 < uvars.size()) {
                bwx.write("S" + uvars.get(i2) + "\n");
                ++i2;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }

    private void generateStringy(int npts, int ndims, int p, String fname) {
        this.numRows = npts;
        this.numVars = ndims;
        Random rand = new Random();
        this.data = new double[this.numRows][this.numVars];
        this.variableLabels = new String[this.numVars];
        int j = 0;
        while (j < this.numVars) {
            this.setLabels("F" + j, j);
            ++j;
        }
        ArrayList<Integer> cvars = new ArrayList<Integer>();
        int c = 0;
        while (c < p) {
            int v = rand.nextInt(ndims);
            if (cvars.contains(v)) continue;
            cvars.add(v);
            ++c;
        }
        int DIV = 10;
        double[] prev = new double[this.numVars];
        int j2 = 0;
        while (j2 < this.numVars) {
            prev[j2] = rand.nextGaussian();
            this.data[0][j2] = prev[j2] / (double)DIV;
            ++j2;
        }
        int i = 1;
        while (i < this.numRows) {
            int j3 = 0;
            while (j3 < this.numVars) {
                if (cvars.contains(j3)) {
                    this.data[i][j3] = prev[j3] + rand.nextGaussian() / (double)(2 * DIV);
                    prev[j3] = this.data[i][j3];
                } else {
                    this.data[i][j3] = rand.nextGaussian() / (double)DIV;
                }
                ++j3;
            }
            ++i;
        }
        try {
            BufferedWriter bwx = new BufferedWriter(new FileWriter("generatedData/V-" + fname));
            int i2 = 0;
            while (i2 < cvars.size()) {
                bwx.write("F" + cvars.get(i2) + "\n");
                ++i2;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Generator:: Error writing variables: " + ie);
            ie.printStackTrace();
        }
    }
}

