/*
 * Decompiled with CFR 0.152.
 */
package model;

import gui.RadialPlot;
import gui.Scatterplot;
import java.util.Random;
import model.Utils;
import processing.core.PApplet;
import scores.MSTMeasures;
import scores.ProjectionInfo;

public class ProjectionPursuit {
    Random random = new Random();
    int numIterations;
    Scatterplot sp;
    double[][] data;
    int nvars;
    int ndims;
    PApplet p;
    ProjectionInfo[] pinfo;
    double[][] projectedData;
    double[][] projectionMatrix;

    public ProjectionPursuit(PApplet p, ProjectionInfo[] pinfo, int x, int y, int size, RadialPlot rp, int[] classValues, int nclasses) {
        this.p = p;
        this.numIterations = 20;
        this.ndims = 2;
        this.sp = new Scatterplot(x, y, size, rp, p, classValues, nclasses);
    }

    public void draw() {
        if (this.sp != null) {
            this.sp.draw(this.projectedData, this.projectionMatrix);
        }
    }

    public void mousePressed() {
        if (this.sp != null) {
            this.sp.mousePressed();
        }
    }

    public void mouseDragged() {
        if (this.sp != null) {
            this.sp.mouseDragged();
        }
    }

    public void mouseReleased() {
        if (this.sp != null) {
            this.sp.mouseReleased();
        }
    }

    public double[][] compute(double[][] d, int scagIndex) {
        this.nvars = d[0].length;
        this.data = Utils.standardizeData(d);
        this.projectedData = this.data;
        double[][] R = new double[this.nvars][this.ndims];
        this.projectionMatrix = new double[this.nvars][this.ndims];
        int i = 0;
        while (i < this.nvars) {
            R[i][0] = this.random.nextGaussian();
            R[i][1] = this.random.nextGaussian();
            ++i;
        }
        this.getBestRandomProjection(R, scagIndex);
        return R;
    }

    private void getBestRandomProjection(double[][] R, int scagIndex) {
        double temperature = 1.0;
        int neighborhood = 10;
        double[] best = new double[this.numIterations];
        try {
            int iter = 0;
            while (iter < this.numIterations) {
                int attemptMove = 0;
                while (attemptMove < neighborhood) {
                    double postGain;
                    double[][] Aa = Utils.multiply(this.data, R);
                    double preGain = this.computeIndex(Aa, scagIndex);
                    System.arraycopy(R, 0, this.projectionMatrix, 0, R.length);
                    int ranLoc = this.random.nextInt(this.nvars);
                    double moveSize = 0.3;
                    double[] oldValue = this.move(R, ranLoc, moveSize);
                    double[][] Ai = Utils.multiply(this.data, R);
                    best[iter] = postGain = this.computeIndex(Ai, scagIndex);
                    double de = (preGain - postGain) / postGain;
                    if (!this.acceptMove(de, temperature)) {
                        this.reset(R, ranLoc, oldValue);
                        best[iter] = preGain;
                    }
                    ++attemptMove;
                }
                System.out.println("****** ITER: " + iter + " postmove: " + best[iter]);
                temperature *= 0.65;
                if (!this.notChanged(best, 3, iter)) {
                    ++iter;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("PP: ERROR: " + e);
            e.printStackTrace();
        }
    }

    private boolean acceptMove(double delta, double t) {
        double rnum = this.random.nextDouble();
        double THRES = Math.exp(-(0.69 + delta / t));
        if (delta < 0.0) {
            return true;
        }
        if (delta == 0.0) {
            return false;
        }
        return rnum < THRES;
    }

    private boolean notChanged(double[] array, int number, int lastIndex) {
        double DELTA = 0.001;
        double prev = array[lastIndex];
        int count = 0;
        int i = lastIndex - 1;
        while (i >= 0) {
            if (Math.abs(prev - array[i]) <= DELTA) {
                ++count;
            }
            if (lastIndex - i >= number) {
                return count >= number;
            }
            --i;
        }
        return false;
    }

    private double[] move(double[][] res, int ranLoc, double delta) {
        double dice = this.random.nextDouble();
        double[] old = new double[]{res[ranLoc][0], res[ranLoc][1]};
        if (dice > 0.5) {
            double[] dArray = res[ranLoc];
            dArray[0] = dArray[0] + delta;
            double[] dArray2 = res[ranLoc];
            dArray2[1] = dArray2[1] + delta;
        } else {
            double[] dArray = res[ranLoc];
            dArray[0] = dArray[0] - delta;
            double[] dArray3 = res[ranLoc];
            dArray3[1] = dArray3[1] - delta;
        }
        return old;
    }

    private void reset(double[][] res, int ranLoc, double[] old) {
        res[ranLoc][0] = old[0];
        res[ranLoc][1] = old[1];
    }

    private double computeIndex(double[][] projData, int scagIndex) {
        MSTMeasures m = new MSTMeasures();
        double score = -1.0;
        if (scagIndex == 1) {
            score = m.computeClumpyMeasure(projData);
        } else if (scagIndex == 0) {
            score = m.computeOutlierMeasure(projData);
        } else if (scagIndex == 2) {
            score = m.computeStriationMeasure(projData);
        } else if (scagIndex == 4) {
            score = m.computeStringyMeasure(projData);
        } else if (scagIndex == 3) {
            score = m.computeSparsenessMeasure(projData);
        }
        return score;
    }
}

