/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.DataReader;
import data.DataSource;
import gui.RPVisualizer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import model.Sorter;
import model.UnionMeasurer;
import scores.MSTMeasures;
import scores.Projection;
import scores.ProjectionInfo;
import scores.ScagnosticScorer;

public class RPLister {
    public DataSource inputData;
    private Projection projection;
    private ScagnosticScorer scorer;
    private int nPts;
    private int nVars;
    private int numSearchSpace;
    private int numNeeded;
    private int numProjs;
    private int scoreType;
    private ProjectionInfo[] projections;
    private double[][] listScagnosticScores;
    private ArrayList<Integer>[] outlierList;
    double[] kRPscores;
    double[] kRVscores;
    ProjectionInfo[][] kRPlist;
    int[][] kRVlist;

    public RPLister(String dataFileName, int hasClass, int hasRowNames) {
        boolean wclass = hasClass > 0;
        boolean wrownames = hasRowNames > 0;
        DataReader reader = new DataReader(dataFileName, wclass, wrownames);
        this.inputData = reader.readFile();
        this.inputData.normalizeData();
        this.nPts = this.inputData.nPts;
        this.nVars = this.inputData.nVars;
    }

    public void process(Random random, int scoreTypeP, int numProjs) {
        this.scoreType = scoreTypeP;
        this.numProjs = numProjs;
        this.numNeeded = 10;
        this.numSearchSpace = 5 * this.numNeeded;
        this.projection = new Projection(random);
        this.scorer = new ScagnosticScorer();
        this.scorer.setTypeSelection(this.scoreType);
        this.getGoodkDRandomProjections();
    }

    private void getGoodkDRandomProjections() {
        long gtime = 0L;
        long stime = 0L;
        ProjectionInfo[][] mps = new ProjectionInfo[this.numSearchSpace][];
        double[] scores = new double[this.numSearchSpace];
        double[][] ls = new double[this.numSearchSpace][RPVisualizer.scoreNames.length];
        ArrayList[] ol = new ArrayList[this.numSearchSpace];
        int i = 0;
        while (i < this.numSearchSpace) {
            long t1 = System.currentTimeMillis();
            mps[i] = this.projection.randomkDProjection(this.inputData.data, this.inputData.nVars, this.numProjs, this.scorer);
            double[][] xx = Projection.getDataForProjections(this.inputData.data, mps[i]);
            long t2 = System.currentTimeMillis();
            gtime += t2 - t1;
            System.out.println("Computing score for RP#: " + i);
            MSTMeasures m = new MSTMeasures();
            ls[i][1] = m.computeClumpyMeasure(xx);
            ls[i][0] = m.computeOutlierMeasure(xx);
            ls[i][2] = m.computeStriationMeasure(xx);
            ls[i][4] = m.computeStringyMeasure(xx);
            ls[i][3] = m.computeSparsenessMeasure(xx);
            scores[i] = ls[i][this.scoreType];
            ol[i] = m.getOutliers();
            stime += System.currentTimeMillis() - t2;
            ++i;
        }
        System.out.println("RPLister:: TIME TO GEN RPs: " + (double)gtime / 1000.0 + " secs.");
        System.out.println("RPLister:: TIME TO SCORE: " + (double)stime / 1000.0 + " secs.");
        int[] scoreIndices = Sorter.descendingSort(scores);
        this.kRPlist = new ProjectionInfo[this.numNeeded][];
        this.kRPscores = new double[this.numNeeded];
        this.listScagnosticScores = new double[this.numNeeded][RPVisualizer.scoreNames.length];
        this.outlierList = new ArrayList[this.numNeeded];
        int i2 = 0;
        while (i2 < this.numNeeded) {
            this.kRPscores[i2] = scores[scoreIndices[i2]];
            this.kRPlist[i2] = mps[scoreIndices[i2]];
            this.listScagnosticScores[i2] = ls[scoreIndices[i2]];
            this.outlierList[i2] = ol[scoreIndices[i2]];
            ++i2;
        }
        System.out.println("MAX SCORING RP: " + scoreIndices[0] + " score: " + this.kRPscores[0]);
    }

    public void getGoodRandomVariables() {
        int[][] mps = new int[this.numSearchSpace][];
        double[] scores = new double[this.numSearchSpace];
        double[][] ls = new double[this.numSearchSpace][RPVisualizer.scoreNames.length];
        int i = 0;
        while (i < this.numSearchSpace) {
            int nWts = this.nVars;
            if (this.nVars > 20) {
                nWts = Math.max(this.numProjs, (int)Math.sqrt(this.nVars));
            }
            mps[i] = this.projection.selectRandomVariables(this.nVars, nWts, null);
            double[][] xx = RPVisualizer.getDataForVariables(this.inputData.data, mps[i]);
            MSTMeasures m = new MSTMeasures();
            ls[i][1] = m.computeClumpyMeasure(xx);
            ls[i][0] = m.computeOutlierMeasure(xx);
            ls[i][2] = m.computeStriationMeasure(xx);
            ls[i][4] = m.computeStringyMeasure(xx);
            ls[i][3] = m.computeSparsenessMeasure(xx);
            scores[i] = ls[i][this.scoreType];
            ++i;
        }
        int[] scoreIndices = Sorter.descendingSort(scores);
        this.kRVlist = new int[this.numNeeded][];
        this.kRVscores = new double[this.numNeeded];
        this.listScagnosticScores = new double[this.numNeeded][RPVisualizer.scoreNames.length];
        int i2 = 0;
        while (i2 < this.numNeeded) {
            this.kRVscores[i2] = scores[scoreIndices[i2]];
            this.kRVlist[i2] = mps[scoreIndices[i2]];
            this.listScagnosticScores[i2] = ls[scoreIndices[i2]];
            ++i2;
        }
        System.out.println("MAX SCORING RANDOM VARS: " + scoreIndices[0] + " score: " + this.kRVscores[0]);
    }

    public double[] getRPListScores() {
        return this.kRPscores;
    }

    public double[] getRVListScores() {
        return this.kRVscores;
    }

    public ProjectionInfo[][] getRPlist() {
        return this.kRPlist;
    }

    public int[][] getRVlist() {
        return this.kRVlist;
    }

    public double[] getListScagnosticScores(int index) {
        return this.listScagnosticScores[index];
    }

    public ArrayList<Integer> getOutlierList(int index) {
        return this.outlierList[index];
    }

    private void getGood1DRandomProjections() {
        ProjectionInfo[] mps = new ProjectionInfo[this.numSearchSpace];
        int i = 0;
        while (i < this.numSearchSpace) {
            mps[i] = this.projection.random1DProjection(this.inputData.data, this.inputData.nVars, this.scorer);
            ++i;
        }
        ProjectionInfo[] sorted = this.scorer.sortProjections(mps);
        this.projections = new ProjectionInfo[this.numNeeded];
        int i2 = 0;
        while (i2 < this.numNeeded) {
            this.projections[i2] = sorted[i2];
            this.projections[i2].print();
            ++i2;
        }
    }

    private void getTruekDRandomProjections() {
        this.projections = this.projection.randomkDProjection(this.inputData.data, this.inputData.nVars, this.numNeeded, this.scorer);
    }

    private void getTrue1DRandomProjections() {
        this.projections = new ProjectionInfo[this.numNeeded];
        int i = 0;
        while (i < this.numNeeded) {
            this.projections[i] = this.projection.random1DProjection(this.inputData.data, this.inputData.nVars, this.scorer);
            this.projections[i].print();
            ++i;
        }
    }

    public ProjectionInfo[] getProjections() {
        return this.projections;
    }

    public double getAverageScoreOfTopKRPs(int k) {
        if (k > this.projections.length) {
            System.out.println("RPLISTER::ERROR -- top k < list of plots!");
            return -1.0;
        }
        double avg = 0.0;
        int i = 0;
        while (i < k) {
            avg += this.projections[i].getScore();
            ++i;
        }
        return avg /= (double)k;
    }

    public void printAvgInfoToFile(String dataFileName, String opFileName) {
        int k = this.projections.length;
        System.out.println("***** k = " + k + "*****");
        double avg = this.getAverageScoreOfTopKRPs(k);
        System.out.println("AVERAGE SCORE of " + k + " RPs: " + avg);
        try {
            File f = new File(opFileName);
            boolean writeHeader = false;
            if (!f.exists()) {
                writeHeader = true;
            }
            BufferedWriter bwx = new BufferedWriter(new FileWriter(opFileName, true));
            if (writeHeader) {
                bwx.write("DataFile,ScoreType,NumberOfRPs,AvgScoreRPs,NumberOfApproxPairs,AvgScoreAPairs,NumberOfRandomPairs,AvgScoreRPairs,NumberOfAllPairs,AvgOfKPairs\n");
            }
            bwx.write(String.valueOf(dataFileName) + "," + this.scoreType + "," + k + "," + avg + ",");
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing projection data: " + ie);
        }
    }

    private void writeProjectionData(ProjectionInfo proj, String fname) {
        try {
            File f = new File(String.valueOf(fname) + "projData.txt");
            boolean writeHeader = false;
            if (!f.exists()) {
                writeHeader = true;
            }
            BufferedWriter bwx = new BufferedWriter(new FileWriter(String.valueOf(fname) + "projData.txt"));
            if (writeHeader) {
                int i = 0;
                while (i < this.nVars - 1) {
                    bwx.write(String.valueOf(this.inputData.columnLabels[i]) + "\t");
                    ++i;
                }
                bwx.write(String.valueOf(this.inputData.columnLabels[this.nVars - 1]) + "\n");
            }
            int j = 0;
            while (j < this.nPts) {
                int i = 0;
                while (i < this.nVars - 1) {
                    int wi = proj.getVariableInProjection(i);
                    if (wi >= 0) {
                        bwx.write(String.valueOf(this.inputData.data[i][j] * proj.getWeights()[wi]) + "\t");
                    } else {
                        bwx.write(String.valueOf(this.inputData.data[i][j]) + "\t");
                    }
                    ++i;
                }
                int wi = proj.getVariableInProjection(this.nVars - 1);
                if (wi >= 0) {
                    bwx.write(String.valueOf(this.inputData.data[this.nVars - 1][j] * proj.getWeights()[wi]) + "\n");
                } else {
                    bwx.write(String.valueOf(this.inputData.data[this.nVars - 1][j]) + "\n");
                }
                ++j;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing projection data: " + ie);
        }
    }

    private void writeProjection(ProjectionInfo proj, String fname) {
        try {
            int i;
            File f = new File(String.valueOf(fname) + "proj.txt");
            boolean writeHeader = false;
            if (!f.exists()) {
                writeHeader = true;
            }
            BufferedWriter bwx = new BufferedWriter(new FileWriter(String.valueOf(fname) + "proj.txt", true));
            if (writeHeader) {
                i = 0;
                while (i < this.nVars - 1) {
                    bwx.write(String.valueOf(this.inputData.columnLabels[i]) + "\t");
                    ++i;
                }
                bwx.write(String.valueOf(this.inputData.columnLabels[this.nVars - 1]) + "\n");
            }
            i = 0;
            while (i < this.nVars - 1) {
                int wi = proj.getVariableInProjection(i);
                if (wi >= 0) {
                    bwx.write(String.valueOf(proj.getWeights()[wi]) + "\t");
                } else {
                    bwx.write("0\t");
                }
                ++i;
            }
            int wi = proj.getVariableInProjection(this.nVars - 1);
            if (wi >= 0) {
                bwx.write(String.valueOf(proj.getWeights()[wi]) + "\n");
            } else {
                bwx.write("0\n");
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing projection weights: " + ie);
        }
    }

    private double[] writeUnionOfProjections(ProjectionInfo[] projs, String fname) {
        try {
            File f = new File(String.valueOf(fname) + "unionProj.txt");
            boolean writeHeader = false;
            if (!f.exists()) {
                writeHeader = true;
            }
            BufferedWriter bwx = new BufferedWriter(new FileWriter(String.valueOf(fname) + "unionProj.txt", true));
            if (writeHeader) {
                int i = 0;
                while (i < this.nVars - 1) {
                    bwx.write(String.valueOf(this.inputData.columnLabels[i]) + "\t");
                    ++i;
                }
                bwx.write(String.valueOf(this.inputData.columnLabels[this.nVars - 1]) + "\n");
            }
            double[] weights = new double[this.nVars];
            int[] inds = new int[this.nVars];
            int j = 0;
            while (j < this.nVars) {
                inds[j] = j;
                int wi = projs[0].getVariableInProjection(j);
                if (wi >= 0) {
                    weights[j] = projs[0].getWeights()[wi];
                }
                ++j;
            }
            int i = 1;
            while (i < projs.length) {
                ProjectionInfo pi = new ProjectionInfo(inds, weights);
                weights = UnionMeasurer.sumUnion(pi, projs[i], this.nVars);
                ++i;
            }
            i = 0;
            while (i < weights.length - 1) {
                bwx.write(String.valueOf(weights[i]) + "\t");
                ++i;
            }
            bwx.write(String.valueOf(weights[weights.length - 1]) + "\n");
            bwx.close();
            return weights;
        }
        catch (IOException ie) {
            System.out.println("Error writing union projection weights: " + ie);
            return null;
        }
    }

    private void writeUnionProjectionData(ProjectionInfo[] projs, String fname) {
        try {
            File f = new File(String.valueOf(fname) + ".txt");
            boolean writeHeader = false;
            if (!f.exists()) {
                writeHeader = true;
            }
            BufferedWriter bwx = new BufferedWriter(new FileWriter(String.valueOf(fname) + ".txt"));
            if (writeHeader) {
                int i = 0;
                while (i < this.nVars - 1) {
                    bwx.write(String.valueOf(this.inputData.columnLabels[i]) + "\t");
                    ++i;
                }
                bwx.write(String.valueOf(this.inputData.columnLabels[this.nVars - 1]) + "\n");
            }
            double[] weights = new double[this.nVars];
            int[] inds = new int[this.nVars];
            int j = 0;
            while (j < this.nVars) {
                inds[j] = j;
                int wi = projs[0].getVariableInProjection(j);
                if (wi >= 0) {
                    weights[j] = projs[0].getWeights()[wi];
                }
                ++j;
            }
            int i = 1;
            while (i < projs.length) {
                ProjectionInfo pi = new ProjectionInfo(inds, weights);
                weights = UnionMeasurer.sumUnion(pi, projs[i], this.nVars);
                ++i;
            }
            j = 0;
            while (j < this.nPts) {
                int i2 = 0;
                while (i2 < weights.length - 1) {
                    bwx.write(String.valueOf(this.inputData.data[i2][j] * weights[i2]) + "\t");
                    ++i2;
                }
                ++j;
            }
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing union projection data: " + ie);
        }
    }
}

