/*
 * Decompiled with CFR 0.152.
 */
package model;

public class SimilarityMeasurer {
    public static double computeCosineSimilarity(double[] a, double[] b) {
        double similarity = 0.0;
        double alen = 0.0;
        double blen = 0.0;
        if (a.length != b.length) {
            return Double.MIN_VALUE;
        }
        int i = 0;
        while (i < a.length) {
            if (!Double.isNaN(a[i]) && !Double.isNaN(b[i])) {
                alen += a[i] * a[i];
                similarity += a[i] * b[i];
                blen += b[i] * b[i];
            }
            ++i;
        }
        return similarity /= Math.sqrt(alen) * Math.sqrt(blen);
    }

    public static double computeCosineSimilarity(int[] a, int[] b) {
        double similarity = 0.0;
        double alen = 0.0;
        double blen = 0.0;
        if (a.length != b.length) {
            return Double.MIN_VALUE;
        }
        int i = 0;
        while (i < a.length) {
            alen += (double)(a[i] * a[i]);
            similarity += (double)(a[i] * b[i]);
            blen += (double)(b[i] * b[i]);
            ++i;
        }
        return similarity /= Math.sqrt(alen) * Math.sqrt(blen);
    }

    public static double computePearsonCorrelation(double[] a, double[] b) {
        double correlation = 0.0;
        double sumx = 0.0;
        double sumxx = 0.0;
        double sumy = 0.0;
        double sumyy = 0.0;
        double sumxy = 0.0;
        if (a.length != b.length) {
            return Double.MIN_VALUE;
        }
        int i = 0;
        while (i < a.length) {
            if (!Double.isNaN(a[i]) && !Double.isNaN(b[i])) {
                sumxy += a[i] * b[i];
                sumx += a[i];
                sumxx += a[i] * a[i];
                sumy += b[i];
                sumyy += b[i] * b[i];
            }
            ++i;
        }
        correlation = ((double)a.length * sumxy - sumx * sumy) / (Math.sqrt((double)a.length * sumxx - sumx * sumx) * Math.sqrt((double)b.length * sumyy - sumy * sumy));
        return correlation;
    }
}

