/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.Arrays;
import java.util.Comparator;

public class Sorter {
    private Sorter() {
    }

    public static int[] ascendingSort(double[] x) {
        Integer[] sortOrder = Sorter.sort(x);
        int[] result = new int[x.length];
        int i = 0;
        while (i < result.length) {
            result[i] = sortOrder[i];
            ++i;
        }
        return result;
    }

    public static int[] descendingSort(double[] x) {
        Integer[] sortOrder = Sorter.sort(x);
        int[] result = new int[x.length];
        int i = 0;
        while (i < result.length) {
            result[i] = sortOrder[result.length - i - 1];
            ++i;
        }
        return result;
    }

    public static final void doubleArraySort(double[] x, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            fromIndex = 0;
            toIndex = x.length;
        }
        Arrays.sort(x, fromIndex, toIndex);
    }

    public static final double[] rank(double[] x, double[] wt) {
        int n = x.length;
        double[] ranks = new double[n];
        int[] index = Sorter.indexedDoubleArraySort(x, 0, n);
        int lind = index[0];
        double am = x[lind];
        int k1 = 0;
        int k2 = 0;
        double ak = 1.0;
        int kms = 1;
        int k = 1;
        while (k < n) {
            int kind = index[k];
            boolean insert = true;
            if (!Double.isNaN(am)) {
                double freq = 1.0;
                kms += (int)freq;
                if (freq > 1.0) {
                    ak += 0.5 * (freq - 1.0);
                    k1 = k;
                    k2 = k;
                } else if (x[kind] == am) {
                    k2 = k;
                    ak += 0.5;
                    if (k < n - 1) {
                        insert = false;
                    }
                }
                if (insert) {
                    int l = k1;
                    while (l <= k2) {
                        lind = index[l];
                        ranks[lind] = ak;
                        ++l;
                    }
                    if (k2 != n - 1 && k == n - 1) {
                        ranks[kind] = kms;
                    }
                }
            }
            if (insert) {
                k1 = k;
                k2 = k;
                ak = kms;
                am = x[kind];
            }
            ++k;
        }
        return ranks;
    }

    public static final int[] indexedDoubleArraySort(final double[] x, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            fromIndex = 0;
            toIndex = x.length;
        }
        Integer[] sortOrder = new Integer[toIndex - fromIndex];
        int i = 0;
        while (i < sortOrder.length) {
            sortOrder[i] = new Integer(i);
            ++i;
        }
        Arrays.sort(sortOrder, fromIndex, toIndex, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                int secondIndex;
                int firstIndex = (Integer)object1;
                if (x[firstIndex] > x[secondIndex = ((Integer)object2).intValue()]) {
                    return 1;
                }
                if (x[firstIndex] < x[secondIndex]) {
                    return -1;
                }
                if (Double.isNaN(x[firstIndex]) && Double.isNaN(x[secondIndex])) {
                    return 0;
                }
                if (Double.isNaN(x[firstIndex])) {
                    return 1;
                }
                if (Double.isNaN(x[secondIndex])) {
                    return -1;
                }
                return 0;
            }
        });
        int[] result = new int[sortOrder.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = sortOrder[i2];
            ++i2;
        }
        return result;
    }

    private static Integer[] sort(final double[] x) {
        Integer[] sortOrder = new Integer[x.length];
        int i = 0;
        while (i < x.length) {
            sortOrder[i] = new Integer(i);
            ++i;
        }
        Arrays.sort(sortOrder, 0, x.length, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                int firstIndex = (Integer)object1;
                int secondIndex = (Integer)object2;
                return Double.compare(x[firstIndex], x[secondIndex]);
            }
        });
        return sortOrder;
    }
}

