/*
 * Decompiled with CFR 0.152.
 */
package model;

import scores.ProjectionInfo;

public class UnionMeasurer {
    public static int[] simpleUnion(int[] xwt, int[] ywt) {
        int nVars = xwt.length;
        int[] res = new int[nVars * 3];
        int i = 0;
        while (i < nVars) {
            if (xwt[i] == 0) {
                res[i * 3 + 1] = 1;
            } else if (xwt[i] < 0) {
                res[i * 3] = 1;
            } else {
                res[i * 3 + 2] = 1;
            }
            ++i;
        }
        i = 0;
        while (i < nVars) {
            if (ywt[i] == 0) {
                res[i * 3 + 1] = 1;
            } else if (ywt[i] < 0) {
                res[i * 3] = 1;
            } else {
                res[i * 3 + 2] = 1;
            }
            ++i;
        }
        return res;
    }

    public static int[] orthogonalUnion(int[] xwt, int[] ywt) {
        if (xwt.length != ywt.length) {
            return null;
        }
        int nVars = xwt.length;
        int[] res = new int[nVars * 3];
        int i = 0;
        while (i < nVars) {
            if (xwt[i] * ywt[i] == 0) {
                res[i * 3 + 1] = 1;
            } else if (xwt[i] * ywt[i] < 0) {
                res[i * 3] = 1;
            } else {
                res[i * 3 + 2] = 1;
            }
            ++i;
        }
        return res;
    }

    public static int[] presenceUnion(int[] xwt, int[] ywt) {
        int nVars = xwt.length;
        int[] res = new int[nVars];
        int i = 0;
        while (i < nVars) {
            if (xwt[i] != 0) {
                res[i] = 1;
            }
            ++i;
        }
        i = 0;
        while (i < nVars) {
            if (ywt[i] != 0) {
                res[i] = 1;
            }
            ++i;
        }
        return res;
    }

    public static int[] countUnion(int[] xwt, int[] ywt) {
        int nVars = xwt.length;
        int[] res = new int[nVars];
        int i = 0;
        while (i < nVars) {
            if (xwt[i] != 0) {
                int n = i;
                res[n] = res[n] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < nVars) {
            if (ywt[i] != 0) {
                int n = i;
                res[n] = res[n] + 1;
            }
            ++i;
        }
        return res;
    }

    public static int[] sumUnion(int[] xwt, int[] ywt) {
        int nVars = xwt.length;
        int[] res = new int[nVars];
        int i = 0;
        while (i < nVars) {
            if (xwt[i] != 0) {
                int n = i;
                res[n] = res[n] + xwt[i];
            }
            ++i;
        }
        i = 0;
        while (i < nVars) {
            if (ywt[i] != 0) {
                int n = i;
                res[n] = res[n] + ywt[i];
            }
            ++i;
        }
        return res;
    }

    public static int[] presenceUnion(ProjectionInfo a, ProjectionInfo b, int nVars) {
        int[] res = new int[nVars];
        int i = 0;
        while (i < nVars) {
            int wa = a.getVariableInProjection(i);
            int wb = b.getVariableInProjection(i);
            if (wa >= 0) {
                res[i] = 1;
            }
            if (wb >= 0) {
                res[i] = 1;
            }
            ++i;
        }
        return res;
    }

    public static int[] countUnion(ProjectionInfo a, ProjectionInfo b, int nVars) {
        int[] res = new int[nVars];
        int i = 0;
        while (i < nVars) {
            int wa = a.getVariableInProjection(i);
            int wb = b.getVariableInProjection(i);
            if (wa >= 0) {
                int n = i;
                res[n] = res[n] + 1;
            }
            if (wb >= 0) {
                int n = i;
                res[n] = res[n] + 1;
            }
            ++i;
        }
        return res;
    }

    public static double[] sumUnion(ProjectionInfo a, ProjectionInfo b, int nVars) {
        double[] wts = new double[nVars];
        int i = 0;
        while (i < nVars) {
            int wa = a.getVariableInProjection(i);
            int wb = b.getVariableInProjection(i);
            double wt = 0.0;
            if (wa >= 0) {
                wt += a.getWeights()[wa];
            }
            if (wb >= 0) {
                wt += b.getWeights()[wb];
            }
            wts[i] = wt;
            ++i;
        }
        return wts;
    }
}

