/*
 * Decompiled with CFR 0.152.
 */
package model;

public class Utils {
    public static double[][] normalize(double[][] d) {
        int npts = d.length;
        int nvars = d[0].length;
        double[] dmin = new double[nvars];
        double[] dmax = new double[nvars];
        int i = 0;
        while (i < nvars) {
            dmin[i] = Double.MAX_VALUE;
            dmax[i] = Double.MIN_VALUE;
            ++i;
        }
        i = 0;
        while (i < npts) {
            int j = 0;
            while (j < nvars) {
                dmin[j] = Math.min(dmin[j], d[i][j]);
                dmax[j] = Math.max(dmax[j], d[i][j]);
                ++j;
            }
            ++i;
        }
        double[][] res = new double[npts][nvars];
        int i2 = 0;
        while (i2 < npts) {
            int j = 0;
            while (j < nvars) {
                res[i2][j] = (d[i2][j] - dmin[j]) / (dmax[j] - dmin[j]);
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static double[] normalize(double[] d) {
        int npts = d.length;
        double dmin = Double.MAX_VALUE;
        double dmax = Double.MIN_VALUE;
        int i = 0;
        while (i < npts) {
            dmin = Math.min(dmin, d[i]);
            dmax = Math.max(dmax, d[i]);
            ++i;
        }
        double[] res = new double[npts];
        int i2 = 0;
        while (i2 < npts) {
            res[i2] = dmax == dmin ? d[i2] : (d[i2] - dmin) / (dmax - dmin);
            ++i2;
        }
        return res;
    }

    public static double[][] standardizeData(double[][] d) {
        if (d == null) {
            return null;
        }
        int nvars = d[0].length;
        double[] mean = new double[nvars];
        double[] std = new double[nvars];
        double[] count = new double[nvars];
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < nvars) {
                int n = j;
                count[n] = count[n] + 1.0;
                double xd = d[i][j] - mean[j];
                int n2 = j;
                mean[n2] = mean[n2] + xd / count[j];
                int n3 = j;
                std[n3] = std[n3] + xd * (d[i][j] - mean[j]);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < nvars) {
            std[j] = Math.sqrt(std[j] / (count[j] - 1.0));
            ++j;
        }
        double[][] res = new double[d.length][nvars];
        int i2 = 0;
        while (i2 < d.length) {
            int j2 = 0;
            while (j2 < nvars) {
                if (std[j2] > 0.0) {
                    res[i2][j2] = (d[i2][j2] - mean[j2]) / std[j2];
                }
                ++j2;
            }
            ++i2;
        }
        return res;
    }

    public static double[][] multiply(double[][] a, double[][] b) {
        double[][] res = new double[a.length][b[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                int k = 0;
                while (k < b[0].length) {
                    double[] dArray = res[i];
                    int n = k;
                    dArray[n] = dArray[n] + a[i][j] * b[j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] add(double[][] a, double[][] b, double scalar) {
        if (a == null || b == null) {
            return null;
        }
        if (a.length != b.length) {
            return null;
        }
        if (a[0].length != b[0].length) {
            return null;
        }
        double[][] res = new double[a.length][a[0].length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                if (scalar > 0.0) {
                    res[i][j] = a[i][j] + scalar * b[i][j];
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] add(double[] a, double[] b) {
        double[] res = new double[a.length];
        int i = 0;
        while (i < res.length) {
            res[i] = a[i] + b[i];
            ++i;
        }
        return res;
    }

    public static double[] minus(double[] a, double[] b) {
        double[] res = new double[a.length];
        int i = 0;
        while (i < res.length) {
            res[i] = a[i] - b[i];
            ++i;
        }
        return res;
    }

    public static double[] divide(double[] a, int scalar) {
        double[] res = new double[a.length];
        int i = 0;
        while (i < res.length) {
            res[i] = a[i] / (double)scalar;
            ++i;
        }
        return res;
    }

    public static double distance(double[] a, double[] b) {
        double d = 0.0;
        int i = 0;
        while (i < a.length) {
            d += (a[i] - b[i]) * (a[i] - b[i]);
            ++i;
        }
        return Math.sqrt(d);
    }

    public static double dotProduct(double[] a, double[] b) {
        if (a.length != b.length) {
            System.out.println("SUBMes::dot product invalid!");
            System.exit(1);
        }
        double res = 0.0;
        int i = 0;
        while (i < a.length) {
            res += a[i] * b[i];
            ++i;
        }
        return res;
    }

    public static double vectorLength(double[] a) {
        double res = 0.0;
        int i = 0;
        while (i < a.length) {
            res += a[i] * a[i];
            ++i;
        }
        return Math.sqrt(res);
    }
}

