/*
 * Decompiled with CFR 0.152.
 */
package scores;

import data.DataSource;
import scores.Bin;

public class IntervalBinner {
    private Bin[] bins;
    private int nBins;

    public IntervalBinner(int nBins) {
        this.nBins = nBins;
        this.bins = new Bin[nBins];
    }

    public int[] getCounts() {
        int[] c = new int[this.nBins];
        int i = 0;
        while (i < this.nBins) {
            c[i] = this.bins[i].count;
            ++i;
        }
        return c;
    }

    public double[][] getBinnedData() {
        double[][] d = new double[this.nBins][this.bins[0].centroid.length];
        int i = 0;
        while (i < this.nBins) {
            d[i] = this.bins[i].centroid;
            ++i;
        }
        return d;
    }

    public int getNumBins() {
        return this.nBins;
    }

    public void compute(DataSource data, double[] x) {
        int j = 0;
        while (j < this.nBins) {
            this.bins[j] = new Bin(1);
            ++j;
        }
        int i = 0;
        while (i < x.length) {
            if (!Double.isNaN(x[i])) {
                int ix = (int)(0.99999 * x[i] * (double)this.nBins);
                ix = Math.max(Math.min(ix, this.nBins - 1), 0);
                Bin bin = this.bins[ix];
                ++bin.count;
                bin.centroid[0] = bin.centroid[0] + (x[i] - bin.centroid[0]) / (double)bin.count;
            }
            ++i;
        }
    }
}

