/*
 * Decompiled with CFR 0.152.
 */
package scores;

import gui.LetterValueBoxPlot;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import model.Sorter;
import model.Utils;
import scores.MSTEdge;
import scores.MSTNode;

public class MSTMeasures {
    private double outlierCutoff = -1.0;
    private boolean[] outliers = null;
    private boolean[] inliers = null;
    private double[] lengths;
    public MSTEdge[] MSTedges = null;
    public MSTNode[] MSTnodes = null;
    public LetterValueBoxPlot lvb = null;
    public ArrayList<Integer> striatedEdges;

    public void computeMST(double[][] pts) {
        int nPts = pts.length;
        int nVar = pts[0].length;
        if (nPts < 2) {
            return;
        }
        this.MSTnodes = new MSTNode[nPts];
        this.MSTedges = new MSTEdge[nPts - 1];
        this.lengths = new double[nPts - 1];
        int[] list = new int[nPts];
        double[] cost = new double[nPts];
        list[0] = 0;
        cost[0] = Double.POSITIVE_INFINITY;
        int cheapest = 0;
        this.MSTnodes[0] = new MSTNode(pts[0], 1, 0);
        int i = 1;
        while (i < nPts) {
            this.MSTnodes[i] = new MSTNode(pts[i], 1, i);
            cost[i] = this.MSTnodes[i].distToNode(this.MSTnodes[0]);
            if (cost[i] < cost[cheapest]) {
                cheapest = i;
            }
            ++i;
        }
        int j = 1;
        while (j < nPts) {
            int end = list[cheapest];
            int jp = j - 1;
            this.MSTedges[jp] = new MSTEdge(this.MSTnodes[cheapest], this.MSTnodes[end]);
            this.MSTedges[jp].length = cost[cheapest];
            this.lengths[jp] = cost[cheapest];
            this.MSTnodes[cheapest].setNeighbor(this.MSTedges[jp]);
            this.MSTnodes[end].setNeighbor(this.MSTedges[jp]);
            cost[cheapest] = Double.POSITIVE_INFINITY;
            end = cheapest;
            int i2 = 1;
            while (i2 < nPts) {
                if (cost[i2] != Double.POSITIVE_INFINITY) {
                    double dist = 0.0;
                    int k = 0;
                    while (k < nVar) {
                        if (!Double.isNaN(pts[i2][k]) && !Double.isNaN(pts[end][k])) {
                            dist += (pts[i2][k] - pts[end][k]) * (pts[i2][k] - pts[end][k]);
                        }
                        ++k;
                    }
                    if ((dist = Math.sqrt(dist)) < cost[i2]) {
                        list[i2] = end;
                        cost[i2] = dist;
                    }
                    if (cost[i2] < cost[cheapest]) {
                        cheapest = i2;
                    }
                }
                ++i2;
            }
            ++j;
        }
    }

    public double[] computeLVBOutliers(double[][] pts) {
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int nPts = pts.length;
        this.lvb = new LetterValueBoxPlot(this.lengths, true);
        double[] res = new double[2];
        boolean[] outliers = new boolean[nPts];
        int i = 0;
        while (i < nPts) {
            outliers[i] = true;
            ++i;
        }
        int c = 0;
        int i2 = 0;
        while (i2 < nPts - 1) {
            res[1] = res[1] + this.MSTedges[i2].length;
            if (this.MSTedges[i2].length < this.lvb.geUpperThreshold()) {
                outliers[this.MSTedges[i2].p1.nodeID] = false;
                outliers[this.MSTedges[i2].p2.nodeID] = false;
                ++c;
            } else {
                res[0] = res[0] + this.MSTedges[i2].length;
            }
            ++i2;
        }
        System.out.println("LVBoutliers:: nPts: " + nPts + " # outliers: " + (nPts - c) + " MSTotalen: " + res[1] + " Outlen: " + res[0]);
        this.outliers = outliers;
        return res;
    }

    public double[] computeLVBInliers(double[][] pts) {
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int nPts = pts.length;
        this.lvb = new LetterValueBoxPlot(this.lengths, true);
        boolean[] inliers = new boolean[nPts];
        int i = 0;
        while (i < nPts) {
            inliers[i] = true;
            ++i;
        }
        int c = 0;
        double[] res = new double[2];
        int i2 = 0;
        while (i2 < nPts - 1) {
            res[1] = res[1] + this.MSTedges[i2].length;
            if (this.MSTedges[i2].length > this.lvb.getLowerThreshold()) {
                inliers[this.MSTedges[i2].p1.nodeID] = false;
                inliers[this.MSTedges[i2].p2.nodeID] = false;
                ++c;
            } else {
                res[0] = res[0] + this.MSTedges[i2].length;
            }
            ++i2;
        }
        this.inliers = inliers;
        return res;
    }

    public double computeLVBOutlierMeasure(double[][] pts) {
        double[] res = this.computeLVBOutliers(pts);
        return res[0] / res[1];
    }

    private void computeOutliers(double[][] pts) {
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int nPts = pts.length;
        this.outlierCutoff = this.findCutoff(this.lengths);
        boolean[] outliers = new boolean[nPts];
        int i = 0;
        while (i < nPts) {
            outliers[i] = true;
            ++i;
        }
        int c = 0;
        int i2 = 0;
        while (i2 < nPts - 1) {
            if (this.lengths[i2] < this.outlierCutoff) {
                outliers[this.MSTedges[i2].p1.nodeID] = false;
                outliers[this.MSTedges[i2].p2.nodeID] = false;
                ++c;
            }
            ++i2;
        }
        System.out.println("TOTAL # PTS: " + nPts + " # outliers: " + (nPts - c) + " CUTOFF: " + this.outlierCutoff);
        this.outliers = outliers;
    }

    private double findCutoff(double[] distances) {
        int[] index = Sorter.indexedDoubleArraySort(distances, 0, 0);
        int n50 = distances.length / 2;
        int n25 = n50 / 2;
        int n75 = n50 + n50 / 2;
        return distances[index[n75]] + 1.5 * (distances[index[n75]] - distances[index[n25]]);
    }

    public double computeOutlierMeasure(double[][] pts) {
        return this.computeLVBOutlierMeasure(pts);
    }

    public double computeTukeyOutlierMeasure(double[][] pts) {
        this.lvb = null;
        this.computeOutliers(pts);
        double totalOriginalMSTLengths = 0.0;
        double totalMSTOutlierLengths = 0.0;
        int i = 0;
        while (i < this.lengths.length) {
            totalOriginalMSTLengths += this.lengths[i];
            if (this.lengths[i] >= this.outlierCutoff) {
                totalMSTOutlierLengths += this.lengths[i];
            }
            ++i;
        }
        return totalMSTOutlierLengths / totalOriginalMSTLengths;
    }

    public ArrayList<Integer> getOutliers() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        while (i < this.outliers.length) {
            if (this.outliers[i]) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    public ArrayList<Integer> getInliers() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        while (i < this.inliers.length) {
            if (this.inliers[i]) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    public double computeClumpyMeasure(double[][] pts) {
        this.lvb = null;
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int numNodes = pts.length;
        double[] maxLength = new double[1];
        double maxValue = 0.0;
        int i = 0;
        while (i < this.lengths.length) {
            double value;
            this.clearVisits();
            int runts = this.MSTedges[i].getRunts(maxLength);
            if (maxLength[0] > 0.0 && (value = (double)runts * (1.0 - maxLength[0] / this.MSTedges[i].length)) > maxValue) {
                maxValue = value;
            }
            ++i;
        }
        return 2.0 * maxValue / (double)numNodes;
    }

    private void clearVisits() {
        int i = 0;
        while (i < this.MSTnodes.length) {
            this.MSTnodes[i].isVisited = false;
            ++i;
        }
    }

    public double computeSparsenessMeasure(double[][] pts) {
        this.lvb = null;
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int n = this.lengths.length;
        double[] sortedLengths = new double[this.lengths.length];
        System.arraycopy(this.lengths, 0, sortedLengths, 0, this.lengths.length);
        Arrays.sort(sortedLengths);
        int n90 = 9 * n / 10;
        double sparse = Math.min(sortedLengths[n90] / 1000.0, 1.0);
        double t = (double)this.MSTnodes.length / 500.0;
        double correction = 0.7 + 0.3 / (1.0 + t * t);
        return correction * sparse;
    }

    public double computeStringyMeasure(double[][] pts) {
        this.lvb = null;
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        int count1 = 0;
        int count2 = 0;
        int i = 0;
        while (i < this.MSTnodes.length) {
            if (this.MSTnodes[i].mstDegree == 1) {
                ++count1;
            }
            if (this.MSTnodes[i].mstDegree == 2) {
                ++count2;
            }
            ++i;
        }
        double result = (double)count2 / (double)(this.MSTnodes.length - count1);
        return result * result * result;
    }

    public double computeStriationMeasure(double[][] pts) {
        this.lvb = null;
        if (this.MSTedges == null) {
            this.computeMST(pts);
        }
        this.striatedEdges = new ArrayList();
        double numEdges = 0.0;
        double c = 0.0;
        int i = 0;
        while (i < this.MSTedges.length) {
            MSTNode n1 = this.MSTedges[i].p1;
            MSTNode n2 = this.MSTedges[i].p2;
            if (n1.mstDegree == 2 && n2.mstDegree == 2) {
                MSTEdge e1 = this.getAdjacentMSTEdge(n1, this.MSTedges[i]);
                MSTEdge e2 = this.getAdjacentMSTEdge(n2, this.MSTedges[i]);
                double c1 = this.cosineOfAdjacentEdges(this.MSTedges[i], e1, n1);
                double c2 = this.cosineOfAdjacentEdges(this.MSTedges[i], e2, n2);
                c += 1.0;
                if (c1 < 0.5 && c1 > -0.5 && c2 < 0.5 && c2 > -0.5) {
                    numEdges += 1.0;
                    this.striatedEdges.add(i);
                }
            }
            ++i;
        }
        System.out.println("numE: " + numEdges + " tot: " + this.MSTedges.length + " degree2: " + c + "SCORE " + numEdges / (double)this.MSTedges.length);
        return numEdges / (double)this.MSTedges.length;
    }

    private MSTEdge getAdjacentMSTEdge(MSTNode node, MSTEdge edge) {
        Iterator<MSTEdge> nt = node.getNeighborIterator();
        while (nt.hasNext()) {
            MSTEdge et = nt.next();
            if (edge.equals(et)) continue;
            return et;
        }
        return null;
    }

    private double cosineOfAdjacentEdges(MSTEdge e1, MSTEdge e2, MSTNode node) {
        MSTNode other1 = e1.otherNode(node);
        MSTNode other2 = e2.otherNode(node);
        double[] a = other1.difference(node);
        double[] b = other2.difference(node);
        double res = Utils.dotProduct(a, b) / (Utils.vectorLength(a) * Utils.vectorLength(b));
        return res;
    }

    public static void evaluateAnomalies(int[] classValues, String fname, ArrayList<Integer> outlierIndices) {
        int[] rare = null;
        if (fname.contains("arrhythmia")) {
            rare = new int[]{2, 3, 6, 7, 8, 10, 11, 12};
        }
        if (fname.contains("lymphography")) {
            int[] nArray = new int[2];
            nArray[1] = 3;
            rare = nArray;
        }
        if (fname.contains("shuttle")) {
            rare = new int[]{4, 5, 6};
        }
        if (fname.contains("poker")) {
            rare = new int[]{5, 6, 7, 8};
        }
        if (fname.contains("ionosphere")) {
            rare = new int[1];
        }
        if (fname.contains("cover")) {
            rare = new int[]{3};
        }
        if (classValues != null && rare != null) {
            int numActualDetected = 0;
            int numDetected = 0;
            int numActual = 0;
            int i = 0;
            while (i < classValues.length) {
                if (Arrays.binarySearch(rare, classValues[i]) >= 0) {
                    ++numActual;
                }
                ++i;
            }
            i = 0;
            while (i < outlierIndices.size()) {
                if (Arrays.binarySearch(rare, classValues[outlierIndices.get(i)]) >= 0) {
                    ++numActualDetected;
                }
                ++i;
            }
            numDetected = outlierIndices.size();
            MSTMeasures.printPrecisionRecall(numActual, numActualDetected, numDetected);
        }
    }

    public static void printPrecisionRecall(int numActual, int numActualDetected, int numDetected) {
        System.out.println("numActual:" + numActual + " numActualDetected: " + numActualDetected + " numDetected: " + numDetected);
        System.out.println("% ACTUAL DETECTED = " + (double)numActualDetected * 1.0 / (double)numActual);
        double precision = (double)numActualDetected * 1.0 / (double)numDetected;
        System.out.println("PRECISION = " + precision);
        double recall = (double)numActualDetected * 1.0 / (double)numActual;
        System.out.println("RECALL = " + recall);
        System.out.println("F SCORE = " + 2.0 * precision * recall / (precision + recall));
    }

    public void writeOutliers(String fname) {
        try {
            if (this.outliers != null) {
                BufferedWriter bwx = new BufferedWriter(new FileWriter(fname));
                int i = 0;
                while (i < this.outliers.length) {
                    if (this.outliers[i]) {
                        bwx.write(String.valueOf(i) + "\n");
                    }
                    ++i;
                }
                bwx.close();
            }
        }
        catch (IOException ie) {
            System.out.println("Error writing outlier data: " + ie);
        }
    }

    public static void writeOutlierStats(String fname, int np, int nv, int nr, int seed, int numActual, int numActualDetected, int numDetected) {
        try {
            BufferedWriter bwx;
            File of = new File("outlierStats.txt");
            if (!of.exists()) {
                bwx = new BufferedWriter(new FileWriter(of));
                bwx.write("Dataset, NumInstances, NumVars, NumActual, NumRPs, RandomSeed, NumDetected, Precision, Recall, F-Score\n");
                bwx.close();
            }
            bwx = new BufferedWriter(new FileWriter(of, true));
            double precision = (double)numActualDetected * 1.0 / (double)numDetected;
            double recall = (double)numActualDetected * 1.0 / (double)numActual;
            double fscore = 2.0 * precision * recall / (precision + recall);
            String[] vals = fname.split("/");
            String dataset = vals[vals.length - 1].split(".txt")[0];
            bwx.write(String.valueOf(dataset) + "," + np + "," + nv + "," + numActual + "," + nr + "," + seed + "," + numActualDetected + "," + precision + "," + recall + "," + fscore + "\n");
            bwx.close();
        }
        catch (IOException ie) {
            System.out.println("Error writing outlier data: " + ie);
        }
    }
}

