/*
 * Decompiled with CFR 0.152.
 */
package scores;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scores.MSTEdge;

public class MSTNode {
    double[] x;
    int count;
    List<MSTEdge> neighbors;
    boolean isVisited = false;
    int mstDegree;
    public int nodeID;

    MSTNode(double[] x, int count, int ID) {
        this.x = x;
        this.count = count;
        this.nodeID = ID;
        this.neighbors = new ArrayList<MSTEdge>();
    }

    double[] difference(MSTNode node) {
        double[] dx = new double[this.x.length];
        int i = 0;
        while (i < this.x.length) {
            if (!Double.isNaN(node.x[i]) && !Double.isNaN(this.x[i])) {
                dx[i] = node.x[i] - this.x[i];
            }
            ++i;
        }
        return dx;
    }

    double distToNode(MSTNode node) {
        double dx = 0.0;
        int i = 0;
        while (i < this.x.length) {
            if (!Double.isNaN(node.x[i]) && !Double.isNaN(this.x[i])) {
                dx += (node.x[i] - this.x[i]) * (node.x[i] - this.x[i]);
            }
            ++i;
        }
        return Math.sqrt(dx);
    }

    void setNeighbor(MSTEdge neighbor) {
        this.neighbors.add(neighbor);
        ++this.mstDegree;
    }

    Iterator<MSTEdge> getNeighborIterator() {
        return this.neighbors.iterator();
    }

    int getMSTChildren(double cutoff, double[] maxLength) {
        int count = 0;
        if (this.isVisited) {
            return count;
        }
        this.isVisited = true;
        for (MSTEdge e : this.neighbors) {
            if (!(e.length < cutoff) || e.otherNode((MSTNode)this).isVisited) continue;
            count += e.otherNode(this).getMSTChildren(cutoff, maxLength);
            double el = e.length;
            if (!(el > maxLength[0])) continue;
            maxLength[0] = el;
        }
        return count += this.count;
    }
}

