/*
 * Decompiled with CFR 0.152.
 */
package scores;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import model.SimilarityMeasurer;
import scores.ProjectionInfo;
import scores.ScagnosticScorer;

public class Projection {
    private Random random;
    private int ranLoc;

    public Projection(Random random) {
        this.random = random;
    }

    public static double[][] getDataForProjections(double[][] data, ProjectionInfo[] ps) {
        int nPts = data.length;
        double[][] selData = new double[nPts][ps.length];
        try {
            int d = 0;
            while (d < nPts) {
                int i = 0;
                while (i < ps.length) {
                    int[] xinds = ps[i].getIndices();
                    double[] wts = ps[i].getWeights();
                    int j = 0;
                    while (j < xinds.length) {
                        double[] dArray = selData[d];
                        int n = i;
                        dArray[n] = dArray[n] + data[d][xinds[j]] * wts[j];
                        ++j;
                    }
                    ++i;
                }
                ++d;
            }
        }
        catch (Exception e) {
            System.out.println("Projection::ERROR: " + e);
            e.printStackTrace();
        }
        return selData;
    }

    public static double[][] getDataForProjection(double[][] data, ProjectionInfo ps) {
        int nPts = data.length;
        double[][] selData = new double[nPts][1];
        try {
            int d = 0;
            while (d < nPts) {
                int[] xinds = ps.getIndices();
                double[] wts = ps.getWeights();
                int j = 0;
                while (j < xinds.length) {
                    double[] dArray = selData[d];
                    dArray[0] = dArray[0] + data[d][xinds[j]] * wts[j];
                    ++j;
                }
                ++d;
            }
        }
        catch (Exception e) {
            System.out.println("Projection::ERROR: " + e);
            e.printStackTrace();
        }
        return selData;
    }

    public ProjectionInfo random1DProjection(double[][] data, int nVariables, ScagnosticScorer scorer) {
        ProjectionInfo bestProj = null;
        int nWts = nVariables;
        if (nWts > 10) {
            nWts = (int)Math.sqrt(nVariables);
        }
        int[] bestVars = this.selectRandomVariables(nVariables, nWts, null);
        bestProj = this.generateRandomWeights(nWts, bestVars);
        bestProj.setScore(scorer.score1DProjection(data, bestProj));
        return bestProj;
    }

    public ProjectionInfo[] randomkDProjection(double[][] data, int nVariables, int k, ScagnosticScorer scorer) {
        ProjectionInfo[] bestProj = new ProjectionInfo[k];
        HashSet seenVariables = new HashSet();
        int i = 0;
        while (i < k) {
            int nWts = nVariables;
            if (nWts > 10) {
                nWts = (int)Math.sqrt(nVariables);
            }
            int[] bestVars = this.selectRandomVariables(nVariables, nWts, null);
            bestProj[i] = this.generateRandomWeights(nWts, bestVars);
            ++i;
        }
        return bestProj;
    }

    public int[] selectRandomVariables(int nVariables, int nWts, HashSet<Integer> seenVariables) {
        int[] varIndices;
        if (nVariables < nWts) {
            varIndices = new int[nVariables];
            int i = 0;
            while (i < nVariables) {
                varIndices[i] = i;
                ++i;
            }
        } else {
            varIndices = new int[nWts];
            ArrayList<Integer> seen = new ArrayList<Integer>();
            int i = 0;
            while (i < nWts) {
                int index = this.random.nextInt(nVariables);
                if (seen.contains(index)) continue;
                if (seenVariables != null) {
                    if (!seenVariables.add(index)) continue;
                    varIndices[i] = index;
                    seen.add(index);
                    ++i;
                    continue;
                }
                varIndices[i] = index;
                seen.add(index);
                ++i;
            }
        }
        return varIndices;
    }

    private ProjectionInfo generateRandomWeights(int nWts, int[] weightIndices) {
        int[] inds = new int[nWts];
        double[] wts = new double[nWts];
        int i = 0;
        while (i < nWts) {
            wts[i] = 1.0;
            ++i;
        }
        this.shuffleArray(weightIndices);
        System.arraycopy(weightIndices, 0, inds, 0, nWts);
        int attemptMove = 0;
        while (attemptMove < inds.length / 2) {
            this.ranLoc = this.random.nextInt(inds.length);
            wts[this.ranLoc] = -wts[this.ranLoc];
            ++attemptMove;
        }
        ProjectionInfo proj = new ProjectionInfo(inds, wts);
        return proj;
    }

    public void shuffleArray(int[] a) {
        int i = 0;
        while (i < a.length) {
            int position = i + this.random.nextInt(a.length - i);
            int temp = a[i];
            a[i] = a[position];
            a[position] = temp;
            ++i;
        }
    }

    private double[] getWeightVector(ProjectionInfo proj, int nVars) {
        double[] weightsX = new double[nVars];
        int i = 0;
        while (i < proj.getLength()) {
            weightsX[proj.getIndices()[i]] = proj.getWeights()[i];
            ++i;
        }
        return weightsX;
    }

    public boolean isSimilarProjection(ProjectionInfo[] projs, ProjectionInfo p, int nVars) {
        int count = 0;
        int i = 0;
        while (i < projs.length) {
            if (projs[i] != null) {
                double[] wts = this.getWeightVector(projs[i], nVars);
                double[] nwts = this.getWeightVector(p, nVars);
                double sim = SimilarityMeasurer.computeCosineSimilarity(nwts, wts);
                if (Math.abs(sim) < 0.75) {
                    return false;
                }
                ++count;
            }
            ++i;
        }
        return count != 0;
    }
}

