/*
 * Decompiled with CFR 0.152.
 */
package scores;

import java.util.Random;

public class ProjectionInfo {
    private int[] indices;
    private double[] weights;
    private double score;
    private int classIndex;
    int ranLoc;

    public ProjectionInfo() {
        this.indices = null;
        this.weights = null;
        this.score = -1.0;
        this.ranLoc = -1;
        this.classIndex = -1;
    }

    public ProjectionInfo(int[] inds, double[] wts) {
        this.setIndices(inds);
        this.setWeights(wts);
    }

    public void setIndices(int[] inds) {
        this.indices = new int[inds.length];
        System.arraycopy(inds, 0, this.indices, 0, inds.length);
    }

    public void setWeights(double[] wts) {
        this.weights = new double[wts.length];
        System.arraycopy(wts, 0, this.weights, 0, wts.length);
    }

    public void setScore(double s) {
        this.score = s;
    }

    public void setClass(int cindex) {
        this.classIndex = cindex;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public int getLength() {
        if (this.indices == null || this.weights == null) {
            return 0;
        }
        if (this.indices.length != this.weights.length) {
            System.out.println("ProjectionInfo:: ERROR = weights length != indices length");
            return -1;
        }
        return this.indices.length;
    }

    public double getScore() {
        return this.score;
    }

    public void print() {
        System.out.print("1D ProjectionInfo -- ");
        int i = 0;
        while (i < this.indices.length) {
            System.out.print(" " + this.weights[i] + "*" + " var" + this.indices[i]);
            ++i;
        }
        System.out.println(" SCORE: " + this.score);
    }

    public void shuffle() {
        if (this.indices.length != this.weights.length) {
            System.out.println("ProjectionInfo::shuffle -- lengths not equal!");
            System.exit(1);
        }
        Random random = new Random();
        int i = this.indices.length - 1;
        while (i > 0) {
            int j = random.nextInt(i);
            int t = this.indices[i];
            double tt = this.weights[i];
            this.indices[i] = this.indices[j];
            this.weights[i] = this.weights[j];
            this.indices[j] = t;
            this.weights[j] = tt;
            --i;
        }
    }

    public void move() {
        Random random = new Random();
        this.ranLoc = random.nextInt(this.weights.length);
        this.weights[this.ranLoc] = -this.weights[this.ranLoc];
    }

    public void reset() {
        this.weights[this.ranLoc] = -this.weights[this.ranLoc];
    }

    public void clip(int length) {
        if (length < this.indices.length) {
            int[] tmp = new int[length];
            System.arraycopy(this.indices, 0, tmp, 0, length);
            this.indices = tmp;
            double[] tmp1 = new double[length];
            System.arraycopy(this.weights, 0, tmp1, 0, length);
            this.weights = tmp1;
        }
    }

    public boolean hasVariableInProjection(int varIndex) {
        int i = 0;
        while (i < this.indices.length) {
            if (this.indices[i] == varIndex) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getVariableInProjection(int varIndex) {
        int i = 0;
        while (i < this.indices.length) {
            if (this.indices[i] == varIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

