/*
 * Decompiled with CFR 0.152.
 */
package scores;

import data.DataSource;
import java.awt.Color;
import scores.Bin;

public class RectBinner {
    private Bin[][] bins;
    private int nBins;
    public Color[] ptColors;
    private Color[][] grid;

    public RectBinner(int nBins) {
        this.nBins = nBins;
        this.bins = new Bin[nBins][nBins];
        this.grid = new Color[3][];
        int i = 0;
        while (i < 3) {
            this.grid[i] = new Color[3];
            ++i;
        }
        this.grid[0][0] = Color.BLUE;
        this.grid[0][1] = Color.GREEN;
        this.grid[0][2] = Color.GRAY;
        this.grid[1][0] = Color.RED;
        this.grid[1][1] = Color.CYAN;
        this.grid[1][2] = Color.PINK;
        this.grid[2][0] = Color.YELLOW;
        this.grid[2][1] = Color.ORANGE;
        this.grid[2][2] = Color.MAGENTA;
    }

    public Bin[][] getBins() {
        return this.bins;
    }

    public int getNumBins() {
        return this.nBins;
    }

    public void compute(DataSource data, double[] x, double[] y) {
        int j = 0;
        while (j < this.nBins) {
            int k = 0;
            while (k < this.nBins) {
                this.bins[j][k] = new Bin(2);
                ++k;
            }
            ++j;
        }
        this.ptColors = new Color[x.length];
        int i = 0;
        while (i < x.length) {
            if (!Double.isNaN(x[i]) && !Double.isNaN(y[i])) {
                int yind;
                int ix = (int)(0.99999 * x[i] * (double)this.nBins);
                int iy = (int)(0.99999 * y[i] * (double)this.nBins);
                ix = Math.max(Math.min(ix, this.nBins - 1), 0);
                iy = Math.max(Math.min(iy, this.nBins - 1), 0);
                Bin bin = this.bins[ix][iy];
                ++bin.count;
                bin.centroid[0] = bin.centroid[0] + (x[i] - bin.centroid[0]) / (double)bin.count;
                bin.centroid[1] = bin.centroid[1] + (y[i] - bin.centroid[1]) / (double)bin.count;
                int gridSize = this.nBins / 3;
                int xind = ix / gridSize;
                if (xind >= 3) {
                    xind = 2;
                }
                if ((yind = iy / gridSize) >= 3) {
                    yind = 2;
                }
                this.ptColors[i] = this.grid[xind][yind];
                bin.addColor(this.ptColors[i]);
            }
            ++i;
        }
    }
}

