/*
 * Decompiled with CFR 0.152.
 */
package scores;

import model.Sorter;
import scores.MSTMeasures;
import scores.Projection;
import scores.ProjectionInfo;

public class ScagnosticScorer {
    int numScagnostics = 9;
    int selectedScagnostic = -1;
    double[] allScag;

    public void setTypeSelection(int type) {
        this.selectedScagnostic = type;
    }

    public double score1DProjection(double[][] data, ProjectionInfo proj) {
        double[][] xx = Projection.getDataForProjection(data, proj);
        MSTMeasures m = new MSTMeasures();
        double score = -1.0;
        if (this.selectedScagnostic == 1) {
            score = m.computeClumpyMeasure(xx);
        } else if (this.selectedScagnostic == 0) {
            score = m.computeLVBOutlierMeasure(xx);
        } else if (this.selectedScagnostic == 2) {
            score = m.computeStriationMeasure(xx);
        } else if (this.selectedScagnostic == 4) {
            score = m.computeStringyMeasure(xx);
        } else if (this.selectedScagnostic == 3) {
            score = m.computeSparsenessMeasure(xx);
        }
        return score;
    }

    public double[] getAllScagnostics() {
        return this.allScag;
    }

    public ProjectionInfo[] sortProjections(ProjectionInfo[] projections) {
        int n = projections.length;
        ProjectionInfo[] res = new ProjectionInfo[n];
        double[] scores = new double[n];
        int i = 0;
        while (i < n) {
            scores[i] = projections[i].getScore();
            ++i;
        }
        int[] scoreIndices = Sorter.descendingSort(scores);
        int i2 = 0;
        while (i2 < n) {
            res[i2] = projections[scoreIndices[i2]];
            ++i2;
        }
        return res;
    }
}

