/*
 * Decompiled with CFR 0.152.
 */
package scores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import model.Utils;

public class kDBinner {
    private int[] counts;
    private int[] exemplars;
    private int[] members;
    private double[][] binnedData;
    private int[] binClassVals;

    public double[][] computeMeansClustering(double[][] pts, int nBins, int[] classVals) {
        int nPts = pts.length;
        if (nPts < 2) {
            return null;
        }
        this.exemplars = this.getRandomPoints(nPts, nBins);
        this.binnedData = this.getMembershipAndMeans(pts, this.exemplars, classVals);
        return this.binnedData;
    }

    public int[] getRandomPoints(int nPts, int nBins) {
        int[] res = new int[nBins];
        ArrayList<Integer> seen = new ArrayList<Integer>();
        Random random = new Random();
        int i = 0;
        while (i < nBins) {
            int index = random.nextInt(nPts);
            if (seen.contains(index)) continue;
            res[i] = index;
            seen.add(index);
            ++i;
        }
        return res;
    }

    public int[] getClosestPoints(double[][] data, double[][] means) {
        int nPts = data.length;
        int[] res = new int[nPts];
        int i = 0;
        while (i < nPts) {
            res[i] = this.closestPoint(data[i], means);
            ++i;
        }
        return res;
    }

    public double[][] getMembershipAndMeans(double[][] data, int[] centers, int[] classVals) {
        int nPts = data.length;
        int nVars = data[0].length;
        int nBins = centers.length;
        double[][] closeness = new double[nPts][2];
        double dmean = 0.0;
        double dstd = 0.0;
        double count = 0.0;
        int i = 0;
        while (i < nPts) {
            closeness[i] = this.closestPoint(data, i, centers);
            double xd = closeness[i][1] - dmean;
            dstd += xd * (closeness[i][1] - (dmean += xd / (count += 1.0)));
            ++i;
        }
        dstd = Math.sqrt(dstd / (count - 1.0));
        double threshold = dmean + 5.0 * dstd;
        System.out.println("KDBINNER: count:" + count + " mean: " + dmean + " std: " + dstd + " threshold: " + threshold + " nBins: " + nBins);
        this.members = new int[nPts];
        double[][] means = new double[nBins][nVars];
        HashMap[] binClasses = new HashMap[nBins];
        this.counts = new int[nBins];
        ArrayList<Integer> extras = new ArrayList<Integer>();
        int c = nBins;
        int i2 = 0;
        while (i2 < nPts) {
            double[] xd;
            int cc = this.isIn(centers, i2);
            if (cc != -1 && i2 == centers[cc]) {
                this.members[i2] = cc;
                int n = this.members[i2];
                this.counts[n] = this.counts[n] + 1;
                xd = Utils.minus(data[i2], means[this.members[i2]]);
                means[this.members[i2]] = Utils.add(means[this.members[i2]], Utils.divide(xd, this.counts[this.members[i2]]));
                if (classVals != null) {
                    if (binClasses[this.members[i2]] == null) {
                        binClasses[this.members[i2]] = new HashMap();
                    }
                    try {
                        int cval = (Integer)binClasses[this.members[i2]].get(new Integer(classVals[i2]));
                        binClasses[this.members[i2]].put(new Integer(classVals[i2]), cval + 1);
                    }
                    catch (Exception e) {
                        binClasses[this.members[i2]].put(new Integer(classVals[i2]), 1);
                    }
                }
            } else if (closeness[i2][1] > threshold) {
                extras.add(i2);
                this.members[i2] = c++;
            } else {
                this.members[i2] = (int)closeness[i2][0];
                int n = this.members[i2];
                this.counts[n] = this.counts[n] + 1;
                xd = Utils.minus(data[i2], means[this.members[i2]]);
                means[this.members[i2]] = Utils.add(means[this.members[i2]], Utils.divide(xd, this.counts[this.members[i2]]));
                if (classVals != null) {
                    if (binClasses[this.members[i2]] == null) {
                        binClasses[this.members[i2]] = new HashMap();
                    }
                    try {
                        int cval = (Integer)binClasses[this.members[i2]].get(new Integer(classVals[i2]));
                        binClasses[this.members[i2]].put(new Integer(classVals[i2]), cval + 1);
                    }
                    catch (Exception e) {
                        binClasses[this.members[i2]].put(new Integer(classVals[i2]), 1);
                    }
                }
            }
            ++i2;
        }
        double[][] res = new double[c][nVars];
        if (classVals != null) {
            this.binClassVals = new int[c];
        }
        int i3 = 0;
        while (i3 < nBins) {
            res[i3] = means[i3];
            if (classVals != null) {
                this.binClassVals[i3] = this.getModeClass(binClasses[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < extras.size()) {
            res[i3 + nBins] = data[(Integer)extras.get(i3)];
            if (classVals != null) {
                this.binClassVals[i3 + nBins] = classVals[(Integer)extras.get(i3)];
            }
            ++i3;
        }
        System.out.println("KDBINNER: # extras = " + extras.size() + " c: " + c);
        return res;
    }

    private int isIn(int[] array, int val) {
        int i = 0;
        while (i < array.length) {
            if (val == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getModeClass(HashMap<Integer, Integer> classCounts) {
        Iterator<Integer> ki = classCounts.keySet().iterator();
        int maxCount = -1;
        int mindex = -1;
        while (ki.hasNext()) {
            int key = ki.next();
            if (classCounts.get(key) <= maxCount) continue;
            maxCount = classCounts.get(key);
            mindex = key;
        }
        return mindex;
    }

    public int[] getBinClasses() {
        return this.binClassVals;
    }

    private double[] closestPoint(double[][] data, int index, int[] centers) {
        int mindex = -1;
        double mdist = Double.MAX_VALUE;
        int i = 0;
        while (i < centers.length) {
            double d = Utils.distance(data[index], data[centers[i]]);
            if (d < mdist) {
                mdist = d;
                mindex = i;
            }
            ++i;
        }
        return new double[]{mindex, mdist};
    }

    private int closestPoint(double[] data, double[][] means) {
        int mindex = -1;
        double mdist = Double.MAX_VALUE;
        int i = 0;
        while (i < means.length) {
            double d = Utils.distance(data, means[i]);
            if (d < mdist) {
                mdist = d;
                mindex = i;
            }
            ++i;
        }
        return mindex;
    }
}

