/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.mainMenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.data.DataSheet;
import org.xdat.gui.dialogs.ClusterDialog;
import org.xdat.workerThreads.DataSheetCreationThread;
import org.xdat.workerThreads.DataSheetUpdateThread;

public class MainDataMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;

    public MainDataMenuActionListener(Main mainWindow) {
        this.log("constructor called.");
        this.mainWindow = mainWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Import Data with Headers")) {
            if (this.mainWindow.getChartFrameCount() == 0 || JOptionPane.showConfirmDialog(this.mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", 2) == 0) {
                int returnVal;
                this.mainWindow.disposeAllChartFrames();
                JFileChooser chooser = new JFileChooser();
                if (UserPreferences.getInstance().getCurrentDir() != null) {
                    chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
                }
                if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                    String filepath = chooser.getSelectedFile().getAbsolutePath();
                    UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                    ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Importing Data...", 0, 100);
                    progressMonitor.setProgress(0);
                    DataSheetCreationThread sw = new DataSheetCreationThread(filepath, true, this.mainWindow, progressMonitor);
                    sw.execute();
                }
            }
        } else if (e.getActionCommand().equals("Import Data without Headers")) {
            if (this.mainWindow.getChartFrameCount() == 0 || JOptionPane.showConfirmDialog(this.mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", 2) == 0) {
                int returnVal;
                this.mainWindow.disposeAllChartFrames();
                JFileChooser chooser = new JFileChooser();
                if (UserPreferences.getInstance().getCurrentDir() != null) {
                    chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
                }
                if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                    String filepath = chooser.getSelectedFile().getAbsolutePath();
                    UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                    ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Importing Data...", 0, 100);
                    progressMonitor.setProgress(0);
                    DataSheetCreationThread sw = new DataSheetCreationThread(filepath, false, this.mainWindow, progressMonitor);
                    sw.execute();
                }
            }
        } else if (e.getActionCommand().equals("Update Data from File with Headers")) {
            int returnVal;
            this.log("update data from file with headers ");
            JFileChooser chooser = new JFileChooser();
            if (UserPreferences.getInstance().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Updating Data...", 0, 100);
                progressMonitor.setProgress(0);
                DataSheetUpdateThread sw = new DataSheetUpdateThread(filepath, true, this.mainWindow, progressMonitor);
                sw.execute();
            }
        } else if (e.getActionCommand().equals("Update Data from File without Headers")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            if (UserPreferences.getInstance().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Updating Data...", 0, 100);
                progressMonitor.setProgress(0);
                DataSheetUpdateThread sw = new DataSheetUpdateThread(filepath, false, this.mainWindow, progressMonitor);
                sw.execute();
            }
        } else if (e.getActionCommand().equals("Remove selected designs")) {
            DataSheet dataSheet = this.mainWindow.getDataSheet();
            if (dataSheet == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
            } else if (this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectedRowCount() < 1) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please select at least one design first.", "Remove Designs", 1);
            } else {
                int[] selection = this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectedRows();
                this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectionModel().clearSelection();
                this.mainWindow.getDataSheet().removeDesigns(selection);
            }
        } else if (e.getActionCommand().equals("Unselect all designs")) {
            DataSheet dataSheet = this.mainWindow.getDataSheet();
            if (dataSheet == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
            } else {
                this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectionModel().clearSelection();
            }
        } else if (e.getActionCommand().equals("Clustering")) {
            if (this.mainWindow.getDataSheet() == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
            } else {
                new ClusterDialog(this.mainWindow, this.mainWindow, this.mainWindow.getDataSheet());
            }
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

