/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.parallelCoordinatesChartFrame;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.dialogs.ParallelCoordinatesDisplaySettingsDialog;
import org.xdat.gui.frames.ChartFrame;

public class ChartFrameOptionsMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;
    private ParallelCoordinatesChart chart;
    private ChartFrame chartFrame;

    public ChartFrameOptionsMenuActionListener(Main mainWindow, ParallelCoordinatesChart chart, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.chart = chart;
        this.chartFrame = chartFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log("constructor called");
        if (e.getActionCommand().equals("Display Settings")) {
            new ParallelCoordinatesDisplaySettingsDialog(this.mainWindow, this.chart, this.chartFrame);
        } else if (e.getActionCommand().equals("Reset to Default")) {
            this.chart.resetDisplaySettingsToDefault();
            this.chartFrame.repaint();
        } else if (e.getActionCommand().equals("Export to png")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            if (UserPreferences.getInstance().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
            }
            if ((returnVal = chooser.showSaveDialog(this.chartFrame)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                String filename = chooser.getSelectedFile().getName();
                if (!filename.endsWith(".png")) {
                    filepath = String.valueOf(filepath) + ".png";
                }
                UserPreferences.getInstance().setLastFile(filepath);
                try {
                    BufferedImage bi = new BufferedImage(this.chartFrame.getChartPanel().getWidth(), this.chartFrame.getChartPanel().getHeight(), 2);
                    Graphics2D g = bi.createGraphics();
                    this.chartFrame.getChartPanel().paint(g);
                    g.dispose();
                    ImageIO.write((RenderedImage)bi, "png", new File(filepath));
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(this.chartFrame, "IOException on saving image: " + exc.getMessage(), "Export to Image", 0);
                }
            }
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

