/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.parallelCoordinatesChartFrame;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.xdat.Main;
import org.xdat.chart.Axis;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.tables.DataSheetTableColumnModel;

public class ParallelChartContextMenuActionListener
implements ActionListener {
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private Axis axis;

    public ParallelChartContextMenuActionListener(Main mainWindow, ChartFrame chartFrame, Axis axis) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.axis = axis;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("setCurrentFilterAsNewRange")) {
            this.axis.setFilterAsNewRange();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("resetFilter")) {
            this.axis.resetFilters();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("autofit")) {
            this.axis.autofit();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("moveAxisLeft")) {
            DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
            int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName());
            boolean jumpedAxisWasInactive = true;
            while (currentIndex > 0 && jumpedAxisWasInactive) {
                jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex - 1).isActive();
                cm.moveColumn(currentIndex + 1, currentIndex);
                --currentIndex;
            }
        } else if (actionCommand.equals("moveAxisRight")) {
            DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
            int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName());
            boolean jumpedAxisWasInactive = true;
            while (currentIndex + 2 < cm.getColumnCount() && jumpedAxisWasInactive) {
                jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex + 1).isActive();
                cm.moveColumn(currentIndex + 1, currentIndex + 2);
                ++currentIndex;
            }
        } else if (actionCommand.equals("hideAxis")) {
            this.axis.setActive(false);
            this.chartFrame.repaint();
        } else if (actionCommand.equals("addTic")) {
            this.axis.setTicCount(this.axis.getTicCount() + 1);
            this.chartFrame.repaint();
        } else if (actionCommand.equals("removeTic")) {
            this.axis.setTicCount(Math.max(2, this.axis.getTicCount() - 1));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("reduceDistanceThisAxis")) {
            this.axis.setWidth(Math.max(0, this.axis.getWidth() - 10));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("increaseDistanceThisAxis")) {
            this.axis.setWidth(Math.max(0, this.axis.getWidth() + 10));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("resetAllFilters")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).resetFilters();
                ++i;
            }
            this.chartFrame.repaint();
        } else if (actionCommand.equals("reduceDistanceAllAxes")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() - 10));
                ++i;
            }
            this.chartFrame.repaint();
        } else if (actionCommand.equals("increaseDistanceAllAxes")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() + 10));
                ++i;
            }
            this.chartFrame.repaint();
        } else if (actionCommand.equals("invertAxis")) {
            this.axis.setAxisInverted(!this.axis.isAxisInverted());
            this.chartFrame.repaint();
        } else if (actionCommand.equals("applyColorGradient")) {
            ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.chartFrame.getChart();
            DataSheet datasheet = chart.getDataSheet();
            double axisRange = this.axis.getMax() - this.axis.getMin();
            int designID = 0;
            while (designID < datasheet.getDesignCount()) {
                Design currentDesign = datasheet.getDesign(designID);
                double value = currentDesign.getDoubleValue(datasheet.getParameter(this.axis.getName()));
                if (axisRange == 0.0) {
                    currentDesign.setAxisGradientColor(new Color(0, 0, 255, 150));
                } else {
                    int b;
                    int g;
                    int r;
                    int alpha = 255;
                    double ratio = this.axis.isAxisInverted() ? (this.axis.getMax() - value) / axisRange : (value - this.axis.getMin()) / axisRange;
                    if (ratio > 1.0 || ratio < 0.0) {
                        currentDesign.removeAxisGradientColor();
                    } else if (ratio > 0.9) {
                        ratio = ratio * 10.0 - 9.0;
                        r = 165 + (int)(50.0 * (1.0 - ratio));
                        g = (int)(48.0 * (1.0 - ratio));
                        b = 38 + (int)(1.0 * (1.0 - ratio));
                        this.log("9 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.8) {
                        ratio = ratio * 10.0 - 8.0;
                        r = 215 + (int)(29.0 * (1.0 - ratio));
                        g = 48 + (int)(61.0 * (1.0 - ratio));
                        b = 39 + (int)(28.0 * (1.0 - ratio));
                        this.log("8 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.7) {
                        ratio = ratio * 10.0 - 7.0;
                        r = 244 + (int)(9.0 * (1.0 - ratio));
                        g = 109 + (int)(65.0 * (1.0 - ratio));
                        b = 67 + (int)(30.0 * (1.0 - ratio));
                        this.log("7 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.6) {
                        ratio = ratio * 10.0 - 6.0;
                        r = 253 + (int)(1.0 * (1.0 - ratio));
                        g = 174 + (int)(50.0 * (1.0 - ratio));
                        b = 97 + (int)(47.0 * (1.0 - ratio));
                        this.log("6 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.5) {
                        ratio = ratio * 10.0 - 5.0;
                        r = 254 + (int)(1.0 * (1.0 - ratio));
                        g = 224 + (int)(31.0 * (1.0 - ratio));
                        b = 144 + (int)(47.0 * (1.0 - ratio));
                        this.log("5 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.4) {
                        ratio = ratio * 10.0 - 4.0;
                        r = 255 - (int)(31.0 * ratio);
                        g = 255 - (int)(12.0 * ratio);
                        b = 191 + (int)(57.0 * (1.0 - ratio));
                        this.log("4 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.3) {
                        ratio = ratio * 10.0 - 3.0;
                        r = 224 - (int)(53.0 * ratio);
                        g = 243 - (int)(26.0 * ratio);
                        b = 248 - (int)(15.0 * ratio);
                        this.log("3 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.2) {
                        ratio = ratio * 10.0 - 2.0;
                        r = 171 - (int)(55.0 * ratio);
                        g = 217 - (int)(44.0 * ratio);
                        b = 233 - (int)(24.0 * ratio);
                        this.log("2 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else if (ratio > 0.1) {
                        ratio = ratio * 10.0 - 1.0;
                        r = 116 - (int)(67.0 * ratio);
                        g = 173 - (int)(56.0 * ratio);
                        b = 209 - (int)(29.0 * ratio);
                        this.log("1 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    } else {
                        r = 69 - (int)(20.0 * (ratio *= 10.0));
                        g = 117 - (int)(63.0 * ratio);
                        b = 180 - (int)(31.0 * ratio);
                        this.log("0 " + r + "," + g + "," + b);
                        currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                    }
                }
                ++designID;
            }
            this.mainWindow.repaintAllChartFrames();
        } else if (actionCommand.equals("resetColorGradient")) {
            DataSheet datasheet = this.chartFrame.getChart().getDataSheet();
            int designID = 0;
            while (designID < datasheet.getDesignCount()) {
                datasheet.getDesign(designID).removeAxisGradientColor();
                ++designID;
            }
            this.mainWindow.repaintAllChartFrames();
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

