/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.parallelCoordinatesChartFrame;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;
import org.xdat.gui.buttons.ColorChoiceButton;
import org.xdat.gui.panels.ParallelCoordinatesChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartSidebarPanel;

public class ParallelChartSidebarActionListener
implements ActionListener,
ChangeListener {
    static final boolean printLog = false;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private ParallelCoordinatesChartSidebarPanel sidePanel;
    private Main mainWindow;
    private ParallelCoordinatesChartPanel chartPanel;
    private Color activeDesignColor;

    public ParallelChartSidebarActionListener(Main mainWindow, ParallelCoordinatesChartSidebarPanel panel, ParallelCoordinatesChartPanel chartPanel) {
        this.mainWindow = mainWindow;
        this.sidePanel = panel;
        this.chartPanel = chartPanel;
        this.activeDesignColor = ((ParallelCoordinatesChart)chartPanel.getChart()).getDefaultDesignColor(true, chartPanel.getChart().isUseAlpha());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.chartPanel.getChart();
        if (actionCommand.equals("Active Design Color")) {
            Color newColor = JColorChooser.showDialog(this.sidePanel.getChartFrame(), "Background Color", this.activeDesignColor);
            if (newColor != null) {
                if (newColor.getAlpha() == 255) {
                    int alphaValue = this.sidePanel.getActiveDesignAlphaSlider().getValue();
                    newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), alphaValue);
                }
                this.activeDesignColor = newColor;
                chart.setActiveDesignColor(newColor);
                this.sidePanel.getActiveDesignColorButton().setCurrentColor(this.activeDesignColor);
                this.sidePanel.getActiveDesignAlphaSlider().setValue(newColor.getAlpha());
                this.chartPanel.repaint();
            }
        } else if (actionCommand.equals("Add Cluster")) {
            DataSheet data = this.mainWindow.getDataSheet();
            data.getClusterSet().createBuffer();
            data.getClusterSet().addClusterToBuffer();
            data.getClusterSet().applyChanges();
            this.sidePanel.updateClusterList(data.getClusterSet());
        } else if (actionCommand.equals("Remove")) {
            JButton button = (JButton)e.getSource();
            ClusterSet clusterSet = this.mainWindow.getDataSheet().getClusterSet();
            clusterSet.createBuffer();
            clusterSet.removeClusterFromBuffer(button.getName());
            clusterSet.applyChanges();
            this.sidePanel.updateClusterList(clusterSet);
            this.chartPanel.revalidate();
            this.chartPanel.repaint();
        } else if (actionCommand.equals("Apply")) {
            JButton button = (JButton)e.getSource();
            DataSheet dataSheet = chart.getDataSheet();
            Cluster cluster = dataSheet.getClusterSet().getCluster(button.getName());
            int i = 0;
            while (i < dataSheet.getDesignCount()) {
                if (dataSheet.getDesign(i).isActive(chart)) {
                    dataSheet.getDesign(i).setCluster(cluster);
                }
                ++i;
            }
            this.chartPanel.setPreferredSize(this.chartPanel.getPreferredSize());
            i = 0;
            while (i < this.mainWindow.getChartFrameCount()) {
                this.mainWindow.getChartFrame(i).validate();
                this.mainWindow.getChartFrame(i).repaint();
                ++i;
            }
        } else if (actionCommand.equals("Active")) {
            JCheckBox checkBox = (JCheckBox)e.getSource();
            ClusterSet clusterSet = this.mainWindow.getDataSheet().getClusterSet();
            clusterSet.getCluster(checkBox.getName()).setActive(checkBox.isSelected());
            int i = 0;
            while (i < this.mainWindow.getChartFrameCount()) {
                this.mainWindow.getChartFrame(i).validate();
                this.mainWindow.getChartFrame(i).repaint();
                ++i;
            }
        } else if (actionCommand.equals("clusterColor")) {
            ColorChoiceButton button = (ColorChoiceButton)e.getSource();
            Cluster cluster = this.mainWindow.getDataSheet().getClusterSet().getCluster(button.getName());
            Color newColor = JColorChooser.showDialog(this.sidePanel.getChartFrame(), "Cluster Color", cluster.getActiveDesignColor(true));
            if (newColor != null) {
                if (newColor.getAlpha() == 255) {
                    int alpha = this.sidePanel.getClusterAlphaSlider(cluster).getValue();
                    newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), alpha);
                }
                cluster.setActiveDesignColor(newColor);
                button.setCurrentColor(newColor);
                this.sidePanel.getClusterAlphaSlider(cluster).setValue(newColor.getAlpha());
                this.chartPanel.repaint();
            }
        } else {
            this.log(e.getActionCommand());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.chartPanel.getChart();
        if (source instanceof JSlider) {
            JSlider slider = (JSlider)source;
            int value = slider.getValue();
            if (slider.getName().equals("activeDesignAlphaSlider")) {
                Color newColor;
                this.activeDesignColor = newColor = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue(), value);
                chart.setActiveDesignColor(newColor);
                this.sidePanel.getActiveDesignColorButton().setCurrentColor(this.activeDesignColor);
                this.sidePanel.getActiveDesignAlphaSlider().setValue(slider.getValue());
                this.chartPanel.repaint();
                Color oldDefaultColor = UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor();
                UserPreferences.getInstance().setParallelCoordinatesActiveDesignDefaultColor(new Color(oldDefaultColor.getRed(), oldDefaultColor.getGreen(), oldDefaultColor.getBlue(), value));
            } else {
                Cluster cluster = this.mainWindow.getDataSheet().getClusterSet().getCluster(slider.getName());
                if (cluster != null) {
                    Color newColor = new Color(cluster.getActiveDesignColor(true).getRed(), cluster.getActiveDesignColor(true).getGreen(), cluster.getActiveDesignColor(true).getBlue(), value);
                    cluster.setActiveDesignColor(newColor);
                    this.chartPanel.repaint();
                }
            }
        } else {
            this.log("ParallelChartSidebarActionListener: " + e.toString());
        }
    }

    private void log(String message) {
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }
}

